/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;

public class SqlIndexesSystemViewTest
extends GridCommonAbstractTest {
    private Ignite driver;
    private boolean client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setClientMode(this.client).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    protected void beforeTest() throws Exception {
        this.driver = this.startGrid(0);
        this.driver.cluster().active(true);
        this.driver.cluster().setBaselineTopology(Collections.singleton(this.grid(0).localNode()));
        this.startGrid(1);
        this.client = true;
        this.startGrid(3);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testNoTablesNoIndexes() throws Exception {
        this.checkIndexes(List::isEmpty);
    }

    @Test
    public void testDdlTableIndexes() throws Exception {
        SqlIndexesSystemViewTest.execSql(this.driver, "CREATE TABLE Person(id INT PRIMARY KEY, name VARCHAR, age INT)");
        List<Object> expInit = Arrays.asList(Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK", "BTREE", "\"ID\" ASC", true, true, 5), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK_hash", "HASH", "\"ID\" ASC", false, true, null));
        this.checkIndexes(expInit::equals);
        this.driver.cluster().active(false);
        for (Ignite ign : G.allGrids()) {
            GridTestUtils.assertThrowsWithCause(() -> SqlIndexesSystemViewTest.execSql(ign, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".INDEXES ORDER BY TABLE_NAME, INDEX_NAME"), IgniteException.class);
        }
        this.driver.cluster().active(true);
        this.checkIndexes(expInit::equals);
        try {
            SqlIndexesSystemViewTest.execSql(this.driver, "CREATE INDEX NameIdx ON Person(surname)");
            SqlIndexesSystemViewTest.fail((String)"Exception expected");
        }
        catch (IgniteSQLException igniteSQLException) {
        }
        this.checkIndexes(expInit::equals);
        SqlIndexesSystemViewTest.execSql(this.driver, "CREATE INDEX NameIdx ON Person(name)");
        List<Object> expWithSecondary = Arrays.asList(Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "NAMEIDX", "BTREE", "\"NAME\" ASC, \"ID\" ASC", false, false, 15), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK", "BTREE", "\"ID\" ASC", true, true, 5), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK_hash", "HASH", "\"ID\" ASC", false, true, null));
        this.checkIndexes(expWithSecondary::equals);
        SqlIndexesSystemViewTest.execSql(this.driver, "DROP INDEX NameIdx");
        this.checkIndexes(expInit::equals);
        SqlIndexesSystemViewTest.execSql(this.driver, "CREATE INDEX CompIdx ON Person(name, age)");
        List<Object> expWithCompound = Arrays.asList(Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "COMPIDX", "BTREE", "\"NAME\" ASC, \"AGE\" ASC, \"ID\" ASC", false, false, 20), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK", "BTREE", "\"ID\" ASC", true, true, 5), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK_hash", "HASH", "\"ID\" ASC", false, true, null));
        this.checkIndexes(expWithCompound::equals);
        SqlIndexesSystemViewTest.execSql(this.driver, "DROP TABLE Person");
        this.checkIndexes(List::isEmpty);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/IGNITE-11125")
    @Test
    public void testDdlTableIndexes2() throws Exception {
        SqlIndexesSystemViewTest.execSql(this.driver, "CREATE TABLE Person(id1 INT, id2 INT, name VARCHAR, age INT, PRIMARY KEY (id1, id2))");
        List<Object> expInit = Arrays.asList(Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK", "BTREE", "\"ID1\" ASC, \"ID2\" ASC", true, true, 10), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK_hash", "HASH", "\"ID1\" ASC, \"ID2\" ASC", false, true, null));
        this.checkIndexes(expInit::equals);
        SqlIndexesSystemViewTest.execSql(this.driver, "CREATE INDEX CompIdx ON Person(name, age)");
        List<Object> expWithSecondary = Arrays.asList(Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "COMPIDX", "BTREE", "\"NAME\" ASC, \"AGE\" ASC, \"ID1\" ASC, \"ID2\" ASC", false, false, 10), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK", "BTREE", "\"ID1\" ASC, \"ID2\" ASC", true, true, 10), Arrays.asList(-1447683814, "SQL_PUBLIC_PERSON", -1447683814, "SQL_PUBLIC_PERSON", "PUBLIC", "PERSON", "_key_PK_hash", "HASH", "\"ID1\" ASC, \"ID2\" ASC", false, true, null));
        this.checkIndexes(expWithSecondary::equals);
    }

    @Test
    public void testQueryEntityIndexes() throws Exception {
        this.driver.createCache(new CacheConfiguration("cache").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i"))))));
        List<Object> expCache = Arrays.asList(Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        this.checkIndexes(expCache::equals);
        this.driver.destroyCache("cache");
        this.checkIndexes(List::isEmpty);
        List<Object> expGrpBoth = Arrays.asList(Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(98629247, "group", -1368047377, "cache1", "cache1", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        List<Object> expGrpSingle = Arrays.asList(Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "TESTVALUE_I_ASC_IDX", "BTREE", "\"I\" ASC, \"_KEY\" ASC", false, false, 10), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(98629247, "group", -1368047376, "cache2", "cache2", "TESTVALUE", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        this.driver.createCache(new CacheConfiguration("cache1").setGroupName("group").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i"))))));
        this.driver.createCache(new CacheConfiguration("cache2").setGroupName("group").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, TestValue.class).setIndexes(Collections.singleton(new QueryIndex("i"))))));
        this.checkIndexes(expGrpBoth::equals);
        this.driver.destroyCache("cache1");
        this.checkIndexes(expGrpSingle::equals);
    }

    @Test
    public void testTextIndex() throws Exception {
        IgniteCache cache = this.driver.createCache(new CacheConfiguration("cache").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, String.class))));
        cache.put((Object)1, (Object)"john");
        cache.put((Object)2, (Object)"jack");
        List res = cache.query((Query)new TextQuery("String", "john")).getAll().stream().map(e -> new T2(e.getKey(), e.getValue())).collect(Collectors.toList());
        SqlIndexesSystemViewTest.assertEqualsCollections(Collections.singleton(new T2((Object)1, (Object)"john")), res);
        List<Object> expIdxs = Arrays.asList(Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "STRING", "STRING__VAL_IDX", "BTREE", "\"_VAL\" ASC, \"_KEY\" ASC", false, false, 15), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "STRING", "__SCAN_", "SCAN", null, false, false, null), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "STRING", "_key_PK", "BTREE", "\"_KEY\" ASC", true, true, 5), Arrays.asList(94416770, "cache", 94416770, "cache", "cache", "STRING", "_key_PK_hash", "HASH", "\"_KEY\" ASC", false, true, null));
        this.checkIndexes(expIdxs::equals);
    }

    private void checkIndexes(Predicate<List<List<?>>> checker) throws Exception {
        for (Ignite ign : G.allGrids()) {
            SqlIndexesSystemViewTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
                List<List<?>> indexes = SqlIndexesSystemViewTest.execSql(ign, "SELECT * FROM " + QueryUtils.sysSchemaName() + ".INDEXES ORDER BY CACHE_NAME, INDEX_NAME");
                return checker.test(indexes);
            }, (long)1000L));
        }
    }

    private static List<List<?>> execSql(Ignite ign, String sql) {
        return ((IgniteEx)ign).context().query().querySqlFields(new SqlFieldsQuery(sql), false).getAll();
    }

    public static class TestValue {
        @QuerySqlField
        int i;
    }
}

