/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class MultipleStatementsSqlQuerySelfTest
extends AbstractIndexingCommonTest {
    private IgniteEx node;

    protected void beforeTest() throws Exception {
        this.node = this.startGrid();
        this.startGrid(2);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testQuery() {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery("-- Creating table \ncreate table test(ID int primary key, NAME varchar(20));  -- Adding data \ninsert into test (ID, NAME) values (1, 'name_1');insert into test (ID, NAME) values (2, 'name_2'), (3, 'name_3'); -- Query data \nselect * from test; -- All done.").setSchema("PUBLIC");
        List res = qryProc.querySqlFields(qry, true, false);
        assert (res.size() == 4) : "Unexpected cursors count: " + res.size();
        assert (!((QueryCursorImpl)res.get(0)).isQuery()) : "Results of DDL statement is expected ";
        List rows = ((FieldsQueryCursor)res.get(1)).getAll();
        assert (!((QueryCursorImpl)res.get(1)).isQuery()) : "Results of DDL statement is expected ";
        assert (Long.valueOf(1L).equals(((List)rows.get(0)).get(0))) : "1 row must be updated. [actual=" + ((List)rows.get(0)).get(0) + ']';
        rows = ((FieldsQueryCursor)res.get(2)).getAll();
        assert (!((QueryCursorImpl)res.get(2)).isQuery()) : "Results of DML statement is expected ";
        assert (Long.valueOf(2L).equals(((List)rows.get(0)).get(0))) : "2 row must be updated";
        rows = ((FieldsQueryCursor)res.get(3)).getAll();
        assert (((QueryCursorImpl)res.get(3)).isQuery()) : "Results of SELECT statement is expected ";
        assert (rows.size() == 3) : "Invalid rows count: " + rows.size();
        for (int i = 0; i < rows.size(); ++i) {
            assert (Integer.valueOf(1).equals(((List)rows.get(i)).get(0)) || Integer.valueOf(2).equals(((List)rows.get(i)).get(0)) || Integer.valueOf(3).equals(((List)rows.get(i)).get(0))) : "Invalid ID: " + ((List)rows.get(i)).get(0);
        }
    }

    @Test
    public void testCorrectWithLazy() {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery("DROP TABLE IF EXISTS CITY;\nCREATE TABLE CITY (\n  ID INT,\n  Name VARCHAR,\n  CountryCode CHAR(3),\n  District VARCHAR,\n  Population INT,\n  TimeS TIMESTAMP,\n  PRIMARY KEY (ID)\n);INSERT INTO City(ID, Name, CountryCode, District, Population, TimeS) VALUES (1,'Kabul','AFG','Kabol',1780000, CURRENT_TIMESTAMP());\nINSERT INTO City(ID, Name, CountryCode, District, Population, TimeS) VALUES (2,'Qandahar','AFG','Qandahar',237500, CURRENT_TIMESTAMP());\nSELECT * FROM City;SELECT * FROM City;INSERT INTO City(ID, Name, CountryCode, District, Population, TimeS) VALUES (3,'Herat','AFG','Herat',186800,null);SELECT * FROM City;");
        qry.setLazy(true);
        List res = qryProc.querySqlFields(qry, true, false);
        ((FieldsQueryCursor)res.get(4)).close();
        MultipleStatementsSqlQuerySelfTest.assertFalse((boolean)((FieldsQueryCursor)res.get(5)).getAll().isEmpty());
        MultipleStatementsSqlQuerySelfTest.assertEquals((int)3, (int)((FieldsQueryCursor)res.get(7)).getAll().size());
    }

    @Test
    public void testQueryWithParameters() {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery("create table test(ID int primary key, NAME varchar(20)); insert into test (ID, NAME) values (?, ?);insert into test (ID, NAME) values (?, ?), (?, ?);select * from test;").setSchema("PUBLIC").setArgs(new Object[]{1, "name_1", 2, "name2", 3, "name_3"});
        List res = qryProc.querySqlFields(qry, true, false);
        assert (res.size() == 4) : "Unexpected cursors count: " + res.size();
        assert (!((QueryCursorImpl)res.get(0)).isQuery()) : "Results of DDL statement is expected ";
        List rows = ((FieldsQueryCursor)res.get(1)).getAll();
        assert (!((QueryCursorImpl)res.get(1)).isQuery()) : "Results of DDL statement is expected ";
        assert (Long.valueOf(1L).equals(((List)rows.get(0)).get(0))) : "1 row must be updated. [actual=" + ((List)rows.get(0)).get(0) + ']';
        rows = ((FieldsQueryCursor)res.get(2)).getAll();
        assert (!((QueryCursorImpl)res.get(2)).isQuery()) : "Results of DML statement is expected ";
        assert (Long.valueOf(2L).equals(((List)rows.get(0)).get(0))) : "2 row must be updated";
        rows = ((FieldsQueryCursor)res.get(3)).getAll();
        assert (((QueryCursorImpl)res.get(3)).isQuery()) : "Results of SELECT statement is expected ";
        assert (rows.size() == 3) : "Invalid rows count: " + rows.size();
        for (int i = 0; i < rows.size(); ++i) {
            assert (Integer.valueOf(1).equals(((List)rows.get(i)).get(0)) || Integer.valueOf(2).equals(((List)rows.get(i)).get(0)) || Integer.valueOf(3).equals(((List)rows.get(i)).get(0))) : "Invalid ID: " + ((List)rows.get(i)).get(0);
        }
    }

    @Test
    public void testQueryMultipleStatementsFailed() {
        final SqlFieldsQuery qry = new SqlFieldsQuery("select 1; select 1;").setSchema("PUBLIC");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                MultipleStatementsSqlQuerySelfTest.this.node.context().query().querySqlFields(qry, true, true);
                return null;
            }
        }, IgniteSQLException.class, (String)"Multiple statements queries are not supported");
    }

    @Test
    public void testCachedTwoSteps() {
        List<FieldsQueryCursor<List<?>>> curs = this.sql("SELECT 1; SELECT 2");
        MultipleStatementsSqlQuerySelfTest.assertEquals((int)2, (int)curs.size());
        MultipleStatementsSqlQuerySelfTest.assertEquals((Object)1, ((List)curs.get(0).getAll().get(0)).get(0));
        MultipleStatementsSqlQuerySelfTest.assertEquals((Object)2, ((List)curs.get(1).getAll().get(0)).get(0));
        curs = this.sql("SELECT 1; SELECT 2");
        MultipleStatementsSqlQuerySelfTest.assertEquals((int)2, (int)curs.size());
        MultipleStatementsSqlQuerySelfTest.assertEquals((Object)1, ((List)curs.get(0).getAll().get(0)).get(0));
        MultipleStatementsSqlQuerySelfTest.assertEquals((Object)2, ((List)curs.get(1).getAll().get(0)).get(0));
    }

    private List<FieldsQueryCursor<List<?>>> sql(String sql) {
        GridQueryProcessor qryProc = this.node.context().query();
        SqlFieldsQuery qry = new SqlFieldsQuery(sql).setSchema("PUBLIC");
        return qryProc.querySqlFields(qry, true, false);
    }
}

