/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.LongRunningQueryManager;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class LongRunningQueryThrottlingTest
extends AbstractIndexingCommonTest {
    private static final int QRY_PARALLELISM = 10;
    private static final int KEY_CNT = 10000;
    private boolean local;
    private boolean lazy;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid();
        IgniteCache c = this.grid().createCache(new CacheConfiguration().setName("test").setSqlSchema("TEST").setQueryEntities(Collections.singleton(new QueryEntity(Long.class, Long.class).setTableName("test").addQueryField("id", Long.class.getName(), null).addQueryField("val", Long.class.getName(), null).setKeyFieldName("id").setValueFieldName("val"))).setQueryParallelism(10).setSqlFunctionClasses(new Class[]{GridTestUtils.SqlTestFunctions.class}));
        for (long i = 0L; i < 10000L; ++i) {
            c.put((Object)i, (Object)i);
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testLongDistributed() {
        this.local = false;
        this.lazy = false;
        this.checkLongRunning();
    }

    @Test
    public void testLongLocal() {
        this.local = true;
        this.lazy = false;
        this.checkLongRunning();
    }

    private void checkLongRunning() {
        ListeningTestLogger testLog = this.testLog();
        AtomicInteger msgCnt = new AtomicInteger();
        LogListener lsnr = LogListener.matches(s -> {
            if (s.contains("Query execution is too long")) {
                msgCnt.incrementAndGet();
                return true;
            }
            return false;
        }).build();
        testLog.registerListener(lsnr);
        this.sqlCheckLongRunning();
        LongRunningQueryThrottlingTest.assertTrue((boolean)lsnr.check());
        LongRunningQueryThrottlingTest.assertEquals((int)1, (int)msgCnt.get());
    }

    private void sqlCheckLongRunning(String sql, Object ... args) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> this.sql(sql, args).getAll(), QueryCancelledException.class, (String)"");
    }

    private void sqlCheckLongRunning() {
        this.sqlCheckLongRunning("SELECT T0.id, delay(100) FROM test AS T0, test AS T1, test AS T2 where T0.id > ?", 0);
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.grid().context().query().querySqlFields(new SqlFieldsQueryEx(sql, Boolean.valueOf(true)).setTimeout(10, TimeUnit.SECONDS).setLocal(this.local).setLazy(this.lazy).setSchema("TEST").setArgs(args), false);
    }

    private ListeningTestLogger testLog() {
        ListeningTestLogger testLog = new ListeningTestLogger(false, log);
        GridTestUtils.setFieldValue((Object)this.longRunningQueryManager(), (String)"log", (Object)testLog);
        GridTestUtils.setFieldValue((Object)((IgniteH2Indexing)this.grid().context().query().getIndexing()).mapQueryExecutor(), (String)"log", (Object)testLog);
        GridTestUtils.setFieldValue((Object)this.grid().context().query().getIndexing(), (String)"log", (Object)testLog);
        return testLog;
    }

    private LongRunningQueryManager longRunningQueryManager() {
        return ((IgniteH2Indexing)this.grid().context().query().getIndexing()).longRunningQueries();
    }
}

