/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteSqlSkipReducerOnUpdateDmlSelfTest
extends AbstractIndexingCommonTest {
    private static int NODE_COUNT = 4;
    private static String NODE_CLIENT = "client";
    private static String CACHE_ORG = "org";
    private static String CACHE_PERSON = "person";
    private static String CACHE_POSITION = "pos";
    private static Ignite client;
    private static CountDownLatch latch;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        ccfgs.add(this.buildCacheConfiguration(CACHE_ORG));
        ccfgs.add(this.buildCacheConfiguration(CACHE_PERSON));
        ccfgs.add(this.buildCacheConfiguration(CACHE_POSITION));
        c.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        c.setSqlConfiguration(new SqlConfiguration().setLongQueryWarningTimeout(10000L));
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
        }
        c.setIncludeEventTypes(EventType.EVTS_ALL);
        return c;
    }

    private CacheConfiguration buildCacheConfiguration(String name) {
        if (name.equals(CACHE_ORG)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_ORG);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(Integer.class, Organization.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            ccfg.setSqlFunctionClasses(new Class[]{IgniteSqlSkipReducerOnUpdateDmlSelfTest.class});
            return ccfg;
        }
        if (name.equals(CACHE_PERSON)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_PERSON);
            ccfg.setCacheMode(CacheMode.PARTITIONED);
            QueryEntity entity = new QueryEntity(PersonKey.class, Person.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            ccfg.setKeyConfiguration(new CacheKeyConfiguration[]{new CacheKeyConfiguration(PersonKey.class)});
            ccfg.setSqlFunctionClasses(new Class[]{IgniteSqlSkipReducerOnUpdateDmlSelfTest.class});
            return ccfg;
        }
        if (name.equals(CACHE_POSITION)) {
            CacheConfiguration ccfg = new CacheConfiguration(CACHE_POSITION);
            ccfg.setCacheMode(CacheMode.REPLICATED);
            QueryEntity entity = new QueryEntity(Integer.class, Position.class);
            ccfg.setQueryEntities(Collections.singletonList(entity));
            ccfg.setSqlFunctionClasses(new Class[]{IgniteSqlSkipReducerOnUpdateDmlSelfTest.class});
            return ccfg;
        }
        assert (false);
        return null;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(NODE_COUNT);
        client = this.startGrid(NODE_CLIENT);
        this.awaitPartitionMapExchange();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.checkNoLeaks();
        client = null;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopGrid(NODE_COUNT + 1);
        this.awaitPartitionMapExchange();
        client.cache(CACHE_PERSON).clear();
        client.cache(CACHE_ORG).clear();
        client.cache(CACHE_POSITION).clear();
    }

    @Test
    public void testSimpleUpdateDistributedReplicated() throws Exception {
        this.fillCaches();
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_POSITION);
        Position p = (Position)cache.get((Object)1);
        List r = cache.query(new SqlFieldsQuery("UPDATE Position p SET name = CONCAT('A ', name)").setSkipReducerOnUpdate(true)).getAll();
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertEquals((Object)cache.size(new CachePeekMode[0]), ((List)r.get(0)).get(0));
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertEquals((String)((Position)cache.get((Object)Integer.valueOf((int)1))).name, (String)("A " + p.name));
    }

    @Test
    public void testSimpleUpdateDistributedPartitioned() throws Exception {
        this.fillCaches();
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        List r = cache.query(new SqlFieldsQuery("UPDATE Person SET position = CASEWHEN(position = 1, 1, position - 1)").setSkipReducerOnUpdate(true)).getAll();
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertEquals((Object)cache.size(new CachePeekMode[0]), ((List)r.get(0)).get(0));
    }

    @Test
    public void testDistributedUpdateFailedKeys() throws Exception {
        this.fillCaches();
        final IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_ORG);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return cache.query(new SqlFieldsQuery("UPDATE Organization SET rate = Modify(_key, rate - 1)").setSkipReducerOnUpdate(true));
            }
        }, CacheException.class, (String)"Failed to update some keys because they had been modified concurrently");
    }

    @Test
    public void testDistributedUpdateFail() throws Exception {
        this.fillCaches();
        final IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return cache.query(new SqlFieldsQuery("UPDATE Person SET name = Fail(name)").setSkipReducerOnUpdate(true));
            }
        }, CacheException.class, (String)"Failed to run SQL update query.");
    }

    @Test
    public void testQueryParallelism() throws Exception {
        String cacheName = CACHE_ORG + "x4";
        CacheConfiguration cfg = this.buildCacheConfiguration(CACHE_ORG).setQueryParallelism(4).setName(cacheName);
        IgniteCache cache = this.grid(NODE_CLIENT).createCache(cfg);
        for (int i = 0; i < 1024; ++i) {
            cache.put((Object)i, (Object)new Organization("Acme Inc #" + i, 0));
        }
        List r = cache.query(new SqlFieldsQuery("UPDATE \"" + cacheName + "\".Organization o SET name = UPPER(name)").setSkipReducerOnUpdate(true)).getAll();
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertEquals((Object)cache.size(new CachePeekMode[0]), ((List)r.get(0)).get(0));
    }

    @Test
    public void testEvents() throws Exception {
        final CountDownLatch latch = new CountDownLatch(NODE_COUNT);
        IgnitePredicate<Event> pred = new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                assert (evt instanceof CacheQueryExecutedEvent);
                CacheQueryExecutedEvent qe = (CacheQueryExecutedEvent)evt;
                IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertNotNull((Object)qe.clause());
                latch.countDown();
                return true;
            }
        };
        for (int idx = 0; idx < NODE_COUNT; ++idx) {
            this.grid(idx).events().localListen((IgnitePredicate)pred, new int[]{96});
        }
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_ORG);
        for (int i = 0; i < 1024; ++i) {
            cache.put((Object)i, (Object)new Organization("Acme Inc #" + i, 0));
        }
        cache.query(new SqlFieldsQuery("UPDATE \"org\".Organization o SET name = UPPER(name)").setSkipReducerOnUpdate(true)).getAll();
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        for (int idx = 0; idx < NODE_COUNT; ++idx) {
            this.grid(idx).events().stopLocalListen((IgnitePredicate)pred, new int[0]);
        }
    }

    @Test
    public void testSpecificPartitionsUpdate() throws Exception {
        this.fillCaches();
        Affinity aff = this.grid(NODE_CLIENT).affinity(CACHE_PERSON);
        int numParts = aff.partitions();
        int[] parts = new int[numParts / 2];
        for (int idx = 0; idx < numParts / 2; ++idx) {
            parts[idx] = idx * 2;
        }
        IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_PERSON);
        cache.query(new SqlFieldsQuery("UPDATE Person SET position = 0").setSkipReducerOnUpdate(true).setPartitions(parts));
        List rows = cache.query(new SqlFieldsQuery("SELECT _key, position FROM Person")).getAll();
        for (List row : rows) {
            PersonKey personKey = (PersonKey)row.get(0);
            int pos = ((Number)row.get(1)).intValue();
            int part = aff.partition((Object)personKey);
            IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertTrue((boolean)(part % 2 == 0 ^ pos != 0));
        }
    }

    @Test
    public void testCancel() throws Exception {
        latch = new CountDownLatch(NODE_COUNT + 1);
        this.fillCaches();
        final IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_ORG);
        final IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return cache.query(new SqlFieldsQuery("UPDATE Organization SET name = WAIT(name)").setSkipReducerOnUpdate(true));
            }
        });
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                Collection qCol = IgniteSqlSkipReducerOnUpdateDmlSelfTest.this.grid(NODE_CLIENT).context().query().runningQueries(0L);
                if (qCol.isEmpty()) {
                    return false;
                }
                for (GridRunningQueryInfo queryInfo : qCol) {
                    queryInfo.cancel();
                }
                return true;
            }
        }, (long)5000L);
        latch.await(5000L, TimeUnit.MILLISECONDS);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws IgniteCheckedException {
                return fut.get();
            }
        }, IgniteCheckedException.class, (String)"Future was cancelled");
    }

    @Test
    public void testNodeStopDuringUpdate() throws Exception {
        this.startGrid(NODE_COUNT + 1);
        this.awaitPartitionMapExchange();
        this.fillCaches();
        latch = new CountDownLatch(NODE_COUNT + 1 + 1);
        final IgniteCache cache = this.grid(NODE_CLIENT).cache(CACHE_ORG);
        final IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return cache.query(new SqlFieldsQuery("UPDATE Organization SET name = WAIT(name)").setSkipReducerOnUpdate(true));
            }
        });
        final CountDownLatch finalLatch = latch;
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return finalLatch.getCount() == 1L;
            }
        }, (long)5000L));
        latch.countDown();
        this.stopGrid(NODE_COUNT + 1);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws IgniteCheckedException {
                return fut.get();
            }
        }, IgniteCheckedException.class, (String)"Update failed because map node left topology");
    }

    private void checkNoLeaks() {
        GridQueryProcessor qryProc = this.grid(NODE_CLIENT).context().query();
        IgniteH2Indexing h2Idx = (IgniteH2Indexing)GridTestUtils.getFieldValue((Object)qryProc, GridQueryProcessor.class, (String)"idx");
        GridReduceQueryExecutor rdcQryExec = (GridReduceQueryExecutor)GridTestUtils.getFieldValue((Object)h2Idx, IgniteH2Indexing.class, (String)"rdcQryExec");
        Map updRuns = (Map)GridTestUtils.getFieldValue((Object)rdcQryExec, GridReduceQueryExecutor.class, (String)"updRuns");
        IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertEquals((int)0, (int)updRuns.size());
        for (int idx = 0; idx < NODE_COUNT; ++idx) {
            qryProc = this.grid(idx).context().query();
            h2Idx = (IgniteH2Indexing)GridTestUtils.getFieldValue((Object)qryProc, GridQueryProcessor.class, (String)"idx");
            GridMapQueryExecutor mapQryExec = (GridMapQueryExecutor)GridTestUtils.getFieldValue((Object)h2Idx, IgniteH2Indexing.class, (String)"mapQryExec");
            Map qryRess = (Map)GridTestUtils.getFieldValue((Object)mapQryExec, GridMapQueryExecutor.class, (String)"qryRess");
            for (Object obj : qryRess.values()) {
                Map updCancels = (Map)GridTestUtils.getFieldValue(obj, (String[])new String[]{"updCancels"});
                IgniteSqlSkipReducerOnUpdateDmlSelfTest.assertEquals((int)0, (int)updCancels.size());
            }
        }
    }

    private void fillCaches() {
        Position[] positions;
        IgniteEx client = this.grid(NODE_CLIENT);
        IgniteCache posCache = client.cache(CACHE_POSITION);
        for (Position pos : positions = new Position[]{new Position(1, "High Ranking Officer", 1), new Position(2, "Administrative worker", 3), new Position(3, "Worker", 7), new Position(4, "Security", 2), new Position(5, "Cleaner", 1)}) {
            posCache.put((Object)pos.id, (Object)pos);
        }
        String[] forms = new String[]{" Inc", " Co", " AG", " Industries"};
        String[] orgNames = new String[]{"Acme", "Sierra", "Mesa", "Umbrella", "Robotics"};
        String[] names = new String[]{"Mary", "John", "William", "Tom", "Basil", "Ann", "Peter"};
        IgniteCache personCache = client.cache(CACHE_PERSON);
        IgniteCache orgCache = client.cache(CACHE_ORG);
        int orgId = 0;
        int personId = 0;
        for (String orgName : this.produceCombination(orgNames, orgNames, forms)) {
            Organization org = new Organization(orgName, 1 + orgId);
            orgCache.put((Object)(++orgId), (Object)org);
            List<String> personNames = this.produceCombination(names, names, new String[]{"s"});
            int positionId = 0;
            int posCounter = 0;
            for (String name : personNames) {
                PersonKey pKey = new PersonKey(orgId, ++personId);
                if (positions[positionId].rate < posCounter++) {
                    posCounter = 0;
                    positionId = (positionId + 1) % positions.length;
                }
                Person person = new Person(name, positions[positionId].id, org.rate * positions[positionId].rate);
                personCache.put((Object)pKey, (Object)person);
            }
        }
    }

    private List<String> produceCombination(String[] a, String[] b, String[] ends) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s1 : a) {
            for (String s2 : b) {
                if (s1.equals(s2)) continue;
                String end = ends[ThreadLocalRandom.current().nextInt(ends.length)];
                res.add(s1 + " " + s2 + end);
            }
        }
        return res;
    }

    @QuerySqlFunction
    public static String Fail(String param) {
        throw new IgniteSQLException("Fail() called");
    }

    @QuerySqlFunction
    public static String Wait(String param) {
        try {
            if (latch.getCount() > 0L) {
                latch.countDown();
                latch.await(5000L, TimeUnit.MILLISECONDS);
            } else {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return param;
    }

    @QuerySqlFunction
    public static int Modify(final int id, final int rate) {
        try {
            GridTestUtils.runAsync((Callable)new Callable<Object>(){

                @Override
                public Object call() {
                    IgniteCache cache = client.cache(CACHE_ORG);
                    cache.put((Object)id, (Object)new Organization("Acme Inc #" + id, rate + 1));
                    return null;
                }
            }).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rate - 1;
    }

    private static class Position {
        @QuerySqlField
        int id;
        @QuerySqlField
        String name;
        @QuerySqlField
        int rate;

        public Position(int id, String name, int rate) {
            this.id = id;
            this.name = name;
            this.rate = rate;
        }
    }

    public static class Person {
        @QuerySqlField
        String name;
        @QuerySqlField
        int position;
        @QuerySqlField
        int amount;
        @QuerySqlField
        Date updated;

        private Person(String name, int position, int amount) {
            this.name = name;
            this.position = position;
            this.amount = amount;
            this.updated = new Date(System.currentTimeMillis());
        }

        public int hashCode() {
            return (this.name == null ? 0 : this.name.hashCode()) ^ this.position ^ this.amount ^ (this.updated == null ? 0 : this.updated.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(Person.class)) {
                return false;
            }
            Person other = (Person)obj;
            return F.eq((Object)this.name, (Object)other.name) && this.position == other.position && this.amount == other.amount && F.eq((Object)this.updated, (Object)other.updated);
        }
    }

    public static class PersonKey {
        @AffinityKeyMapped
        @QuerySqlField
        private Integer orgId;
        @QuerySqlField
        private Integer id;

        PersonKey(int orgId, int id) {
            this.orgId = orgId;
            this.id = id;
        }
    }

    private static class Organization {
        @QuerySqlField
        String name;
        @QuerySqlField
        int rate;
        @QuerySqlField
        Date updated;

        public Organization(String name, int rate) {
            this.name = name;
            this.rate = rate;
            this.updated = new Date(System.currentTimeMillis());
        }
    }
}

