/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteSqlSchemasDiffConfigurationsTest
extends AbstractIndexingCommonTest {
    private static final String SCHEMA_NAME_1 = "SCHEMA_1";
    private static final String SCHEMA_NAME_2 = "SCHEMA_2";
    private static final String SCHEMA_NAME_3 = "SCHEMA_3";
    private static final String SCHEMA_NAME_4 = "SCHEMA_4";

    private static String t(String schema, String tbl) {
        return schema + "." + tbl;
    }

    @After
    public void tearDown() {
        this.stopAllGrids();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-25468")
    @Test
    public void testNodeFailWhenJoinWithDiffCacheConfig() throws Exception {
        String cacheName = "test_cache";
        this.startGrid(this.createTestConf("ign1", SCHEMA_NAME_1, "test_cache"));
        GridTestUtils.assertThrowsWithCause(() -> this.startGrid(this.createTestConf("ign2", SCHEMA_NAME_2, "test_cache")), IgniteException.class);
    }

    @Test
    public void testDiffSqlSchemasCfgProp() throws Exception {
        this.startGrid(this.getConfiguration("ign1").setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{SCHEMA_NAME_1, SCHEMA_NAME_2})));
        this.startGrid(this.getConfiguration("ign2").setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{SCHEMA_NAME_3, SCHEMA_NAME_4})));
        List<List> exp = Arrays.asList(Arrays.asList(SCHEMA_NAME_1, "cache_1"), Arrays.asList(SCHEMA_NAME_2, "cache_2"), Arrays.asList(SCHEMA_NAME_3, "cache_3"), Arrays.asList(SCHEMA_NAME_4, "cache_4"));
        for (List row : exp) {
            this.grid("ign1").createCache(new CacheConfiguration((String)row.get(1)).setSqlSchema((String)row.get(0)));
        }
        List<List<?>> res = this.execSql("ign1", "SELECT SQL_SCHEMA, CACHE_NAME FROM " + IgniteSqlSchemasDiffConfigurationsTest.t(QueryUtils.sysSchemaName(), "CACHES") + " WHERE CACHE_NAME LIKE 'cache%' ORDER BY SQL_SCHEMA");
        Assert.assertEquals(exp, res);
    }

    private IgniteConfiguration createTestConf(String nodeName, String schemaName, String cacheName) throws Exception {
        return this.getConfiguration(nodeName).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(cacheName).setSqlSchema(schemaName)});
    }

    protected List<List<?>> execSql(String ignName, String qry) {
        return this.grid(ignName).context().query().querySqlFields(new SqlFieldsQuery(qry).setLazy(true), false).getAll();
    }
}

