/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;

public class IgniteSqlSchemaNameValidationTest
extends AbstractIndexingCommonTest {
    private static final List<String> INVALID_SCHEMA_NAMES = Arrays.asList(GridTestUtils.randomString((Random)new Random(), (int)10000000, (int)10000000), "", "\t", "\n");

    @After
    public void tearDown() {
        this.stopAllGrids();
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-25421")
    @Test
    public void testCreateCacheWithIllegalSchemaName() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        for (String name : INVALID_SCHEMA_NAMES) {
            GridTestUtils.assertThrowsWithCause(() -> ignite.createCache(new CacheConfiguration("test_cache").setSqlSchema(name)), IllegalArgumentException.class);
        }
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-25421")
    @Test
    public void testStartNodeWithIllegalSchemaNameCfg() {
        for (String name : INVALID_SCHEMA_NAMES) {
            GridTestUtils.assertThrowsWithCause(() -> this.startGrid(this.getConfiguration().setSqlConfiguration(new SqlConfiguration().setSqlSchemas(new String[]{name}))), IllegalArgumentException.class);
        }
    }
}

