/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteSqlQueryParallelismTest
extends AbstractIndexingCommonTest {
    private boolean isClient = false;
    private int qryParallelism = 4;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        cfg.setClientMode(this.isClient);
        CacheConfiguration ccfg1 = IgniteSqlQueryParallelismTest.cacheConfig("pers", Integer.class, Person2.class).setQueryParallelism(this.qryParallelism);
        CacheConfiguration ccfg2 = IgniteSqlQueryParallelismTest.cacheConfig("org", Integer.class, Organization.class).setQueryParallelism(this.qryParallelism);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg1, ccfg2});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3, false);
    }

    private static CacheConfiguration cacheConfig(String name, Class<?> ... idxTypes) {
        return new CacheConfiguration().setName(name).setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setIndexedTypes((Class[])idxTypes);
    }

    @Test
    public void testIndexSegmentationOnClient() throws Exception {
        IgniteCache c1 = this.ignite(0).cache("org");
        IgniteCache c2 = this.ignite(0).cache("pers");
        c1.put((Object)1, (Object)new Organization("o1"));
        c1.put((Object)2, (Object)new Organization("o2"));
        c2.put((Object)1, (Object)new Person2(1, "o1"));
        c2.put((Object)2, (Object)new Person2(2, "o2"));
        c2.put((Object)3, (Object)new Person2(3, "o3"));
        String select0 = "select o.name n1, p.name n2 from \"pers\".Person2 p join \"org\".Organization o on p.name = o.name";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IgniteSqlQueryParallelismTest.this.isClient = true;
                IgniteSqlQueryParallelismTest.this.qryParallelism = 2;
                IgniteEx client = IgniteSqlQueryParallelismTest.this.startGrid(4);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Query parallelism mismatch");
    }

    @Test
    public void testIndexSegmentation() throws Exception {
        IgniteCache c1 = this.ignite(0).cache("org");
        IgniteCache c2 = this.ignite(0).cache("pers");
        c1.put((Object)1, (Object)new Organization("o1"));
        c1.put((Object)2, (Object)new Organization("o2"));
        c2.put((Object)1, (Object)new Person2(1, "o1"));
        c2.put((Object)2, (Object)new Person2(2, "o2"));
        c2.put((Object)3, (Object)new Person2(3, "o3"));
        String select0 = "select o.name n1, p.name n2 from \"pers\".Person2 p join \"org\".Organization o on p.name = o.name";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IgniteSqlQueryParallelismTest.this.qryParallelism = 2;
                IgniteEx client = IgniteSqlQueryParallelismTest.this.startGrid(4);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Query parallelism mismatch");
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        String name;

        public Organization() {
        }

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class Person2
    implements Serializable {
        @QuerySqlField(index=true)
        int orgId;
        @QuerySqlField
        String name;

        public Person2() {
        }

        public Person2(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

