/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteSqlNotNullConstraintTest
extends AbstractIndexingCommonTest {
    private static String NODE_CLIENT = "client";
    private static int NODE_COUNT = 2;
    private static String CACHE_PREFIX = "person";
    private static String CACHE_PERSON = "person-PARTITIONED-TRANSACTIONAL";
    private static String TABLE_PERSON = "\"" + CACHE_PERSON + "\".\"PERSON\"";
    private static String CACHE_READ_THROUGH = "cacheReadThrough";
    private static String CACHE_INTERCEPTOR = "cacheInterceptor";
    private static String ERR_MSG = "Null value is not allowed for column 'NAME'";
    private static String READ_THROUGH_ERR_MSG = "NOT NULL constraint is not supported when CacheConfiguration.readThrough is enabled.";
    private static String INTERCEPTOR_ERR_MSG = "NOT NULL constraint is not supported when CacheConfiguration.interceptor is set.";
    private static String READ_THROUGH_CFG_NODE_NAME = "nodeCacheReadThrough";
    private static String INTERCEPTOR_CFG_NODE_NAME = "nodeCacheInterceptor";
    private final Person okValue = new Person("Name", 18);
    private final Person badValue = new Person(null, 25);

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(gridName);
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>();
        ccfgs.addAll(this.cacheConfigurations());
        if (gridName.equals(READ_THROUGH_CFG_NODE_NAME)) {
            ccfgs.add(this.buildCacheConfigurationRestricted("BadCfgTestCacheRT", true, false, true));
            c.setClientMode(true);
        }
        if (gridName.equals(INTERCEPTOR_CFG_NODE_NAME)) {
            ccfgs.add(this.buildCacheConfigurationRestricted("BadCfgTestCacheINT", false, true, true));
            c.setClientMode(true);
        }
        c.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        if (gridName.equals(NODE_CLIENT)) {
            c.setClientMode(true);
            c.setDataStorageConfiguration(new DataStorageConfiguration());
        }
        return c;
    }

    private List<CacheConfiguration> cacheConfigurations() {
        ArrayList<CacheConfiguration> res = new ArrayList<CacheConfiguration>();
        for (boolean wrt : new boolean[]{false, true}) {
            for (boolean annot : new boolean[]{false, true}) {
                res.add(this.buildCacheConfiguration(CacheMode.LOCAL, CacheAtomicityMode.ATOMIC, false, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.LOCAL, CacheAtomicityMode.TRANSACTIONAL, false, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false, wrt, annot));
                res.add(this.buildCacheConfiguration(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true, wrt, annot));
            }
        }
        return res;
    }

    private CacheConfiguration buildCacheConfiguration(CacheMode mode, CacheAtomicityMode atomicityMode, boolean hasNear, boolean writeThrough, boolean notNullAnnotated) {
        CacheConfiguration cfg = new CacheConfiguration(CACHE_PREFIX + "-" + mode.name() + "-" + atomicityMode.name() + (hasNear ? "-near" : "") + (writeThrough ? "-writethrough" : "") + (notNullAnnotated ? "-annot" : ""));
        cfg.setCacheMode(mode);
        cfg.setAtomicityMode(atomicityMode);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity qe = new QueryEntity(new QueryEntity(Integer.class, Person.class));
        if (!notNullAnnotated) {
            qe.setNotNullFields(Collections.singleton("name"));
        }
        cfg.setQueryEntities((Collection)F.asList((Object)qe));
        if (hasNear) {
            cfg.setNearConfiguration(new NearCacheConfiguration().setNearStartSize(100));
        }
        if (writeThrough) {
            cfg.setCacheStoreFactory(IgniteSqlNotNullConstraintTest.singletonFactory((Object)((Object)new TestStore())));
            cfg.setWriteThrough(true);
        }
        return cfg;
    }

    private CacheConfiguration buildCacheConfigurationRestricted(String cacheName, boolean readThrough, boolean interceptor, boolean hasQueryEntity) {
        CacheConfiguration cfg = new CacheConfiguration().setName(cacheName).setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        if (readThrough) {
            cfg.setCacheStoreFactory(IgniteSqlNotNullConstraintTest.singletonFactory((Object)((Object)new TestStore())));
            cfg.setReadThrough(true);
        }
        if (interceptor) {
            cfg.setInterceptor((CacheInterceptor)new TestInterceptor());
        }
        if (hasQueryEntity) {
            cfg.setQueryEntities((Collection)F.asList((Object)new QueryEntity(Integer.class, Person.class).setNotNullFields(Collections.singleton("name"))));
        }
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(NODE_COUNT);
        this.startGrid(NODE_CLIENT);
        this.grid(NODE_CLIENT).addCacheConfiguration(this.buildCacheConfigurationRestricted(CACHE_READ_THROUGH, true, false, false));
        this.grid(NODE_CLIENT).addCacheConfiguration(this.buildCacheConfigurationRestricted(CACHE_INTERCEPTOR, false, true, false));
        this.awaitPartitionMapExchange();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.cleanup();
    }

    protected boolean keepSerializedObjects() {
        return true;
    }

    @Test
    public void testQueryEntityGetSetNotNullFields() throws Exception {
        QueryEntity qe = new QueryEntity();
        IgniteSqlNotNullConstraintTest.assertNull((Object)qe.getNotNullFields());
        Set<String> val = Collections.singleton("test");
        qe.setNotNullFields(val);
        IgniteSqlNotNullConstraintTest.assertEquals(val, Collections.singleton("test"));
        qe.setNotNullFields(null);
        IgniteSqlNotNullConstraintTest.assertNull((Object)qe.getNotNullFields());
    }

    @Test
    public void testQueryEntityEquals() throws Exception {
        QueryEntity a = new QueryEntity();
        QueryEntity b = new QueryEntity();
        IgniteSqlNotNullConstraintTest.assertEquals((Object)a, (Object)b);
        a.setNotNullFields(Collections.singleton("test"));
        IgniteSqlNotNullConstraintTest.assertFalse((boolean)a.equals((Object)b));
        b.setNotNullFields(Collections.singleton("test"));
        IgniteSqlNotNullConstraintTest.assertTrue((boolean)a.equals((Object)b));
    }

    @Test
    public void testAtomicOrImplicitTxPut() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cache.put((Object)key2, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                        return null;
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxPutIfAbsent() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cache.putIfAbsent((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                        return null;
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxGetAndPut() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cache.getAndPut((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                        return null;
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxGetAndPutIfAbsent() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return cache.getAndPutIfAbsent((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxReplace() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return cache.replace((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
                IgniteSqlNotNullConstraintTest.assertEquals((Object)IgniteSqlNotNullConstraintTest.this.okValue, (Object)this.cache.get((Object)this.key1));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxGetAndReplace() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return cache.getAndReplace((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
                IgniteSqlNotNullConstraintTest.assertEquals((Object)IgniteSqlNotNullConstraintTest.this.okValue, (Object)this.cache.get((Object)this.key1));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxPutAll() throws Exception {
        this.doAtomicOrImplicitTxPutAll(F.asMap((Object)1, (Object)this.okValue, (Object)5, (Object)this.badValue), 1);
    }

    @Test
    public void testAtomicOrImplicitTxPutAllForSingleValue() throws Exception {
        this.doAtomicOrImplicitTxPutAll(F.asMap((Object)5, (Object)this.badValue), 0);
    }

    @Test
    public void testAtomicOrImplicitTxInvoke() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return cache.invoke((Object)key1, (EntryProcessor)new TestEntryProcessor(IgniteSqlNotNullConstraintTest.this.badValue), new Object[0]);
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxInvokeAll() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                final Map r = this.cache.invokeAll(F.asMap((Object)this.key1, (Object)new TestEntryProcessor(IgniteSqlNotNullConstraintTest.this.okValue), (Object)this.key2, (Object)new TestEntryProcessor(IgniteSqlNotNullConstraintTest.this.badValue)), new Object[0]);
                IgniteSqlNotNullConstraintTest.assertNotNull((Object)r);
                GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((EntryProcessorResult)r.get(key2)).get();
                    }
                }, IgniteCheckedException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testTxPutCreate() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.put((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                            cache.put((Object)key2, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxPutUpdate() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.put((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                            cache.put((Object)key2, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                            cache.put((Object)key2, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxPutIfAbsent() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.putIfAbsent((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxGetAndPut() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.getAndPut((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxGetAndPutIfAbsent() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.getAndPutIfAbsent((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxReplace() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cache.put((Object)1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.replace((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)cache.size(new CachePeekMode[0]));
                        IgniteSqlNotNullConstraintTest.assertEquals((Object)IgniteSqlNotNullConstraintTest.this.okValue, (Object)cache.get((Object)key1));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxGetAndReplace() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cache.put((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.getAndReplace((Object)key1, (Object)IgniteSqlNotNullConstraintTest.this.badValue);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)cache.size(new CachePeekMode[0]));
                        IgniteSqlNotNullConstraintTest.assertEquals((Object)IgniteSqlNotNullConstraintTest.this.okValue, (Object)cache.get((Object)key1));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    @Test
    public void testTxPutAll() throws Exception {
        this.doTxPutAll(F.asMap((Object)1, (Object)this.okValue, (Object)5, (Object)this.badValue));
    }

    @Test
    public void testTxPutAllForSingleValue() throws Exception {
        this.doTxPutAll(F.asMap((Object)5, (Object)this.badValue));
    }

    @Test
    public void testTxInvoke() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.invoke((Object)key1, (EntryProcessor)new TestEntryProcessor(IgniteSqlNotNullConstraintTest.this.badValue), new Object[0]);
                            tx.commit();
                        }
                        return null;
                    }
                }, EntryProcessorException.class, (String)ERR_MSG);
                IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)this.cache.size(new CachePeekMode[0]));
                IgniteSqlNotNullConstraintTest.assertEquals((Object)IgniteSqlNotNullConstraintTest.this.okValue, (Object)this.cache.get((Object)this.key1));
            }
        });
    }

    @Test
    public void testTxInvokeAll() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                try (Transaction tx = this.ignite.transactions().txStart(this.concurrency, this.isolation);){
                    final Map r = this.cache.invokeAll(F.asMap((Object)this.key1, (Object)new TestEntryProcessor(IgniteSqlNotNullConstraintTest.this.okValue), (Object)this.key2, (Object)new TestEntryProcessor(IgniteSqlNotNullConstraintTest.this.badValue)), new Object[0]);
                    IgniteSqlNotNullConstraintTest.assertNotNull((Object)r);
                    GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return ((EntryProcessorResult)r.get(key2)).get();
                        }
                    }, EntryProcessorException.class, (String)ERR_MSG);
                    tx.rollback();
                }
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxInvokeDelete() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                this.cache.invoke((Object)this.key1, (EntryProcessor)new TestEntryProcessor(null), new Object[0]);
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testAtomicOrImplicitTxInvokeAllDelete() throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                this.cache.put((Object)this.key2, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                this.cache.invokeAll(F.asMap((Object)this.key1, (Object)new TestEntryProcessor(null), (Object)this.key2, (Object)new TestEntryProcessor(null)), new Object[0]);
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testTxInvokeDelete() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                try (Transaction tx = this.ignite.transactions().txStart(this.concurrency, this.isolation);){
                    this.cache.invoke((Object)this.key1, (EntryProcessor)new TestEntryProcessor(null), new Object[0]);
                    tx.commit();
                }
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testTxInvokeAllDelete() throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                this.cache.put((Object)this.key1, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                this.cache.put((Object)this.key2, (Object)IgniteSqlNotNullConstraintTest.this.okValue);
                try (Transaction tx = this.ignite.transactions().txStart(this.concurrency, this.isolation);){
                    this.cache.invokeAll(F.asMap((Object)this.key1, (Object)new TestEntryProcessor(null), (Object)this.key2, (Object)new TestEntryProcessor(null)), new Object[0]);
                    tx.commit();
                }
                IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    @Test
    public void testDynamicTableCreateNotNullFieldsAllowed() throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, field INT NOT NULL)");
        String cacheName = QueryUtils.createTableCacheName((String)"PUBLIC", (String)"TEST");
        IgniteEx client = this.grid(NODE_CLIENT);
        CacheConfiguration ccfg = client.context().cache().cache(cacheName).configuration();
        QueryEntity qe = (QueryEntity)F.first((Iterable)ccfg.getQueryEntities());
        IgniteSqlNotNullConstraintTest.assertEquals(Collections.singleton("FIELD"), (Object)qe.getNotNullFields());
        this.checkState("PUBLIC", "TEST", "FIELD");
    }

    @Test
    public void testAlterTableAddColumnNotNullFieldAllowed() throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, age INT)");
        this.executeSql("ALTER TABLE test ADD COLUMN name CHAR NOT NULL");
        this.checkState("PUBLIC", "TEST", "NAME");
    }

    @Test
    public void testAtomicNotNullCheckDmlInsertValues() throws Exception {
        this.checkNotNullCheckDmlInsertValues(CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testTransactionalNotNullCheckDmlInsertValues() throws Exception {
        this.checkNotNullCheckDmlInsertValues(CacheAtomicityMode.TRANSACTIONAL);
    }

    private void checkNotNullCheckDmlInsertValues(CacheAtomicityMode atomicityMode) throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, name VARCHAR NOT NULL, age INT) WITH \"atomicity=" + atomicityMode.name() + "\"");
        this.checkNotNullInsertValues();
    }

    @Test
    public void testAtomicAddColumnNotNullCheckDmlInsertValues() throws Exception {
        this.checkAddColumnNotNullCheckDmlInsertValues(CacheAtomicityMode.ATOMIC);
    }

    @Test
    public void testTransactionalAddColumnNotNullCheckDmlInsertValues() throws Exception {
        this.checkAddColumnNotNullCheckDmlInsertValues(CacheAtomicityMode.TRANSACTIONAL);
    }

    private void checkAddColumnNotNullCheckDmlInsertValues(CacheAtomicityMode atomicityMode) throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, age INT) WITH \"atomicity=" + atomicityMode.name() + "\"");
        this.executeSql("ALTER TABLE test ADD COLUMN name VARCHAR NOT NULL");
        this.checkNotNullInsertValues();
    }

    private void checkNotNullInsertValues() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IgniteSqlNotNullConstraintTest.this.executeSql("INSERT INTO test(id, name, age) VALUES (2, NULLIF('a', 'a'), 2)");
                return null;
            }
        }, IgniteSQLException.class, (String)ERR_MSG);
        List<List<?>> result = this.executeSql("SELECT id, name, age FROM test ORDER BY id");
        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)result.size());
        this.executeSql("INSERT INTO test(id, name) VALUES (1, 'ok'), (2, 'ok2'), (3, 'ok3')");
        result = this.executeSql("SELECT id, name FROM test ORDER BY id");
        IgniteSqlNotNullConstraintTest.assertEquals((int)3, (int)result.size());
    }

    @Test
    public void testNotNullCheckDmlInsertFromSelect() throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, name VARCHAR, age INT)");
        this.executeSql("INSERT INTO test(id, name, age) VALUES (2, null, 25)");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("INSERT INTO " + TABLE_PERSON + "(_key, name, age) SELECT id, name, age FROM test");
            }
        }, IgniteSQLException.class, (String)ERR_MSG);
        List<List<?>> result = this.executeSql("SELECT _key, name FROM " + TABLE_PERSON + " ORDER BY _key");
        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)result.size());
        this.executeSql("INSERT INTO test(id, name, age) VALUES (1, 'Macy', 25), (3, 'John', 30)");
        this.executeSql("DELETE FROM test WHERE id = 2");
        result = this.executeSql("INSERT INTO " + TABLE_PERSON + "(_key, name, age) SELECT id, name, age FROM test");
        IgniteSqlNotNullConstraintTest.assertEquals((Object)2L, result.get(0).get(0));
    }

    @Test
    public void testNotNullCheckDmlUpdateValues() throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, name VARCHAR NOT NULL)");
        this.executeSql("INSERT INTO test(id, name) VALUES (1, 'John')");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("UPDATE test SET name = NULLIF(id, 1) WHERE id = 1");
            }
        }, IgniteSQLException.class, (String)ERR_MSG);
        List<List<?>> result = this.executeSql("SELECT id, name FROM test");
        IgniteSqlNotNullConstraintTest.assertEquals((int)1, (int)result.size());
        IgniteSqlNotNullConstraintTest.assertEquals((Object)1, result.get(0).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"John", result.get(0).get(1));
        this.executeSql("UPDATE test SET name = 'James' WHERE id = 1");
        result = this.executeSql("SELECT id, name FROM test");
        IgniteSqlNotNullConstraintTest.assertEquals((Object)1, result.get(0).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"James", result.get(0).get(1));
    }

    @Test
    public void testNotNullCheckDmlUpdateFromSelect() throws Exception {
        this.executeSql("CREATE TABLE src(id INT PRIMARY KEY, name VARCHAR)");
        this.executeSql("CREATE TABLE dest(id INT PRIMARY KEY, name VARCHAR NOT NULL)");
        this.executeSql("INSERT INTO dest(id, name) VALUES (1, 'William'), (2, 'Warren'), (3, 'Robert')");
        this.executeSql("INSERT INTO src(id, name) VALUES (1, 'Bill'), (2, null), (3, 'Bob')");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("UPDATE dest p SET (name) = (SELECT name FROM src t WHERE p.id = t.id) WHERE p.id = 2");
            }
        }, IgniteSQLException.class, (String)ERR_MSG);
        List<List<?>> result = this.executeSql("SELECT id, name FROM dest ORDER BY id");
        IgniteSqlNotNullConstraintTest.assertEquals((int)3, (int)result.size());
        IgniteSqlNotNullConstraintTest.assertEquals((Object)1, result.get(0).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"William", result.get(0).get(1));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)2, result.get(1).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"Warren", result.get(1).get(1));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)3, result.get(2).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"Robert", result.get(2).get(1));
        this.executeSql("UPDATE src SET name = 'Ren' WHERE id = 2");
        this.executeSql("UPDATE dest p SET (name) = (SELECT name FROM src t WHERE p.id = t.id)");
        result = this.executeSql("SELECT id, name FROM dest ORDER BY id");
        IgniteSqlNotNullConstraintTest.assertEquals((int)3, (int)result.size());
        IgniteSqlNotNullConstraintTest.assertEquals((Object)1, result.get(0).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"Bill", result.get(0).get(1));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)2, result.get(1).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"Ren", result.get(1).get(1));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)3, result.get(2).get(0));
        IgniteSqlNotNullConstraintTest.assertEquals((Object)"Bob", result.get(2).get(1));
    }

    @Test
    public void testReadThroughRestrictionQueryEntity() throws Exception {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.startGrid(READ_THROUGH_CFG_NODE_NAME);
            }
        }, IgniteCheckedException.class, (String)READ_THROUGH_ERR_MSG);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.grid(NODE_CLIENT).createCache(IgniteSqlNotNullConstraintTest.this.buildCacheConfigurationRestricted("dynBadCfgCacheRT", true, false, true));
            }
        }, IgniteCheckedException.class, (String)READ_THROUGH_ERR_MSG);
    }

    @Test
    public void testInterceptorRestrictionQueryEntity() throws Exception {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.startGrid(INTERCEPTOR_CFG_NODE_NAME);
            }
        }, IgniteCheckedException.class, (String)INTERCEPTOR_ERR_MSG);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.grid(NODE_CLIENT).createCache(IgniteSqlNotNullConstraintTest.this.buildCacheConfigurationRestricted("dynBadCfgCacheINT", false, true, true));
            }
        }, IgniteCheckedException.class, (String)INTERCEPTOR_ERR_MSG);
    }

    @Test
    public void testReadThroughRestrictionCreateTable() throws Exception {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, name char NOT NULL) WITH \"template=" + CACHE_READ_THROUGH + "\"");
            }
        }, IgniteSQLException.class, (String)READ_THROUGH_ERR_MSG);
    }

    @Test
    public void testInterceptorRestrictionCreateTable() throws Exception {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, name char NOT NULL) WITH \"template=" + CACHE_INTERCEPTOR + "\"");
            }
        }, IgniteSQLException.class, (String)INTERCEPTOR_ERR_MSG);
    }

    @Test
    public void testReadThroughRestrictionAlterTable() throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, age INT) WITH \"template=" + CACHE_READ_THROUGH + "\"");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("ALTER TABLE test ADD COLUMN name char NOT NULL");
            }
        }, IgniteSQLException.class, (String)READ_THROUGH_ERR_MSG);
    }

    @Test
    public void testInterceptorRestrictionAlterTable() throws Exception {
        this.executeSql("CREATE TABLE test(id INT PRIMARY KEY, age INT) WITH \"template=" + CACHE_INTERCEPTOR + "\"");
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return IgniteSqlNotNullConstraintTest.this.executeSql("ALTER TABLE test ADD COLUMN name char NOT NULL");
            }
        }, IgniteSQLException.class, (String)INTERCEPTOR_ERR_MSG);
    }

    private void doAtomicOrImplicitTxPutAll(final Map<Integer, Person> values, final int expAtomicCacheSize) throws Exception {
        this.executeWithAllCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                Throwable t = GridTestUtils.assertThrowsWithCause((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        cache.putAll(values);
                        return null;
                    }
                }, IgniteSQLException.class);
                IgniteSQLException ex = (IgniteSQLException)X.cause((Throwable)t, IgniteSQLException.class);
                IgniteSqlNotNullConstraintTest.assertNotNull((Object)((Object)ex));
                IgniteSqlNotNullConstraintTest.assertTrue((boolean)ex.getMessage().contains(ERR_MSG));
                IgniteSqlNotNullConstraintTest.assertEquals((int)(this.isLocalAtomic() ? expAtomicCacheSize : 0), (int)this.cache.size(new CachePeekMode[0]));
            }
        });
    }

    private void doTxPutAll(final Map<Integer, Person> values) throws Exception {
        this.executeWithAllTxCaches(new TestClosure(){

            @Override
            public void run() throws Exception {
                GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try (Transaction tx = ignite.transactions().txStart(concurrency, isolation);){
                            cache.putAll(values);
                            tx.commit();
                        }
                        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
                        return null;
                    }
                }, CacheException.class, (String)ERR_MSG);
            }
        });
    }

    private void executeWithAllCaches(TestClosure clo) throws Exception {
        for (CacheConfiguration ccfg : this.cacheConfigurations()) {
            this.executeForCache(ccfg, clo, TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED);
        }
    }

    private void executeWithAllTxCaches(TestClosure clo) throws Exception {
        for (CacheConfiguration ccfg : this.cacheConfigurations()) {
            if (ccfg.getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL) continue;
            for (TransactionConcurrency con : TransactionConcurrency.values()) {
                for (TransactionIsolation iso : TransactionIsolation.values()) {
                    this.executeForCache(ccfg, clo, con, iso);
                }
            }
        }
    }

    private void executeForCache(CacheConfiguration ccfg, TestClosure clo, TransactionConcurrency concurrency, TransactionIsolation isolation) throws Exception {
        IgniteEx ignite = this.grid(NODE_CLIENT);
        this.executeForNodeAndCache(ccfg, (Ignite)ignite, clo, concurrency, isolation);
        for (int node = 0; node < NODE_COUNT; ++node) {
            ignite = this.grid(node);
            this.executeForNodeAndCache(ccfg, (Ignite)ignite, clo, concurrency, isolation);
        }
    }

    private void executeForNodeAndCache(CacheConfiguration ccfg, Ignite ignite, TestClosure clo, TransactionConcurrency concurrency, TransactionIsolation isolation) throws Exception {
        String cacheName = ccfg.getName();
        IgniteCache cache = ignite.configuration().isClientMode() != false && ccfg.getCacheMode() == CacheMode.PARTITIONED && ccfg.getNearConfiguration() != null ? ignite.getOrCreateNearCache(ccfg.getName(), ccfg.getNearConfiguration()) : ignite.cache(ccfg.getName());
        cache.removeAll();
        IgniteSqlNotNullConstraintTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
        clo.configure(ignite, (IgniteCache<Integer, Person>)cache, concurrency, isolation);
        log.info("Running test with node " + ignite.name() + ", cache " + cacheName);
        clo.key1 = 1;
        clo.key2 = 4;
        clo.run();
    }

    private List<List<?>> executeSql(String sqlText) throws Exception {
        GridQueryProcessor qryProc = this.grid(NODE_CLIENT).context().query();
        return qryProc.querySqlFields(new SqlFieldsQuery(sqlText), true).getAll();
    }

    private void cleanup() throws Exception {
        for (CacheConfiguration ccfg : this.cacheConfigurations()) {
            String cacheName = ccfg.getName();
            if (ccfg.getCacheMode() == CacheMode.LOCAL) {
                this.grid(NODE_CLIENT).cache(cacheName).clear();
                for (int node = 0; node < NODE_COUNT; ++node) {
                    this.grid(node).cache(cacheName).clear();
                }
                continue;
            }
            if (ccfg.getCacheMode() == CacheMode.PARTITIONED && ccfg.getNearConfiguration() != null) {
                IgniteCache cache = this.grid(NODE_CLIENT).getOrCreateNearCache(cacheName, ccfg.getNearConfiguration());
                cache.clear();
            }
            this.grid(NODE_CLIENT).cache(cacheName).clear();
        }
        this.executeSql("DROP TABLE test IF EXISTS");
    }

    private void checkState(String schemaName, String tableName, String fieldName) {
        IgniteEx client = this.grid(NODE_CLIENT);
        this.checkNodeState(client, schemaName, tableName, fieldName);
        for (int i = 0; i < NODE_COUNT; ++i) {
            this.checkNodeState(this.grid(i), schemaName, tableName, fieldName);
        }
    }

    private void checkNodeState(IgniteEx node, String schemaName, String tableName, String fieldName) {
        String cacheName = F.eq((Object)schemaName, (Object)"PUBLIC") ? QueryUtils.createTableCacheName((String)schemaName, (String)tableName) : schemaName;
        DynamicCacheDescriptor desc = node.context().cache().cacheDescriptor(cacheName);
        IgniteSqlNotNullConstraintTest.assertNotNull((String)"Cache descriptor not found", (Object)desc);
        QuerySchema schema = desc.schema();
        IgniteSqlNotNullConstraintTest.assertNotNull((Object)schema);
        QueryEntity entity = null;
        for (QueryEntity e : schema.entities()) {
            if (!F.eq((Object)tableName, (Object)e.getTableName())) continue;
            entity = e;
            break;
        }
        IgniteSqlNotNullConstraintTest.assertNotNull(entity);
        IgniteSqlNotNullConstraintTest.assertNotNull((Object)entity.getNotNullFields());
        IgniteSqlNotNullConstraintTest.assertTrue((boolean)entity.getNotNullFields().contains(fieldName));
    }

    private static class TestInterceptor
    implements CacheInterceptor<Integer, Person> {
        private TestInterceptor() {
        }

        @Nullable
        public Person onGet(Integer key, @Nullable Person val) {
            return null;
        }

        @Nullable
        public Person onBeforePut(Cache.Entry<Integer, Person> entry, Person newVal) {
            return null;
        }

        public void onAfterPut(Cache.Entry<Integer, Person> entry) {
        }

        @Nullable
        public IgniteBiTuple<Boolean, Person> onBeforeRemove(Cache.Entry<Integer, Person> entry) {
            return null;
        }

        public void onAfterRemove(Cache.Entry<Integer, Person> entry) {
        }
    }

    private static class TestStore
    extends CacheStoreAdapter<Integer, Person> {
        private TestStore() {
        }

        public void loadCache(IgniteBiInClosure<Integer, Person> clo, Object ... args) {
        }

        public Person load(Integer key) {
            return null;
        }

        public void write(Cache.Entry<? extends Integer, ? extends Person> e) {
        }

        public void delete(Object key) {
        }
    }

    public abstract class TestClosure {
        protected Ignite ignite;
        protected IgniteCache<Integer, Person> cache;
        protected TransactionConcurrency concurrency;
        protected TransactionIsolation isolation;
        public int key1;
        public int key2;

        public void configure(Ignite ignite, IgniteCache<Integer, Person> cache, TransactionConcurrency concurrency, TransactionIsolation isolation) {
            this.ignite = ignite;
            this.cache = cache;
            this.concurrency = concurrency;
            this.isolation = isolation;
        }

        protected boolean isLocalAtomic() {
            CacheConfiguration cfg = (CacheConfiguration)this.cache.getConfiguration(CacheConfiguration.class);
            return cfg.getCacheMode() == CacheMode.LOCAL && cfg.getAtomicityMode() == CacheAtomicityMode.ATOMIC;
        }

        public abstract void run() throws Exception;
    }

    public class TestEntryProcessor
    implements EntryProcessor<Integer, Person, Object> {
        private Person value;

        public TestEntryProcessor(Person value) {
            this.value = value;
        }

        public Object process(MutableEntry<Integer, Person> entry, Object ... objects) throws EntryProcessorException {
            if (this.value == null) {
                entry.remove();
            } else {
                entry.setValue((Object)this.value);
            }
            return null;
        }
    }

    public static class Person {
        @QuerySqlField(notNull=true)
        private String name;
        @QuerySqlField
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public int hashCode() {
            return (this.name == null ? 0 : this.name.hashCode()) ^ this.age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person other = (Person)o;
            return F.eq((Object)other.name, (Object)this.name) && other.age == this.age;
        }
    }
}

