/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class IgniteSqlDistributedJoinSelfTest
extends AbstractIndexingCommonTest {
    private static final int NODES_COUNT = 2;
    private static final int ORG_COUNT = 2;
    private static final int PERSON_PER_ORG_COUNT = 50;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setPeerClassLoadingEnabled(false);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(2, false);
    }

    protected CacheConfiguration cacheConfig(String name, boolean partitioned, Class<?> ... idxTypes) {
        return new CacheConfiguration("default").setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setIndexedTypes((Class[])idxTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonCollocatedDistributedJoin() throws Exception {
        CacheConfiguration ccfg1 = this.cacheConfig("pers", true, String.class, Person.class);
        CacheConfiguration ccfg2 = this.cacheConfig("org", true, String.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            this.awaitPartitionMapExchange();
            this.populateDataIntoCaches((IgniteCache<String, Person>)c1, (IgniteCache<String, Organization>)c2);
            String joinSql = "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)";
            SqlQuery qry = new SqlQuery(Person.class, joinSql).setArgs(new Object[]{"Organization #0"});
            qry.setDistributedJoins(true);
            List prns = c1.query((Query)qry).getAll();
            IgniteSqlDistributedJoinSelfTest.assertEquals((int)50, (int)prns.size());
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    @Test
    public void testCollocationForComplexCte() {
        IgniteEx ign = this.ignite(0);
        IgniteCache cache = ign.getOrCreateCache("default");
        String ddl = "CREATE TABLE T1 (SEQ_OF_CALC NUMBER(5, 0) NOT NULL, PAYMENT VARCHAR2(10), PRIMARY KEY (SEQ_OF_CALC));";
        String query = " WITH q AS (SELECT * FROM T1)            SELECT SUBQRY.SEQ_OF_CALC            FROM                (SELECT PRTCH.SEQ_OF_CALC                    FROM                        (SELECT * FROM q),                    T1 PRTCH                    WHERE 0=1                ) SUBQRY";
        cache.query(new SqlFieldsQuery(ddl));
        cache.query(new SqlFieldsQuery(query).setDistributedJoins(true)).getAll();
    }

    private void populateDataIntoCaches(IgniteCache<String, Person> c1, IgniteCache<String, Organization> c2) {
        int personId = 0;
        for (int i = 0; i < 2; ++i) {
            Organization org = new Organization();
            org.setId("org" + i);
            org.setName("Organization #" + i);
            c2.put((Object)org.getId(), (Object)org);
            for (int j = 0; j < 50; ++j) {
                Person prsn = new Person();
                prsn.setId("pers" + personId);
                prsn.setOrgId(org.getId());
                prsn.setName("Person name #" + personId);
                c1.put((Object)prsn.getId(), (Object)prsn);
                ++personId;
            }
        }
    }

    private static class Organization {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String name;

        private Organization() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String orgId;
        @QuerySqlField(index=true)
        private String name;

        private Person() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getOrgId() {
            return this.orgId;
        }

        public void setOrgId(String orgId) {
            this.orgId = orgId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

