/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class IgniteSqlCreateTableTemplateTest
extends AbstractIndexingCommonTest {
    public IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration configuration = new IgniteConfiguration();
        configuration.setIgniteInstanceName(name);
        CacheConfiguration defaultCacheConfiguration = new CacheConfiguration();
        defaultCacheConfiguration.setName("DEFAULT_TEMPLATE*");
        CacheConfiguration customCacheConfiguration = new CacheConfiguration();
        customCacheConfiguration.setName("CUSTOM_TEMPLATE*");
        MockAffinityKeyMapper customAffinityMapper = new MockAffinityKeyMapper();
        customCacheConfiguration.setAffinityMapper((AffinityKeyMapper)customAffinityMapper);
        configuration.setCacheConfiguration(new CacheConfiguration[]{defaultCacheConfiguration, customCacheConfiguration});
        return configuration;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid();
    }

    @Test
    public void testSelectForTableWithDataInsertedWithKeyValueAPI() {
        IgniteEx ignite = this.grid();
        IgniteCache cache = ignite.getOrCreateCache("test");
        this.createTable(cache, "PERSON", "DEFAULT_TEMPLATE");
        this.createTable(cache, "ORGANIZATION", "DEFAULT_TEMPLATE");
        BinaryObjectBuilder keyBuilder = ignite.binary().builder("PERSON_KEY");
        keyBuilder.setField("ID", (Object)1);
        keyBuilder.setField("AFF_PERSON", (Object)2);
        BinaryObjectBuilder valueBuilder = ignite.binary().builder("PERSON_VALUE");
        valueBuilder.setField("NAME", (Object)"test");
        ignite.cache("PERSON_CACHE").withKeepBinary().put((Object)keyBuilder.build(), (Object)valueBuilder.build());
        keyBuilder = ignite.binary().builder("ORGANIZATION_KEY");
        keyBuilder.setField("ID", (Object)1);
        keyBuilder.setField("AFF_ORGANIZATION", (Object)2);
        valueBuilder = ignite.binary().builder("ORGANIZATION_VALUE");
        valueBuilder.setField("NAME", (Object)"test");
        ignite.cache("ORGANIZATION_CACHE").withKeepBinary().put((Object)keyBuilder.build(), (Object)valueBuilder.build());
        IgniteSqlCreateTableTemplateTest.assertEquals((int)1, (int)ignite.cache("PERSON_CACHE").query(new SqlFieldsQuery("Select NAME from PERSON where ID = 1")).getAll().size());
        IgniteSqlCreateTableTemplateTest.assertEquals((int)1, (int)ignite.cache("PERSON_CACHE").query(new SqlFieldsQuery("Select NAME from PERSON where AFF_PERSON = 2")).getAll().size());
        IgniteSqlCreateTableTemplateTest.assertEquals((int)1, (int)ignite.cache("ORGANIZATION_CACHE").query(new SqlFieldsQuery("Select NAME from ORGANIZATION where AFF_ORGANIZATION = 2")).getAll().size());
    }

    private void createTable(IgniteCache cache, String tableName, String template) {
        String sql = String.format("CREATE TABLE IF NOT EXISTS %1$s(\n  ID                INT        NOT NULL,\n  AFF_%1$s        INT        NOT NULL,\n  NAME              VARCHAR2(100),\n  PRIMARY KEY (ID, AFF_%1$s)\n) with \"TEMPLATE=%2$s,KEY_TYPE=%1$s_KEY, AFFINITY_KEY=AFF_%1$s, CACHE_NAME=%1$s_CACHE, VALUE_TYPE=%1$s_VALUE, ATOMICITY=TRANSACTIONAL\";", tableName, template);
        cache.query(new SqlFieldsQuery(sql).setSchema("PUBLIC"));
    }

    @Test
    public void testCustomAffinityKeyMapperIsNotOverwritten() {
        IgniteEx ignite = this.grid();
        IgniteCache cache = ignite.getOrCreateCache("test");
        this.createTable(cache, "CUSTOM", "CUSTOM_TEMPLATE");
        IgniteSqlCreateTableTemplateTest.assertTrue((boolean)(((CacheConfiguration)ignite.getOrCreateCache("CUSTOM_CACHE").getConfiguration(CacheConfiguration.class)).getAffinityMapper() instanceof MockAffinityKeyMapper));
    }

    private static class MockAffinityKeyMapper
    implements AffinityKeyMapper {
        private MockAffinityKeyMapper() {
        }

        public Object affinityKey(Object key) {
            return null;
        }

        public void reset() {
        }
    }
}

