/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.internal.h2.util.LocalDateTimeUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IgniteQueryConvertibleTypesValidationTest
extends GridCommonAbstractTest {
    @Parameterized.Parameter(value=0)
    public String sqlType;
    @Parameterized.Parameter(value=1)
    public Class<?> objType;
    @Parameterized.Parameter(value=2)
    public Function<Object, Object> sqlTypeConverter;
    @Parameterized.Parameter(value=3)
    public boolean isDdl;

    @Parameterized.Parameters(name="sqlType={0}, testObjCls={1}, isDdl={3}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (boolean isDdl : Arrays.asList(true, false)) {
            params.add(new Object[]{"TIMESTAMP", LocalDateTime.class, IgniteQueryConvertibleTypesValidationTest.f(d -> Timestamp.valueOf((LocalDateTime)d)), isDdl});
            params.add(new Object[]{"TIMESTAMP", java.util.Date.class, IgniteQueryConvertibleTypesValidationTest.f(d -> new Timestamp(((java.util.Date)d).getTime())), isDdl});
            params.add(new Object[]{"TIMESTAMP", Date.class, IgniteQueryConvertibleTypesValidationTest.f(d -> new Timestamp(((java.util.Date)d).getTime())), isDdl});
            params.add(new Object[]{"DATE", LocalDate.class, IgniteQueryConvertibleTypesValidationTest.f(d -> LocalDateTimeUtils.localDateToDateValue((Object)d).getDate()), isDdl});
            params.add(new Object[]{"TIME", LocalTime.class, IgniteQueryConvertibleTypesValidationTest.f(d -> LocalDateTimeUtils.localTimeToTimeValue((Object)d).getTime()), isDdl});
        }
        return params;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
    }

    @Test
    public void testIgniteQueryConvertibleTypesValidation() throws Exception {
        this.startGrid(0);
        this.createTable();
        this.execute("CREATE INDEX DATA_IDX ON DATA(data DESC);", new Object[0]);
        Object testObj = IgniteQueryConvertibleTypesValidationTest.generateTestObject(this.objType);
        this.execute("INSERT INTO DATA(_key, id, data) values(?, ?, ?)", 0, 0, testObj);
        this.grid(0).cache("default").put((Object)1, (Object)new Data(1, testObj));
        this.grid(0).cache("default").put((Object)2, this.grid(0).binary().toBinary((Object)new Data(2, testObj)));
        List<List<?>> selectData = this.execute("SELECT data FROM DATA", new Object[0]);
        Object sqlObj = this.sqlTypeConverter.apply(testObj);
        IgniteQueryConvertibleTypesValidationTest.assertTrue((boolean)selectData.stream().flatMap(Collection::stream).allMatch(d -> Objects.equals(sqlObj, d)));
    }

    private void createTable() {
        if (this.isDdl) {
            this.execute("CREATE TABLE DATA (id INT PRIMARY KEY, data " + this.sqlType + ") WITH \"KEY_TYPE=java.lang.Integer, VALUE_TYPE=org.apache.ignite.internal.processors.query.IgniteQueryConvertibleTypesValidationTest$Data, CACHE_NAME=default\"", new Object[0]);
        } else {
            QueryEntity projEntity = new QueryEntity();
            projEntity.setKeyType(Integer.class.getName());
            projEntity.setValueType(Data.class.getName());
            projEntity.addQueryField("id", Integer.class.getName(), null);
            projEntity.addQueryField("data", IgniteQueryConvertibleTypesValidationTest.toClassName(this.sqlType), null);
            projEntity.setTableName("DATA");
            this.grid(0).createCache(new CacheConfiguration("default").setQueryEntities(Collections.singletonList(projEntity)).setSqlSchema("PUBLIC"));
        }
    }

    private List<List<?>> execute(String qry, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(qry).setArgs(args), false).getAll();
    }

    private static Object generateTestObject(Class<?> cls) {
        if (cls == LocalDateTime.class) {
            return LocalDateTime.now();
        }
        if (cls == LocalTime.class) {
            return LocalTime.now();
        }
        if (cls == LocalDate.class) {
            return LocalDate.now();
        }
        if (cls == java.util.Date.class) {
            return java.util.Date.from(Instant.now());
        }
        if (cls == Date.class) {
            return Date.valueOf(LocalDate.now());
        }
        if (cls == Time.class) {
            return Time.valueOf(LocalTime.now());
        }
        throw new IllegalStateException();
    }

    private static String toClassName(String sqlType) {
        switch (sqlType) {
            case "TIMESTAMP": {
                return Timestamp.class.getName();
            }
            case "TIME": {
                return Time.class.getName();
            }
            case "DATE": {
                return Date.class.getName();
            }
        }
        throw new IllegalStateException();
    }

    private static <T, R> Function<Object, Object> f(Function<T, R> f) {
        return f;
    }

    public static class Data
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int id;
        public Object data;

        public Data(int id, Object data) {
            this.id = id;
            this.data = data;
        }
    }
}

