/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIODecorator;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.testframework.junits.multijvm.IgniteProcessProxy;
import org.junit.Test;

public class IgnitePdsCorruptedIndexTest
extends GridCommonAbstractTest {
    private static final String CACHE = "cache";
    private boolean haltFileIO;
    private boolean multiJvm = true;
    private List<String> additionalArgs = Collections.emptyList();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setWalMode(WALMode.LOG_ONLY).setCheckpointFrequency(600000L).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x20000000L).setPersistenceEnabled(true));
        if (this.haltFileIO) {
            dsCfg.setFileIOFactory((FileIOFactory)new HaltOnTruncateFileIOFactory((FileIOFactory)new RandomAccessFileIOFactory()));
        }
        cfg.setDataStorageConfiguration(dsCfg);
        CacheConfiguration ccfg = new CacheConfiguration(CACHE).setBackups(1).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setIndexedTypes(new Class[]{Integer.class, IndexedObject.class, Long.class, IndexedObject.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected boolean isMultiJvm() {
        return this.multiJvm;
    }

    protected List<String> additionalRemoteJvmArgs() {
        return this.additionalArgs;
    }

    @Test
    public void testCorruption() throws Exception {
        String corruptedNodeName = "corrupted";
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        this.haltFileIO = true;
        this.additionalArgs = new ArrayList<String>();
        this.additionalArgs.add("-DTEST_CHECKPOINT_ON_EVICTION=true");
        this.additionalArgs.add("-DIGNITE_QUIET=false");
        IgniteEx corruptedNode = this.startGrid("corrupted");
        this.additionalArgs.clear();
        this.haltFileIO = false;
        this.startGrid(2);
        ignite.cluster().active(true);
        this.awaitPartitionMapExchange();
        int entityCnt = 3200;
        try (IgniteDataStreamer streamer = ignite.dataStreamer(CACHE);){
            streamer.allowOverwrite(true);
            for (int i = 0; i < 3200; ++i) {
                streamer.addData((Object)i, (Object)new IndexedObject(i));
            }
        }
        this.startGrid(3);
        this.resetBaselineTopology();
        GridTestUtils.waitForCondition(() -> ignite.cluster().nodes().size() == 3, (long)this.getTestTimeout());
        IgniteProcessProxy.kill((String)corruptedNode.name());
        this.stopAllGrids();
        this.multiJvm = false;
        this.startGrid(0);
        corruptedNode = this.startGrid("corrupted");
        corruptedNode.cluster().active(true);
        IgnitePdsCorruptedIndexTest.assertFalse((boolean)this.grid(0).cache(CACHE).lostPartitions().isEmpty());
        IgnitePdsCorruptedIndexTest.assertFalse((boolean)this.grid("corrupted").cache(CACHE).lostPartitions().isEmpty());
        this.resetBaselineTopology();
        this.grid(0).resetLostPartitions(Collections.singleton(CACHE));
        this.awaitPartitionMapExchange();
        for (int k = 0; k < 3200; k += 800) {
            IgniteCache cache1 = corruptedNode.cache(CACHE);
            int l = k;
            int r = k + 800 - 1;
            log.info("Check range [" + l + "-" + r + "]");
            QueryCursor qry = cache1.query((Query)new SqlQuery(IndexedObject.class, "lVal between ? and ?").setArgs(new Object[]{l * l, r * r}));
            List queried = qry.getAll();
            log.info("Qry result size = " + queried.size());
        }
    }

    private static class HaltOnTruncateFileIOFactory
    implements FileIOFactory {
        private static final long serialVersionUID = 0L;
        private final FileIOFactory delegateFactory;

        HaltOnTruncateFileIOFactory(FileIOFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        private static boolean isPartitionFile(File file) {
            return file.getName().contains("part") && file.getName().endsWith("bin");
        }

        public FileIO create(File file, OpenOption ... modes) throws IOException {
            FileIO delegate = this.delegateFactory.create(file, modes);
            if (HaltOnTruncateFileIOFactory.isPartitionFile(file)) {
                return new HaltOnTruncateFileIO(delegate, file);
            }
            return delegate;
        }
    }

    private static class HaltOnTruncateFileIO
    extends FileIODecorator {
        private final File file;
        private static final AtomicInteger truncations = new AtomicInteger();

        public HaltOnTruncateFileIO(FileIO delegate, File file) {
            super(delegate);
            this.file = file;
        }

        public void clear() throws IOException {
            super.clear();
            System.err.println("Truncated file: " + this.file.getAbsolutePath());
            truncations.incrementAndGet();
            Integer checkpointedPart = null;
            try {
                Field field = GridDhtLocalPartition.class.getDeclaredField("partWhereTestCheckpointEnforced");
                field.setAccessible(true);
                checkpointedPart = (Integer)field.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (truncations.get() > 1 && checkpointedPart != null) {
                System.err.println("JVM is going to be crushed for test reasons...");
                Runtime.getRuntime().halt(0);
            }
        }
    }

    private static class IndexedObject {
        @QuerySqlField(index=true)
        private int iVal;
        @QuerySqlField(index=true)
        private long lVal;
        private byte[] payload = new byte[1024];

        private IndexedObject(int iVal) {
            this.iVal = iVal;
            this.lVal = (long)iVal * (long)iVal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexedObject)) {
                return false;
            }
            IndexedObject that = (IndexedObject)o;
            return this.iVal == that.iVal;
        }

        public int hashCode() {
            return this.iVal;
        }

        public String toString() {
            return S.toString(IndexedObject.class, (Object)this);
        }
    }
}

