/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.junit.Test;

public class DistinctResultTest
extends AbstractIndexingCommonTest {
    private static final int KEY_CNT = 10;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(1);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected void afterTest() throws Exception {
        for (String cache : this.grid(0).cacheNames()) {
            this.grid(0).cache(cache).destroy();
        }
        super.afterTest();
    }

    @Test
    public void distinctDifferentNumericTypes() {
        this.sql("CREATE TABLE table1 (id INT PRIMARY KEY, vint INT, vstr VARCHAR)", new Object[0]);
        this.sql("CREATE TABLE table2 (id INT PRIMARY KEY, vdec DECIMAL, vstr VARCHAR)", new Object[0]);
        this.sql("CREATE TABLE table3 (id INT PRIMARY KEY, vlong LONG, vstr VARCHAR)", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.sql("INSERT INTO table1 VALUES (?, ?, ?)", i, i, "val " + i);
            this.sql("INSERT INTO table2 VALUES (?, ?, ?)", i, new BigDecimal("" + i + ".00"), "val " + i);
            this.sql("INSERT INTO table3 VALUES (?, ?, ?)", i, (long)i, "val " + i);
        }
        List res = this.sql("SELECT vint FROM table1 UNION SELECT vdec FROM table2 UNION SELECT vlong FROM table3", new Object[0]).getAll();
        DistinctResultTest.assertEquals((String)("Invalid results:\n" + res), (int)10, (int)res.size());
    }

    @Test
    public void distinctDifferentDateTimeTypes() {
        this.sql("CREATE TABLE table1 (id INT PRIMARY KEY, vdate DATE, vstr VARCHAR)", new Object[0]);
        this.sql("CREATE TABLE table2 (id INT PRIMARY KEY, vtime TIME, vstr VARCHAR)", new Object[0]);
        this.sql("CREATE TABLE table3 (id INT PRIMARY KEY, vts TIMESTAMP, vstr VARCHAR)", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.sql("INSERT INTO table1 VALUES (?, ?, ?)", i, Date.valueOf("1970-01-01"), "val " + i);
            this.sql("INSERT INTO table2 VALUES (?, ?, ?)", i, Time.valueOf("00:00:00"), "val " + i);
            this.sql("INSERT INTO table3 VALUES (?, ?, ?)", i, Timestamp.valueOf("1970-01-01 00:00:00"), "val " + i);
        }
        List res = this.sql("SELECT vdate FROM table1 UNION SELECT vtime FROM table2 UNION SELECT vts FROM table3", new Object[0]).getAll();
        DistinctResultTest.assertEquals((String)("Invalid results:\n" + res), (int)1, (int)res.size());
    }

    @Test
    public void distinctDateVarchar() {
        this.sql("CREATE TABLE table1 (id INT PRIMARY KEY, vdate DATE)", new Object[0]);
        this.sql("CREATE TABLE table2 (id INT PRIMARY KEY, vstr VARCHAR)", new Object[0]);
        for (int i = 1; i < 10; ++i) {
            this.sql("INSERT INTO table1 VALUES (?, ?)", i, Date.valueOf("2021-01-0" + i));
            this.sql("INSERT INTO table2 VALUES (?, ?)", i, "2021-01-0" + i);
        }
        List res = this.sql("SELECT vdate FROM table1 UNION SELECT vstr FROM table2", new Object[0]).getAll();
        DistinctResultTest.assertEquals((String)("Invalid results:\n" + res), (int)9, (int)res.size());
    }

    private FieldsQueryCursor<List<?>> sql(String sql, Object ... args) {
        return this.sql(this.grid(0), sql, args);
    }

    private FieldsQueryCursor<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLazy(true).setArgs(args), false);
    }
}

