/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractDefaultSchemaTest
extends AbstractIndexingCommonTest {
    private static final String TBL_NAME = "T1";

    protected abstract List<List<?>> execSql(String var1);

    public String tableName(boolean withSchema) {
        String prefix = "";
        if (withSchema) {
            prefix = prefix + "PUBLIC.";
        }
        return prefix + TBL_NAME;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    @Test
    public void testBasicOpsExplicitPublicSchema() {
        this.executeStmtsAndVerify(() -> true);
    }

    @Test
    public void testBasicOpsImplicitPublicSchema() {
        this.executeStmtsAndVerify(() -> false);
    }

    @Test
    public void testBasicOpsMixedPublicSchema() {
        AtomicInteger i = new AtomicInteger();
        this.executeStmtsAndVerify(() -> (i.incrementAndGet() & 1) == 0);
    }

    @Test
    public void testCreateDropNonExistingSchema() {
        GridTestUtils.assertThrowsWithCause(() -> this.sql("CREATE TABLE UNKNOWN_SCHEMA.T1(id INT PRIMARY KEY, val INT)"), SQLException.class);
        GridTestUtils.assertThrowsWithCause(() -> this.sql("DROP TABLE UNKNOWN_SCHEMA.T1"), SQLException.class);
    }

    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-25387")
    @Test
    public void testDropIfExistsNonExistingSchema() {
        this.sql("DROP TABLE IF EXISTS UNKNOWN_SCHEMA.T1");
    }

    private void executeStmtsAndVerify(Supplier<Boolean> withSchemaDecisionSup) {
        this.sql("CREATE TABLE " + this.tableName(withSchemaDecisionSup.get()) + " (id INT PRIMARY KEY, val INT)");
        this.sql("CREATE INDEX t1_idx_1 ON " + this.tableName(withSchemaDecisionSup.get()) + "(val)");
        this.sql("INSERT INTO " + this.tableName(withSchemaDecisionSup.get()) + " (id, val) VALUES(1, 2)");
        this.sql("SELECT * FROM " + this.tableName(withSchemaDecisionSup.get()), res -> this.oneRowList(1, 2).equals(res));
        this.sql("UPDATE " + this.tableName(withSchemaDecisionSup.get()) + " SET val = 5");
        this.sql("SELECT * FROM " + this.tableName(withSchemaDecisionSup.get()), res -> this.oneRowList(1, 5).equals(res));
        this.sql("DELETE FROM " + this.tableName(withSchemaDecisionSup.get()) + " WHERE id = 1");
        this.sql("SELECT COUNT(*) FROM " + this.tableName(withSchemaDecisionSup.get()), res -> this.oneRowList(0L).equals(res));
        this.sql("SELECT COUNT(*) FROM " + QueryUtils.sysSchemaName() + ".TABLES WHERE schema_name = 'PUBLIC' AND table_name = '" + TBL_NAME + "'", res -> this.oneRowList(1L).equals(res));
        this.sql("DROP TABLE " + this.tableName(withSchemaDecisionSup.get()));
    }

    private List<List<?>> oneRowList(Object ... args) {
        return Collections.singletonList(Arrays.asList(args));
    }

    protected void sql(String qry) {
        this.sql(qry, null);
    }

    protected void sql(String qry, @Nullable Predicate<List<List<?>>> validator) {
        List<List<?>> res = this.execSql(qry);
        if (validator != null) {
            Assert.assertTrue((boolean)validator.test(res));
        }
    }
}

