/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.client;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.OdbcConfiguration;
import org.apache.ignite.configuration.SqlConnectorConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class ClientConnectorConfigurationValidationSelfTest
extends GridCommonAbstractTest {
    private static final AtomicInteger NODE_IDX_GEN = new AtomicInteger();
    private static final String CACHE_NAME = "CACHE";

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    @Test
    public void testDefault() throws Exception {
        this.check(new ClientConnectorConfiguration(), true);
        this.checkJdbc(null, 10800);
    }

    @Test
    public void testHost() throws Exception {
        this.check(new ClientConnectorConfiguration().setHost("126.0.0.1"), false);
        this.check(new ClientConnectorConfiguration().setHost("127.0.0.1"), true);
        this.checkJdbc("127.0.0.1", 10800);
        this.check(new ClientConnectorConfiguration().setHost("0.0.0.0"), true);
        this.checkJdbc("0.0.0.0", 10801);
    }

    @Test
    public void testPort() throws Exception {
        this.check(new ClientConnectorConfiguration().setPort(-1), false);
        this.check(new ClientConnectorConfiguration().setPort(0), false);
        this.check(new ClientConnectorConfiguration().setPort(512), false);
        this.check(new ClientConnectorConfiguration().setPort(65536), false);
        this.check(new ClientConnectorConfiguration().setPort(10800), true);
        this.checkJdbc(null, 10800);
        this.check(new ClientConnectorConfiguration().setPort(11000), true);
        this.checkJdbc(null, 11000);
    }

    @Test
    public void testPortRange() throws Exception {
        this.check(new ClientConnectorConfiguration().setPortRange(-1), false);
        this.check(new ClientConnectorConfiguration().setPortRange(0), true);
        this.checkJdbc(null, 10800);
        this.check(new ClientConnectorConfiguration().setPortRange(10), true);
        this.checkJdbc(null, 10801);
    }

    @Test
    public void testSocketBuffers() throws Exception {
        this.check(new ClientConnectorConfiguration().setSocketSendBufferSize(-4096), false);
        this.check(new ClientConnectorConfiguration().setSocketReceiveBufferSize(-4096), false);
        this.check(new ClientConnectorConfiguration().setSocketSendBufferSize(4096), true);
        this.checkJdbc(null, 10800);
        this.check(new ClientConnectorConfiguration().setSocketReceiveBufferSize(4096), true);
        this.checkJdbc(null, 10801);
    }

    @Test
    public void testMaxOpenCusrorsPerConnection() throws Exception {
        this.check(new ClientConnectorConfiguration().setMaxOpenCursorsPerConnection(-1), false);
        this.check(new ClientConnectorConfiguration().setMaxOpenCursorsPerConnection(0), true);
        this.checkJdbc(null, 10800);
        this.check(new ClientConnectorConfiguration().setMaxOpenCursorsPerConnection(100), true);
        this.checkJdbc(null, 10801);
    }

    @Test
    public void testThreadPoolSize() throws Exception {
        this.check(new ClientConnectorConfiguration().setThreadPoolSize(0), false);
        this.check(new ClientConnectorConfiguration().setThreadPoolSize(-1), false);
        this.check(new ClientConnectorConfiguration().setThreadPoolSize(4), true);
        this.checkJdbc(null, 10800);
    }

    @Test
    public void testOdbcConnectorConversion() throws Exception {
        int port = 10799;
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setOdbcConfiguration(new OdbcConfiguration().setEndpointAddress("127.0.0.1:" + port));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, port);
    }

    @Test
    public void testSqlConnectorConversion() throws Exception {
        int port = 10799;
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setSqlConnectorConfiguration(new SqlConnectorConfiguration().setPort(port));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, port);
    }

    @Test
    public void testIgnoreOdbcWhenSqlSet() throws Exception {
        int port = 10799;
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setSqlConnectorConfiguration(new SqlConnectorConfiguration().setPort(port));
        cfg.setOdbcConfiguration(new OdbcConfiguration().setEndpointAddress("127.0.0.1:" + (port - 1)));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, port);
    }

    @Test
    public void testIgnoreOdbcAndSqlWhenClientSet() throws Exception {
        int cliPort = 10799;
        int sqlPort = 10798;
        int odbcPort = 10797;
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setPort(cliPort));
        cfg.setSqlConnectorConfiguration(new SqlConnectorConfiguration().setPort(sqlPort));
        cfg.setOdbcConfiguration(new OdbcConfiguration().setEndpointAddress("127.0.0.1:" + odbcPort));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, cliPort);
    }

    @Test
    public void testIgnoreOdbcWhenClientSet() throws Exception {
        int cliPort = 10799;
        int odbcPort = 10798;
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setPort(cliPort));
        cfg.setOdbcConfiguration(new OdbcConfiguration().setEndpointAddress("127.0.0.1:" + odbcPort));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, cliPort);
    }

    @Test
    public void testIgnoreSqlWhenClientSet() throws Exception {
        int cliPort = 10799;
        int sqlPort = 10798;
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setPort(cliPort));
        cfg.setSqlConnectorConfiguration(new SqlConnectorConfiguration().setPort(sqlPort));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, cliPort);
    }

    @Test
    public void testDisabled() throws Exception {
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(null);
        Ignition.start((IgniteConfiguration)cfg);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientConnectorConfigurationValidationSelfTest.this.checkJdbc(null, 10800);
                return null;
            }
        }, SQLException.class, null);
    }

    @Test
    public void testJdbcConnectionEnabled() throws Exception {
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setJdbcEnabled(true).setOdbcEnabled(false).setThinClientEnabled(false));
        Ignition.start((IgniteConfiguration)cfg);
        this.checkJdbc(null, 10800);
    }

    @Test
    public void testJdbcConnectionDisabled() throws Exception {
        IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setJdbcEnabled(false).setOdbcEnabled(true).setThinClientEnabled(true));
        Ignition.start((IgniteConfiguration)cfg);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientConnectorConfigurationValidationSelfTest.this.checkJdbc(null, 10800);
                return null;
            }
        }, SQLException.class, (String)"JDBC connection is not allowed, see ClientConnectorConfiguration.jdbcEnabled");
    }

    @Test
    public void testJdbcConnectionDisabledForDaemon() throws Exception {
        IgniteConfiguration cfg = this.baseConfiguration().setDaemon(true);
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setJdbcEnabled(true).setThinClientEnabled(true));
        Ignition.start((IgniteConfiguration)cfg);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientConnectorConfigurationValidationSelfTest.this.checkJdbc(null, 10800);
                return null;
            }
        }, SQLException.class, (String)"Failed to connect");
    }

    private IgniteConfiguration baseConfiguration() throws Exception {
        IgniteConfiguration cfg = super.getConfiguration();
        cfg.setIgniteInstanceName(ClientConnectorConfigurationValidationSelfTest.class.getName() + "-" + NODE_IDX_GEN.incrementAndGet());
        cfg.setLocalHost("127.0.0.1");
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        TcpDiscoverySpi spi = new TcpDiscoverySpi();
        spi.setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true));
        cfg.setDiscoverySpi((DiscoverySpi)spi);
        CacheConfiguration ccfg = new CacheConfiguration(CACHE_NAME).setIndexedTypes(new Class[]{ClientConnectorKey.class, ClientConnectorValue.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    private void check(ClientConnectorConfiguration cliConnCfg, boolean success) throws Exception {
        final IgniteConfiguration cfg = this.baseConfiguration();
        cfg.setClientConnectorConfiguration(cliConnCfg);
        if (success) {
            this.startGrid(cfg.getIgniteInstanceName(), cfg);
        } else {
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ClientConnectorConfigurationValidationSelfTest.this.startGrid(cfg.getIgniteInstanceName(), cfg);
                    return null;
                }
            }, IgniteException.class, null);
        }
    }

    private void checkJdbc(@Nullable String host, int port) throws Exception {
        if (host == null) {
            host = "127.0.0.1";
        }
        String connStr = "jdbc:ignite:thin://" + host + ":" + port;
        try (Connection conn = DriverManager.getConnection(connStr);){
            conn.setSchema(CACHE_NAME);
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery("SELECT 1");
                ClientConnectorConfigurationValidationSelfTest.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
            }
        }
    }

    private static class ClientConnectorValue {
        @QuerySqlField
        public int val;

        private ClientConnectorValue() {
        }
    }

    private static class ClientConnectorKey {
        @QuerySqlField
        public int key;

        private ClientConnectorKey() {
        }
    }
}

