/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.ttl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.ClusterReadOnlyModeTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class CacheTtlReadOnlyModeSelfTest
extends GridCommonAbstractTest {
    private static final int EXPIRATION_TIMEOUT = 10;
    private static final CacheConfiguration[] CACHE_CONFIGURATIONS = CacheTtlReadOnlyModeSelfTest.getCacheConfigurations();
    private static final Collection<String> CACHE_NAMES = Stream.of(CACHE_CONFIGURATIONS).map(CacheConfiguration::getName).collect(Collectors.toList());

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setCacheConfiguration(CACHE_CONFIGURATIONS);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testTtlExpirationWorksInReadOnlyMode() throws Exception {
        IgniteEx grid = this.startGrid();
        CacheTtlReadOnlyModeSelfTest.assertEquals((Object)ClusterState.ACTIVE, (Object)grid.cluster().state());
        ClusterReadOnlyModeTestUtils.assertCachesReadOnlyMode((grid.cluster().state() == ClusterState.ACTIVE_READ_ONLY ? 1 : 0) != 0, CACHE_NAMES);
        for (String cacheName : CACHE_NAMES) {
            CacheTtlReadOnlyModeSelfTest.assertEquals((String)cacheName, (int)0, (int)grid.cache(cacheName).size(new CachePeekMode[0]));
            for (int i = 0; i < 10; ++i) {
                grid.cache(cacheName).put((Object)i, (Object)i);
            }
            CacheTtlReadOnlyModeSelfTest.assertEquals((String)cacheName, (int)10, (int)grid.cache(cacheName).size(new CachePeekMode[0]));
        }
        grid.cluster().state(ClusterState.ACTIVE_READ_ONLY);
        CacheTtlReadOnlyModeSelfTest.assertEquals((Object)ClusterState.ACTIVE_READ_ONLY, (Object)grid.cluster().state());
        ClusterReadOnlyModeTestUtils.assertCachesReadOnlyMode((grid.cluster().state() == ClusterState.ACTIVE_READ_ONLY ? 1 : 0) != 0, CACHE_NAMES);
        ClusterReadOnlyModeTestUtils.assertDataStreamerReadOnlyMode((grid.cluster().state() == ClusterState.ACTIVE_READ_ONLY ? 1 : 0) != 0, CACHE_NAMES);
        TimeUnit.SECONDS.sleep(11L);
        for (String cacheName : CACHE_NAMES) {
            CacheTtlReadOnlyModeSelfTest.assertEquals((String)cacheName, (int)0, (int)grid.cache(cacheName).size(new CachePeekMode[0]));
        }
    }

    private static CacheConfiguration[] getCacheConfigurations() {
        CacheConfiguration[] cfgs = ClusterReadOnlyModeTestUtils.cacheConfigurations();
        ArrayList<CacheConfiguration> newCfgs = new ArrayList<CacheConfiguration>(cfgs.length);
        for (CacheConfiguration cfg : cfgs) {
            if (cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) continue;
            cfg.setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 10L)));
            cfg.setEagerTtl(true);
            newCfgs.add(cfg);
        }
        return newCfgs.toArray(new CacheConfiguration[0]);
    }
}

