/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.LongListReuseBag;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class MultipleParallelCacheDeleteDeadlockTest
extends GridCommonAbstractTest {
    private final CountDownLatch testCompletionBlockingLatch = new CountDownLatch(1);
    private final CountDownLatch checkpointBlockingLatch = new CountDownLatch(1);
    private static final long TIME_FOR_EACH_INDEX_PAGE_TO_DESTROY = 300L;
    private static final String CACHE_1 = "cache_1";
    private static final String CACHE_2 = "cache_2";
    private static final String CACHE_GRP_1 = "cache_grp_1";
    private static final String CACHE_GRP_2 = "cache_grp_2";
    private DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory originalFactory;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((FailureHandler)new StopNodeFailureHandler()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0xA00000L).setMaxSize(0x3200000L)).setCheckpointFrequency(Integer.MAX_VALUE)).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(CACHE_1).setGroupName(CACHE_GRP_1).setSqlSchema("PUBLIC"), new CacheConfiguration(CACHE_2).setGroupName(CACHE_GRP_2).setSqlSchema("PUBLIC")});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        this.originalFactory = DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory;
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = new H2TreeFactoryEx();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.originalFactory;
        this.originalFactory = null;
        super.afterTest();
    }

    @Test
    public void testMultipleCacheDelete() throws Exception {
        int i;
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache1 = ignite.getOrCreateCache(CACHE_1);
        IgniteCache cache2 = ignite.getOrCreateCache(CACHE_2);
        this.query((IgniteCache<Integer, Integer>)cache1, "create table t1(id integer primary key, f integer) with \"CACHE_GROUP=cache_grp_1\"");
        this.query((IgniteCache<Integer, Integer>)cache1, "create index idx1 on t1(f)");
        for (i = 0; i < 500; ++i) {
            this.query((IgniteCache<Integer, Integer>)cache1, "insert into t1 (id, f) values (?, ?)", i, i);
        }
        this.query((IgniteCache<Integer, Integer>)cache2, "create table t2(id integer primary key, f integer) with \"CACHE_GROUP=cache_grp_2\"");
        this.query((IgniteCache<Integer, Integer>)cache2, "create index idx2 on t2(f)");
        for (i = 0; i < 500; ++i) {
            this.query((IgniteCache<Integer, Integer>)cache2, "insert into t2 (id, f) values (?, ?)", i, i);
        }
        Thread checkpointer = new Thread(() -> {
            try {
                this.checkpointBlockingLatch.await();
                this.forceCheckpoint();
                this.testCompletionBlockingLatch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread destroyCaches = new Thread(() -> ignite.destroyCaches(Arrays.asList("SQL_PUBLIC_T1", "SQL_PUBLIC_T2")));
        checkpointer.start();
        destroyCaches.start();
        this.testCompletionBlockingLatch.await(60L, TimeUnit.SECONDS);
        MultipleParallelCacheDeleteDeadlockTest.assertEquals((String)"Test hasn't completed in 1 minute - there is possibly a deadlock.", (long)0L, (long)this.testCompletionBlockingLatch.getCount());
    }

    private List<List<?>> query(IgniteCache<Integer, Integer> cache, String qry) {
        return cache.query(new SqlFieldsQuery(qry)).getAll();
    }

    private List<List<?>> query(IgniteCache<Integer, Integer> cache, String qry, Object ... args) {
        return cache.query(new SqlFieldsQuery(qry).setArgs(args)).getAll();
    }

    private class H2TreeFactoryEx
    extends DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory {
        private H2TreeFactoryEx() {
        }

        protected H2Tree create(final CacheGroupContext grpCtx, RootPage rootPage, String treeName, String idxName, String cacheName) throws IgniteCheckedException {
            IgniteCacheOffheapManager offheap = grpCtx.offheap();
            GridKernalContext ctx = grpCtx.shared().kernalContext();
            return new H2Tree(null, null, treeName, idxName, cacheName, null, offheap.reuseListForIndex(treeName), grpCtx.groupId(), grpCtx.cacheOrGroupName(), grpCtx.dataRegion().pageMemory(), grpCtx.shared().wal(), (AtomicLong)offheap.globalRemoveId(), rootPage.pageId().pageId(), false, Collections.emptyList(), Collections.emptyList(), new AtomicInteger(0), false, false, false, null, ctx.failure(), grpCtx.shared().diagnostic().pageLockTracker(), null, null, null, 0, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER){

                protected long destroyDownPages(LongListReuseBag bag, long pageId, int lvl, IgniteInClosure<H2Row> c, AtomicLong lockHoldStartTime, long lockMaxTime, Deque<GridTuple3<Long, Long, Long>> lockedPages) throws IgniteCheckedException {
                    GridAbstractTest.doSleep((long)300L);
                    return super.destroyDownPages(bag, pageId, lvl, c, lockHoldStartTime, lockMaxTime, lockedPages);
                }

                protected void temporaryReleaseLock() {
                    grpCtx.shared().database().checkpointReadUnlock();
                    grpCtx.shared().database().checkpointReadLock();
                    MultipleParallelCacheDeleteDeadlockTest.this.checkpointBlockingLatch.countDown();
                }

                protected long maxLockHoldTime() {
                    return 10L;
                }
            };
        }
    }
}

