/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.LongListReuseBag;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTask;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTaskV2;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.CallbackExecutorLogListener;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.MessageOrderLogListener;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.thread.IgniteThread;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_SYSTEM_WORKER_BLOCKED_TIMEOUT", value="5000")})
public class LongDestroyDurableBackgroundTaskTest
extends GridCommonAbstractTest {
    private static final int NODES_COUNT = 2;
    private static final int RESTARTED_NODE_NUM = 0;
    private static final int ALWAYS_ALIVE_NODE_NUM = 1;
    private static final long TIME_FOR_EACH_INDEX_PAGE_TO_DESTROY = 300L;
    private static final String IDX_NAME = "T_IDX";
    private final LogListener blockedSysCriticalThreadLsnr = LogListener.matches((String)"Blocked system-critical thread has been detected").build();
    private CountDownLatch pendingDelLatch;
    private CountDownLatch idxsRebuildLatch;
    private final LogListener pendingDelFinishedLsnr = new CallbackExecutorLogListener(".*?Execution of durable background task completed.*", () -> this.pendingDelLatch.countDown());
    private final LogListener idxsRebuildFinishedLsnr = new CallbackExecutorLogListener("Indexes rebuilding completed for all caches.", () -> this.idxsRebuildLatch.countDown());
    private final LogListener taskLifecycleLsnr = new MessageOrderLogListener(new String[]{".*?Executing durable background task: drop-sql-index-SQL_PUBLIC_T-T_IDX-.*", ".*?Could not execute durable background task: drop-sql-index-SQL_PUBLIC_T-T_IDX-.*", ".*?Executing durable background task: drop-sql-index-SQL_PUBLIC_T-T_IDX-.*", ".*?Execution of durable background task completed: drop-sql-index-SQL_PUBLIC_T-T_IDX-.*"});
    private final AtomicBoolean blockDestroy = new AtomicBoolean(false);
    private final AtomicBoolean slowDownTreeDestroy = new AtomicBoolean(true);
    private final ListeningTestLogger testLog = new ListeningTestLogger(false, this.log(), new LogListener[]{this.blockedSysCriticalThreadLsnr, this.pendingDelFinishedLsnr, this.idxsRebuildFinishedLsnr, this.taskLifecycleLsnr});
    private DurableBackgroundTaskTestListener durableBackgroundTaskTestLsnr;
    private DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory originalFactory;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setFailureHandler((FailureHandler)new StopNodeFailureHandler()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true).setInitialSize(0xA00000L).setMaxSize(0x6400000L)).setDataRegionConfigurations(new DataRegionConfiguration[]{new DataRegionConfiguration().setName("dr1").setPersistenceEnabled(false)}).setCheckpointFrequency(0x3FFFFFFFFFFFFFFFL)).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setBackups(1).setSqlSchema("PUBLIC"), new CacheConfiguration("TEST").setSqlSchema("PUBLIC").setBackups(1).setDataRegionName("dr1")}).setGridLogger((IgniteLogger)this.testLog);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
        this.blockedSysCriticalThreadLsnr.reset();
        this.pendingDelLatch = new CountDownLatch(1);
        this.idxsRebuildLatch = new CountDownLatch(1);
        this.originalFactory = DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory;
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = new H2TreeFactoryEx();
        this.slowDownTreeDestroy.set(true);
    }

    protected void afterTest() throws Exception {
        this.blockedSysCriticalThreadLsnr.reset();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.durableBackgroundTaskTestLsnr = null;
        DurableBackgroundCleanupIndexTreeTaskV2.idxTreeFactory = this.originalFactory;
        this.originalFactory = null;
        super.afterTest();
    }

    private void testLongIndexDeletion(boolean restart, boolean rebalance, boolean multicolumn, boolean checkWhenOneNodeStopped, boolean dropIdxWhenOneNodeStopped) throws Exception {
        boolean dropIdxWhenOneNodeStopped0 = !restart || dropIdxWhenOneNodeStopped;
        int nodeCnt = 2;
        IgniteEx ignite = this.prepareAndPopulateCluster(nodeCnt, multicolumn, false);
        IgniteEx aliveNode = this.grid(1);
        IgniteCache cacheOnAliveNode = aliveNode.cache("default");
        if (rebalance) {
            this.startGrid(nodeCnt);
            Collection blt = IntStream.range(0, ++nodeCnt).mapToObj(i -> this.grid(i).localNode()).collect(Collectors.toList());
            ignite.cluster().setBaselineTopology(blt);
        }
        if (restart) {
            this.blockDestroy.set(true);
            this.stopGrid(0, true);
            this.awaitPartitionMapExchange();
            this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cacheOnAliveNode, false);
            if (checkWhenOneNodeStopped) {
                this.createIndex((IgniteCache<Integer, Integer>)cacheOnAliveNode, multicolumn);
                this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cacheOnAliveNode, true);
                if (dropIdxWhenOneNodeStopped0) {
                    this.query((IgniteCache<Integer, Integer>)cacheOnAliveNode, "drop index T_IDX");
                }
                this.forceCheckpoint((Ignite)aliveNode);
                aliveNode.cluster().active(false);
            }
            ignite = this.startGrid(0);
            this.awaitLatch(this.pendingDelLatch, "Test timed out: failed to await for durable background task completion.");
            this.awaitPartitionMapExchange();
            if (checkWhenOneNodeStopped) {
                ignite.cluster().active(true);
                if (!dropIdxWhenOneNodeStopped0) {
                    this.awaitLatch(this.idxsRebuildLatch, "Failed to wait for indexes rebuilding.");
                }
            }
            this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cacheOnAliveNode, !dropIdxWhenOneNodeStopped0);
        } else {
            this.awaitLatch(this.pendingDelLatch, "Test timed out: failed to await for durable background task completion.");
        }
        IgniteCache cache = this.grid(0).cache("default");
        this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cache, !dropIdxWhenOneNodeStopped0);
        this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cacheOnAliveNode, !dropIdxWhenOneNodeStopped0);
        if (dropIdxWhenOneNodeStopped0) {
            this.createIndex((IgniteCache<Integer, Integer>)cache, multicolumn);
        }
        this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cache, true);
        this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cacheOnAliveNode, true);
        this.forceCheckpoint();
        this.validateIndexes((Ignite)ignite);
        LongDestroyDurableBackgroundTaskTest.assertFalse((boolean)this.blockedSysCriticalThreadLsnr.check());
    }

    private void awaitLatch(CountDownLatch latch, String failMsg) throws InterruptedException {
        if (!latch.await(60L, TimeUnit.SECONDS)) {
            LongDestroyDurableBackgroundTaskTest.fail((String)failMsg);
        }
    }

    private void validateIndexes(Ignite ignite) {
        HashSet<UUID> nodeIds = new HashSet<UUID>(){
            {
                this.add(LongDestroyDurableBackgroundTaskTest.this.grid(0).cluster().localNode().id());
                this.add(LongDestroyDurableBackgroundTaskTest.this.grid(1).cluster().localNode().id());
            }
        };
        log.info("Doing indexes validation.");
        VisorValidateIndexesTaskArg taskArg = new VisorValidateIndexesTaskArg(Collections.singleton("SQL_PUBLIC_T"), (Set)nodeIds, 0, 1, true, true);
        VisorValidateIndexesTaskResult taskRes = (VisorValidateIndexesTaskResult)ignite.compute().execute(VisorValidateIndexesTask.class.getName(), (Object)new VisorTaskArgument((Collection)nodeIds, (Object)taskArg, false));
        if (!taskRes.exceptions().isEmpty()) {
            for (Map.Entry e : taskRes.exceptions().entrySet()) {
                log.error("Exception while validation indexes on node id=" + ((UUID)e.getKey()).toString(), (Throwable)e.getValue());
            }
        }
        for (Map.Entry nodeEntry : taskRes.results().entrySet()) {
            if (!((VisorValidateIndexesJobResult)nodeEntry.getValue()).hasIssues()) continue;
            log.error("Validate indexes issues had been found on node id=" + ((UUID)nodeEntry.getKey()).toString());
            log.error("Integrity check failures: " + ((VisorValidateIndexesJobResult)nodeEntry.getValue()).integrityCheckFailures().size());
            ((VisorValidateIndexesJobResult)nodeEntry.getValue()).integrityCheckFailures().forEach(f -> log.error(f.toString()));
            this.logIssuesFromMap("Partition results", ((VisorValidateIndexesJobResult)nodeEntry.getValue()).partitionResult());
            this.logIssuesFromMap("Index validation issues", ((VisorValidateIndexesJobResult)nodeEntry.getValue()).indexResult());
        }
        LongDestroyDurableBackgroundTaskTest.assertTrue((boolean)taskRes.exceptions().isEmpty());
        for (VisorValidateIndexesJobResult res : taskRes.results().values()) {
            LongDestroyDurableBackgroundTaskTest.assertFalse((boolean)res.hasIssues());
        }
    }

    private void logIssuesFromMap(String caption, Map<?, ValidateIndexesPartitionResult> map) {
        LinkedList partResIssues = new LinkedList();
        map.forEach((k, v) -> v.issues().forEach(vi -> partResIssues.add(k.toString() + ": " + vi.toString())));
        log.error(caption + ": " + partResIssues.size());
        partResIssues.forEach(r -> log.error(r));
    }

    private void checkSelectAndPlan(IgniteCache<Integer, Integer> cache, boolean idxShouldExist) {
        String plan = this.query(cache, "explain select id, p from t where p = 0").get(0).get(0).toString();
        LongDestroyDurableBackgroundTaskTest.assertEquals((String)plan, (boolean)idxShouldExist, (boolean)plan.toUpperCase().contains(IDX_NAME));
        String val = this.query(cache, "select p from t where p = 100").get(0).get(0).toString();
        LongDestroyDurableBackgroundTaskTest.assertEquals((String)"100", (String)val);
    }

    private void createIndex(IgniteCache<Integer, Integer> cache, boolean multicolumn) {
        this.query(cache, "create index T_IDX on t (p" + (multicolumn ? ", f)" : ")"));
    }

    private List<List<?>> query(IgniteCache<Integer, Integer> cache, String qry) {
        return cache.query(new SqlFieldsQuery(qry)).getAll();
    }

    private List<List<?>> query(IgniteCache<Integer, Integer> cache, String qry, Object ... args) {
        return cache.query(new SqlFieldsQuery(qry).setArgs(args)).getAll();
    }

    private IgniteEx prepareAndPopulateCluster(int nodeCnt, boolean multicolumn, boolean createLsnr) throws Exception {
        IgniteEx ignite = this.startGrids(nodeCnt);
        if (createLsnr) {
            GridCacheSharedContext ctx = ignite.context().cache().context();
            this.durableBackgroundTaskTestLsnr = new DurableBackgroundTaskTestListener((ReadWriteMetastorage)ctx.database().metaStorage());
            ((GridCacheDatabaseSharedManager)ctx.cache().context().database()).addCheckpointListener((CheckpointListener)this.durableBackgroundTaskTestLsnr);
        }
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.getOrCreateCache("default");
        this.query((IgniteCache<Integer, Integer>)cache, "create table t (id integer primary key, p integer, f integer) with \"BACKUPS=1\"");
        this.createIndex((IgniteCache<Integer, Integer>)cache, multicolumn);
        for (int i = 0; i < 5000; ++i) {
            this.query((IgniteCache<Integer, Integer>)cache, "insert into t (id, p, f) values (?, ?, ?)", i, i, i);
        }
        this.forceCheckpoint();
        this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cache, true);
        IgniteCache finalCache = cache;
        new Thread(() -> finalCache.query(new SqlFieldsQuery("drop index T_IDX")).getAll()).start();
        LongDestroyDurableBackgroundTaskTest.doSleep((long)500L);
        this.forceCheckpoint();
        return ignite;
    }

    @Test
    public void testClusterDeactivationShouldPassWithoutErrors() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.cache("TEST");
        this.query((IgniteCache<Integer, Integer>)cache, "create table TEST (id integer primary key, p integer, f integer) with \"DATA_REGION=dr1\"");
        this.query((IgniteCache<Integer, Integer>)cache, "create index TEST_IDX on TEST (p)");
        for (int i = 0; i < 5000; ++i) {
            this.query((IgniteCache<Integer, Integer>)cache, "insert into TEST (id, p, f) values (?, ?, ?)", i, i, i);
        }
        LogListener lsnr = LogListener.matches((String)"Could not execute durable background task").build();
        LogListener lsnr2 = LogListener.matches((String)"Executing durable background task").build();
        LogListener lsnr3 = LogListener.matches((String)"Execution of durable background task completed").build();
        this.testLog.registerAllListeners(new LogListener[]{lsnr, lsnr2, lsnr3});
        ignite.cluster().active(false);
        LongDestroyDurableBackgroundTaskTest.doSleep((long)1000L);
        LongDestroyDurableBackgroundTaskTest.assertFalse((boolean)lsnr.check());
        LongDestroyDurableBackgroundTaskTest.assertFalse((boolean)lsnr2.check());
        LongDestroyDurableBackgroundTaskTest.assertFalse((boolean)lsnr3.check());
        this.testLog.unregisterListener((Consumer)lsnr);
        this.testLog.unregisterListener((Consumer)lsnr2);
        this.testLog.unregisterListener((Consumer)lsnr3);
        for (int i = 0; i < 2; ++i) {
            this.grid(i);
        }
    }

    @Test
    public void testLongIndexDeletionSimple() throws Exception {
        this.testLongIndexDeletion(false, false, false, false, true);
    }

    @Test
    public void testLongMulticolumnIndexDeletion() throws Exception {
        this.testLongIndexDeletion(false, false, true, false, true);
    }

    @Test
    public void testLongIndexDeletionWithRestart() throws Exception {
        this.testLongIndexDeletion(true, false, false, false, true);
    }

    @Test
    public void testLongIndexDeletionWithRebalance() throws Exception {
        this.testLongIndexDeletion(false, true, false, false, true);
    }

    @Test
    public void testLongIndexDeletionCheckWhenOneNodeStopped() throws Exception {
        this.slowDownTreeDestroy.set(false);
        this.testLongIndexDeletion(true, false, false, true, false);
    }

    @Test
    public void testLongIndexDeletionCheckWhenOneNodeStoppedAndDropIndex() throws Exception {
        this.testLongIndexDeletion(true, false, false, true, true);
    }

    @Test
    public void testDestroyTaskLifecycle() throws Exception {
        this.taskLifecycleLsnr.reset();
        IgniteEx ignite = this.prepareAndPopulateCluster(1, false, false);
        IgniteCache cache = ignite.cache("default");
        this.checkSelectAndPlan((IgniteCache<Integer, Integer>)cache, false);
        ignite.cluster().state(ClusterState.INACTIVE);
        ignite.cluster().state(ClusterState.ACTIVE);
        ignite.cache("default").indexReadyFuture().get();
        this.blockDestroy.set(true);
        this.stopGrid(0);
        this.blockDestroy.set(false);
        this.startGrid(0);
        this.awaitLatch(this.pendingDelLatch, "Test timed out: failed to await for durable background task completion.");
        LongDestroyDurableBackgroundTaskTest.assertTrue((boolean)this.taskLifecycleLsnr.check());
    }

    @Test
    public void testIrrelevantTasksAreCleared() throws Exception {
        this.taskLifecycleLsnr.reset();
        IgniteEx ignite = this.prepareAndPopulateCluster(1, false, false);
        IgniteCache cache = ignite.cache("default");
        this.query((IgniteCache<Integer, Integer>)cache, "drop table t");
        this.awaitPartitionMapExchange();
        this.stopAllGrids();
        LongDestroyDurableBackgroundTaskTest.assertTrue((this.pendingDelLatch.getCount() > 0L ? 1 : 0) != 0);
        this.startGrid(0);
        this.awaitPartitionMapExchange();
        this.awaitLatch(this.pendingDelLatch, "Test timed out: failed to await for durable background task completion.");
    }

    @Test
    public void testRemoveIndexesOnTableDrop() throws Exception {
        IgniteEx ignite = this.startGrids(1);
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.getOrCreateCache("default");
        this.query((IgniteCache<Integer, Integer>)cache, "create table t1 (id integer primary key, p integer, f integer) with \"BACKUPS=1, CACHE_GROUP=grp_test_table\"");
        this.query((IgniteCache<Integer, Integer>)cache, "create table t2 (id integer primary key, p integer, f integer) with \"BACKUPS=1, CACHE_GROUP=grp_test_table\"");
        this.query((IgniteCache<Integer, Integer>)cache, "create index t2_idx on t2 (p)");
        for (int i = 0; i < 5000; ++i) {
            this.query((IgniteCache<Integer, Integer>)cache, "insert into t2 (id, p, f) values (?, ?, ?)", i, i, i);
        }
        this.forceCheckpoint();
        CountDownLatch inxDelInAsyncTaskLatch = new CountDownLatch(1);
        CallbackExecutorLogListener lsnr = new CallbackExecutorLogListener(".*?Execution of durable background task completed: drop-sql-index-SQL_PUBLIC_T2-T2_IDX-.*", inxDelInAsyncTaskLatch::countDown);
        this.testLog.registerListener((LogListener)lsnr);
        ignite.destroyCache("SQL_PUBLIC_T2");
        this.awaitLatch(inxDelInAsyncTaskLatch, "Failed to await for index deletion in async task (either index failed to delete in 1 minute or async task not started)");
    }

    @Test
    public void testIndexDeletionTaskRemovedAfterCheckpointFinished() throws Exception {
        this.prepareAndPopulateCluster(1, false, true);
        this.awaitLatch(this.pendingDelLatch, "Test timed out: failed to await for durable background task completion.");
        this.forceCheckpoint();
        LongDestroyDurableBackgroundTaskTest.assertTrue((boolean)this.durableBackgroundTaskTestLsnr.check());
    }

    @Test
    public void testConvertOldTaskToNew() {
        String grpName = "grpTest";
        String cacheName = "cacheTest";
        String treeName = "treeTest";
        String idxName = "idxTest";
        String schemaName = "schemaTest";
        List pages = F.asList((Object)100L);
        DurableBackgroundCleanupIndexTreeTask oldTask = new DurableBackgroundCleanupIndexTreeTask(pages, Collections.emptyList(), grpName, cacheName, schemaName, treeName, idxName);
        DurableBackgroundTask convertedTask = oldTask.convertAfterRestoreIfNeeded();
        LongDestroyDurableBackgroundTaskTest.assertTrue((boolean)(convertedTask instanceof DurableBackgroundCleanupIndexTreeTaskV2));
        LongDestroyDurableBackgroundTaskTest.assertEquals((String)grpName, (String)((String)GridTestUtils.getFieldValue((Object)convertedTask, (String[])new String[]{"grpName"})));
        LongDestroyDurableBackgroundTaskTest.assertEquals((String)cacheName, (String)((String)GridTestUtils.getFieldValue((Object)convertedTask, (String[])new String[]{"cacheName"})));
        LongDestroyDurableBackgroundTaskTest.assertEquals((String)treeName, (String)((String)GridTestUtils.getFieldValue((Object)convertedTask, (String[])new String[]{"oldTreeName"})));
        LongDestroyDurableBackgroundTaskTest.assertNotNull((Object)GridTestUtils.getFieldValue((Object)convertedTask, (String[])new String[]{"newTreeName"}));
        LongDestroyDurableBackgroundTaskTest.assertEquals((String)idxName, (String)((String)GridTestUtils.getFieldValue((Object)convertedTask, (String[])new String[]{"idxName"})));
        LongDestroyDurableBackgroundTaskTest.assertEquals((int)pages.size(), (int)((Integer)GridTestUtils.getFieldValue((Object)convertedTask, (String[])new String[]{"segments"})));
    }

    private class H2TreeFactoryEx
    extends DurableBackgroundCleanupIndexTreeTaskV2.H2TreeFactory {
        private H2TreeFactoryEx() {
        }

        protected H2Tree create(final CacheGroupContext grpCtx, RootPage rootPage, String treeName, String idxName, String cacheName) throws IgniteCheckedException {
            IgniteCacheOffheapManager offheap = grpCtx.offheap();
            final GridKernalContext ctx = grpCtx.shared().kernalContext();
            return new H2Tree(null, null, treeName, idxName, cacheName, null, offheap.reuseListForIndex(treeName), grpCtx.groupId(), grpCtx.cacheOrGroupName(), grpCtx.dataRegion().pageMemory(), grpCtx.shared().wal(), (AtomicLong)offheap.globalRemoveId(), rootPage.pageId().pageId(), false, Collections.emptyList(), Collections.emptyList(), new AtomicInteger(0), false, false, false, null, ctx.failure(), grpCtx.shared().diagnostic().pageLockTracker(), null, null, null, 0, PageIoResolver.DEFAULT_PAGE_IO_RESOLVER){

                protected long destroyDownPages(LongListReuseBag bag, long pageId, int lvl, IgniteInClosure<H2Row> c, AtomicLong lockHoldStartTime, long lockMaxTime, Deque<GridTuple3<Long, Long, Long>> lockedPages) throws IgniteCheckedException {
                    IgniteThread thread;
                    if (LongDestroyDurableBackgroundTaskTest.this.slowDownTreeDestroy.get()) {
                        GridAbstractTest.doSleep((long)300L);
                    }
                    if (Thread.currentThread() instanceof IgniteThread && (thread = (IgniteThread)Thread.currentThread()).getIgniteInstanceName().endsWith(String.valueOf(0)) && LongDestroyDurableBackgroundTaskTest.this.blockDestroy.compareAndSet(true, false)) {
                        throw new RuntimeException("Aborting destroy (test).");
                    }
                    return super.destroyDownPages(bag, pageId, lvl, c, lockHoldStartTime, lockMaxTime, lockedPages);
                }

                protected void temporaryReleaseLock() {
                    grpCtx.shared().database().checkpointReadUnlock();
                    grpCtx.shared().database().checkpointReadLock();
                }

                protected long maxLockHoldTime() {
                    long sysWorkerBlockedTimeout = ctx.workersRegistry().getSystemWorkerBlockedTimeout();
                    return sysWorkerBlockedTimeout == 0L ? Long.MAX_VALUE : sysWorkerBlockedTimeout / 10L;
                }
            };
        }
    }

    private class DurableBackgroundTaskTestListener
    implements CheckpointListener {
        private static final String STORE_DURABLE_BACKGROUND_TASK_PREFIX = "durable-background-task-";
        private volatile ReadOnlyMetastorage metastorage;
        private List<String> savedTasks = new ArrayList<String>();

        public DurableBackgroundTaskTestListener(ReadWriteMetastorage metastorage) {
            this.metastorage = metastorage;
        }

        public boolean check() throws IgniteCheckedException {
            if (this.savedTasks.isEmpty()) {
                return false;
            }
            for (String taskKey : this.savedTasks) {
                DurableBackgroundTask task = (DurableBackgroundTask)this.metastorage.read(taskKey);
                if (task == null) continue;
                return false;
            }
            return true;
        }

        public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
        }

        public void onCheckpointBegin(CheckpointListener.Context ctx) {
        }

        public void beforeCheckpointBegin(CheckpointListener.Context ctx) throws IgniteCheckedException {
            this.metastorage.iterate(STORE_DURABLE_BACKGROUND_TASK_PREFIX, (key, val) -> this.savedTasks.add((String)key), true);
        }
    }
}

