/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.db;

import com.google.common.base.Strings;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteTcBotInitNewPageTest
extends GridCommonAbstractTest {
    public static final String CACHE = "cache";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    @Test
    public void testInitNewPagePageIdConsistency() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.cache(CACHE);
        try (IgniteDataStreamer ds = ignite.dataStreamer(CACHE);){
            for (int i = 0; i < GridTestUtils.SF.apply((int)1000000); ++i) {
                ds.addData((Object)i, (Object)i);
            }
        }
        cache.clear();
        String longStr = Strings.repeat((String)"Apache Ignite", (int)GridTestUtils.SF.apply((int)1000));
        try (IgniteDataStreamer ds = ignite.dataStreamer(CACHE);){
            for (int i = 0; i < 1000; ++i) {
                ds.addData((Object)i, (Object)longStr);
            }
        }
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration(CACHE);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 4));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        DataRegionConfiguration regCfg = new DataRegionConfiguration().setMaxSize((long)(GridTestUtils.SF.apply((int)128) * 1024 * 1024)).setPersistenceEnabled(true);
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setWalMode(WALMode.LOG_ONLY).setDefaultDataRegionConfiguration(regCfg);
        cfg.setDataStorageConfiguration(dsCfg);
        return cfg;
    }
}

