/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.CallbackExecutorLogListener;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.MessageOrderLogListener;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class RebuildIndexLogMessageTest
extends GridCommonAbstractTest
implements Serializable {
    private static final String CACHE_NAME_A = "testCacheA";
    private static final String CACHE_NAME_B = "testCacheB";
    private final CountDownLatch checkLatch = new CountDownLatch(1);
    private final LogListener logLsnr = new MessageOrderLogListener(new MessageOrderLogListener.MessageGroup(true).add(new MessageOrderLogListener.MessageGroup(false).add(new MessageOrderLogListener.MessageGroup(true).add("Started indexes rebuilding for cache \\[name=testCacheA.*").add("((Finished indexes rebuilding)|(Failed to rebuild indexes)) for cache \\[name=testCacheA.*")).add(new MessageOrderLogListener.MessageGroup(true).add("Started indexes rebuilding for cache \\[name=testCacheB.*").add("((Finished indexes rebuilding)|(Failed to rebuild indexes)) for cache \\[name=testCacheB.*"))).add("Indexes rebuilding completed for all caches."));
    private final LogListener latchLsnr = new CallbackExecutorLogListener("Indexes rebuilding completed for all caches.", this.checkLatch::countDown);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        ListeningTestLogger testLog = new ListeningTestLogger(false, super.getConfiguration(igniteInstanceName).getGridLogger());
        testLog.registerListener(this.logLsnr);
        testLog.registerListener(this.latchLsnr);
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)testLog).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration().setName(CACHE_NAME_A).setBackups(0).setIndexedTypes(new Class[]{Integer.class, Person.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8)), new CacheConfiguration().setName(CACHE_NAME_B).setBackups(0).setIndexedTypes(new Class[]{Integer.class, Person.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8))});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    @Test
    public void testRebuildIndexLogMessage() throws Exception {
        int i;
        IgniteEx ignite = this.startGrids(1);
        String gridName = ignite.name();
        ignite.cluster().active(true);
        IgniteCache cacheA = ignite.getOrCreateCache(CACHE_NAME_A);
        IgniteCache cacheB = ignite.getOrCreateCache(CACHE_NAME_B);
        IgniteInternalCache cacheAEx = ignite.cachex(CACHE_NAME_A);
        IgniteInternalCache cacheBEx = ignite.cachex(CACHE_NAME_B);
        for (i = 0; i < 100; ++i) {
            cacheA.put((Object)i, (Object)new Person(i, i));
        }
        for (i = 0; i < 100; ++i) {
            cacheB.put((Object)i, (Object)new Person(i, i));
        }
        this.forceCheckpoint();
        File cacheAWorkDir = ((FilePageStoreManager)cacheAEx.context().shared().pageStore()).cacheWorkDir(cacheAEx.configuration());
        File cacheBWorkDir = ((FilePageStoreManager)cacheBEx.context().shared().pageStore()).cacheWorkDir(cacheBEx.configuration());
        File idxPathA = cacheAWorkDir.toPath().resolve("index.bin").toFile();
        File idxPathB = cacheBWorkDir.toPath().resolve("index.bin").toFile();
        this.stopAllGrids();
        RebuildIndexLogMessageTest.assertTrue((boolean)U.delete((File)idxPathA));
        RebuildIndexLogMessageTest.assertTrue((boolean)U.delete((File)idxPathB));
        ignite = this.startGrid(this.getConfiguration(gridName));
        ignite.cluster().active(true);
        cacheA = ignite.getOrCreateCache(CACHE_NAME_A);
        cacheB = ignite.getOrCreateCache(CACHE_NAME_B);
        cacheA.put((Object)1000, (Object)new Person(1000, 1));
        cacheB.put((Object)1000, (Object)new Person(1000, 1));
        this.checkLatch.await(60L, TimeUnit.SECONDS);
        if (this.checkLatch.getCount() > 0L) {
            throw new TimeoutException("Test timed out: cannot detect log message about completion of indexes rebuilding");
        }
        RebuildIndexLogMessageTest.assertTrue((boolean)this.logLsnr.check());
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int age;

        Person(int id, int age) {
            this.id = id;
            this.age = age;
        }

        public int age() {
            return this.age;
        }
    }
}

