/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.mvcc.CacheMvccAbstractTest;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.MvccFeatureChecker;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.junit.Test;

public abstract class CacheMvccSqlQueriesAbstractTest
extends CacheMvccAbstractTest {
    @Test
    public void testAccountsTxSql_SingleNode_SinglePartition() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT);
    }

    @Test
    public void testAccountsTxSql_WithRemoves_SingleNode_SinglePartition() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 1, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT);
    }

    @Test
    public void testAccountsTxSql_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT);
    }

    @Test
    public void testAccountsTxSql_SingleNode_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxSql_SingleNode();
    }

    @Test
    public void testAccountsTxSumSql_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL_SUM, CacheMvccAbstractTest.WriteMode.PUT);
    }

    @Test
    public void testAccountsTxSql_WithRemoves_SingleNode() throws Exception {
        this.accountsTxReadAll(1, 0, 0, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), true, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT);
    }

    @Test
    public void testAccountsTxSql_WithRemoves_SingleNode_Persistence() throws Exception {
        this.persistence = true;
        this.testAccountsTxSql_WithRemoves_SingleNode();
    }

    @Test
    public void testAccountsTxSql_ClientServer_Backups2() throws Exception {
        this.accountsTxReadAll(4, 2, 2, 64, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}), false, CacheMvccAbstractTest.ReadMode.SQL, CacheMvccAbstractTest.WriteMode.PUT);
    }

    @Test
    public void testUpdateSingleValue_SingleNode() throws Exception {
        this.updateSingleValue(true, false);
    }

    @Test
    public void testUpdateSingleValue_LocalQuery_SingleNode() throws Exception {
        this.updateSingleValue(true, true);
    }

    @Test
    public void testUpdateSingleValue_ClientServer() throws Exception {
        this.updateSingleValue(false, false);
    }

    private void updateSingleValue(boolean singleNode, final boolean locQry) throws Exception {
        int clients;
        int srvs;
        int VALS = 100;
        int writers = 4;
        int readers = 4;
        int INC_BY = 110;
        IgniteInClosure<IgniteCache<Object, Object>> init = new IgniteInClosure<IgniteCache<Object, Object>>(){

            public void apply(IgniteCache<Object, Object> cache) {
                HashMap<Integer, MvccTestSqlIndexValue> vals = new HashMap<Integer, MvccTestSqlIndexValue>();
                for (int i = 0; i < 100; ++i) {
                    vals.put(i, new MvccTestSqlIndexValue(i));
                }
                cache.putAll(vals);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> writer = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int cnt = 0;
                block5: while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        Integer key = rnd.nextInt(100);
                        while (true) {
                            try {
                                cache.cache.invoke((Object)key, (CacheEntryProcessor)new CacheEntryProcessor<Integer, MvccTestSqlIndexValue, Object>(){

                                    public Object process(MutableEntry<Integer, MvccTestSqlIndexValue> e, Object ... args) {
                                        int newIdxVal;
                                        Integer key = (Integer)e.getKey();
                                        MvccTestSqlIndexValue val = (MvccTestSqlIndexValue)e.getValue();
                                        if (val.idxVal1 < 110) {
                                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)key, (int)val.idxVal1);
                                            newIdxVal = val.idxVal1 + 110;
                                        } else {
                                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)(110 + key), (int)val.idxVal1);
                                            newIdxVal = key;
                                        }
                                        e.setValue((Object)new MvccTestSqlIndexValue(newIdxVal));
                                        return null;
                                    }
                                }, new Object[0]);
                                continue block5;
                            }
                            catch (CacheException e) {
                                MvccFeatureChecker.assertMvccWriteConflict((Exception)((Object)e));
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                CacheMvccSqlQueriesAbstractTest.this.info("Writer finished, updates: " + cnt);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> reader = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                ArrayList<SqlFieldsQuery> fieldsQrys = new ArrayList<SqlFieldsQuery>();
                fieldsQrys.add(new SqlFieldsQuery("select _key, idxVal1 from MvccTestSqlIndexValue where idxVal1=?").setLocal(locQry));
                fieldsQrys.add(new SqlFieldsQuery("select _key, idxVal1 from MvccTestSqlIndexValue where idxVal1=? or idxVal1=?").setLocal(locQry));
                fieldsQrys.add(new SqlFieldsQuery("select _key, idxVal1 from MvccTestSqlIndexValue where _key=?").setLocal(locQry));
                ArrayList<SqlQuery> sqlQrys = new ArrayList<SqlQuery>();
                sqlQrys.add(new SqlQuery(MvccTestSqlIndexValue.class, "idxVal1=?").setLocal(locQry));
                sqlQrys.add(new SqlQuery(MvccTestSqlIndexValue.class, "idxVal1=? or idxVal1=?").setLocal(locQry));
                sqlQrys.add(new SqlQuery(MvccTestSqlIndexValue.class, "_key=?").setLocal(locQry));
                while (!stop.get()) {
                    List res;
                    Integer key = rnd.nextInt(100);
                    int qryIdx = rnd.nextInt(3);
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        SqlFieldsQuery qry;
                        if (rnd.nextBoolean()) {
                            qry = (SqlFieldsQuery)fieldsQrys.get(qryIdx);
                            if (qryIdx == 1) {
                                qry.setArgs(new Object[]{key, key + 110});
                            } else {
                                qry.setArgs(new Object[]{key});
                            }
                            res = cache.cache.query(qry).getAll();
                        } else {
                            qry = (SqlQuery)sqlQrys.get(qryIdx);
                            if (qryIdx == 1) {
                                qry.setArgs(new Object[]{key, key + 110});
                            } else {
                                qry.setArgs(new Object[]{key});
                            }
                            res = new ArrayList();
                            for (Cache.Entry e : cache.cache.query((Query)qry).getAll()) {
                                ArrayList<Object> row = new ArrayList<Object>(2);
                                row.add(e.getKey());
                                row.add(((MvccTestSqlIndexValue)e.getValue()).idxVal1);
                                res.add(row);
                            }
                        }
                    }
                    finally {
                        cache.readUnlock();
                    }
                    CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)(qryIdx == 0 || !res.isEmpty()));
                    if (res.isEmpty()) continue;
                    CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)res.size());
                    List resVals = (List)res.get(0);
                    Integer key0 = (Integer)resVals.get(0);
                    Integer val0 = (Integer)resVals.get(1);
                    CacheMvccSqlQueriesAbstractTest.assertEquals((Object)key, (Object)key0);
                    CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)(val0.equals(key) || val0.equals(key + 110)));
                }
                if (idx == 0) {
                    List res;
                    SqlFieldsQuery qry = new SqlFieldsQuery("select _key, idxVal1 from MvccTestSqlIndexValue");
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        res = cache.cache.query(qry).getAll();
                    }
                    finally {
                        cache.readUnlock();
                    }
                    CacheMvccSqlQueriesAbstractTest.assertEquals((int)100, (int)res.size());
                    for (List vals : res) {
                        CacheMvccSqlQueriesAbstractTest.this.info("Value: " + vals);
                    }
                }
            }
        };
        if (singleNode) {
            srvs = 1;
            clients = 0;
        } else {
            srvs = 4;
            clients = 2;
        }
        this.readWriteTest(null, srvs, clients, 0, 1024, 4, 4, DFLT_TEST_TIME, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, MvccTestSqlIndexValue.class}), (IgniteInClosure)init, (GridInClosure3)writer, (GridInClosure3)reader);
        for (Ignite node : G.allGrids()) {
            this.checkActiveQueriesCleanup(node);
        }
    }

    @Test
    public void testJoinTransactional_SingleNode() throws Exception {
        this.joinTransactional(true, false);
    }

    @Test
    public void testJoinTransactional_ClientServer() throws Exception {
        this.joinTransactional(false, false);
    }

    @Test
    public void testJoinTransactional_DistributedJoins_ClientServer() throws Exception {
        this.joinTransactional(false, true);
    }

    private void joinTransactional(boolean singleNode, final boolean distributedJoin) throws Exception {
        int clients;
        int srvs;
        int KEYS = 100;
        int writers = 4;
        int readers = 4;
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> writer = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int cnt = 0;
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    IgniteTransactions txs = ((Ignite)cache.cache.unwrap(Ignite.class)).transactions();
                    try {
                        while (true) {
                            try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                                Integer key = rnd.nextInt(100);
                                JoinTestChildKey childKey = new JoinTestChildKey(key);
                                JoinTestChild child = (JoinTestChild)cache.cache.get((Object)childKey);
                                if (child == null) {
                                    int parentKey = distributedJoin ? key + 100 : key;
                                    child = new JoinTestChild(parentKey);
                                    cache.cache.put((Object)childKey, (Object)child);
                                    JoinTestParent parent = new JoinTestParent(parentKey);
                                    cache.cache.put((Object)new JoinTestParentKey(parentKey), (Object)parent);
                                } else {
                                    cache.cache.remove((Object)childKey);
                                    cache.cache.remove((Object)new JoinTestParentKey(child.parentId));
                                }
                                tx.commit();
                            }
                            catch (CacheException e) {
                                MvccFeatureChecker.assertMvccWriteConflict((Exception)((Object)e));
                                continue;
                            }
                            break;
                        }
                        ++cnt;
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                CacheMvccSqlQueriesAbstractTest.this.info("Writer finished, updates: " + cnt);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> reader = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                CacheMvccAbstractTest.TestCache cache;
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                ArrayList<SqlFieldsQuery> qrys = new ArrayList<SqlFieldsQuery>();
                qrys.add(new SqlFieldsQuery("select c.parentId, p.id from JoinTestChild c left outer join JoinTestParent p on (c.parentId = p.id)").setDistributedJoins(distributedJoin));
                qrys.add(new SqlFieldsQuery("select c.parentId, p.id from JoinTestChild c left outer join JoinTestParent p on (c.parentId = p.id) where p.id = 10").setDistributedJoins(distributedJoin));
                qrys.add(new SqlFieldsQuery("select c.parentId, p.id from JoinTestChild c left outer join JoinTestParent p on (c.parentId = p.id) where p.id != 10").setDistributedJoins(distributedJoin));
                while (!stop.get()) {
                    cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        for (SqlFieldsQuery qry : qrys) {
                            List res = cache.cache.query(qry).getAll();
                            if (res.isEmpty()) continue;
                            for (List resRow : res) {
                                Integer parentId = (Integer)resRow.get(1);
                                CacheMvccSqlQueriesAbstractTest.assertNotNull((Object)parentId);
                            }
                        }
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                if (idx == 0) {
                    cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        List res = cache.cache.query((SqlFieldsQuery)qrys.get(0)).getAll();
                        CacheMvccSqlQueriesAbstractTest.this.info("Reader finished, result: " + res);
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
            }
        };
        if (singleNode) {
            srvs = 1;
            clients = 0;
        } else {
            srvs = 4;
            clients = 2;
        }
        this.readWriteTest(null, srvs, clients, 0, 1024, 4, 4, DFLT_TEST_TIME, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{JoinTestParentKey.class, JoinTestParent.class, JoinTestChildKey.class, JoinTestChild.class}), null, (GridInClosure3)writer, (GridInClosure3)reader);
    }

    @Test
    public void testJoinTransactional_DistributedJoins_ClientServer2() throws Exception {
        int KEYS = 100;
        boolean writers = true;
        int readers = 4;
        int CHILDREN_CNT = 10;
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> writer = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int cnt = 0;
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    IgniteTransactions txs = ((Ignite)cache.cache.unwrap(Ignite.class)).transactions();
                    try {
                        try (Transaction tx = txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            int i;
                            Integer key = rnd.nextInt(100);
                            JoinTestParentKey parentKey = new JoinTestParentKey(key);
                            JoinTestParent parent = (JoinTestParent)cache.cache.get((Object)parentKey);
                            if (parent == null) {
                                for (i = 0; i < 10; ++i) {
                                    cache.cache.put((Object)new JoinTestChildKey(key * 10000 + i), (Object)new JoinTestChild(key));
                                }
                                cache.cache.put((Object)parentKey, (Object)new JoinTestParent(key));
                            } else {
                                for (i = 0; i < 10; ++i) {
                                    cache.cache.remove((Object)new JoinTestChildKey(key * 10000 + i));
                                }
                                cache.cache.remove((Object)parentKey);
                            }
                            tx.commit();
                        }
                        ++cnt;
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                CacheMvccSqlQueriesAbstractTest.this.info("Writer finished, updates: " + cnt);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> reader = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                SqlFieldsQuery qry = new SqlFieldsQuery("select c.parentId, p.id from JoinTestChild c left outer join JoinTestParent p on (c.parentId = p.id) where p.id=?").setDistributedJoins(true);
                int cnt = 0;
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    qry.setArgs(new Object[]{rnd.nextInt(100)});
                    try {
                        List res = cache.cache.query(qry).getAll();
                        if (!res.isEmpty()) {
                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)10, (int)res.size());
                        }
                        ++cnt;
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                CacheMvccSqlQueriesAbstractTest.this.info("Reader finished, read count: " + cnt);
            }
        };
        this.readWriteTest(null, 4, 2, 0, 1024, 1, 4, DFLT_TEST_TIME, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{JoinTestParentKey.class, JoinTestParent.class, JoinTestChildKey.class, JoinTestChild.class}), null, (GridInClosure3)writer, (GridInClosure3)reader);
    }

    @Test
    public void testDistributedJoinSimple() throws Exception {
        int[] backups;
        this.startGridsMultiThreaded(4);
        IgniteEx srv0 = this.ignite(0);
        for (int b : backups = new int[]{0, 1, 2}) {
            IgniteCache cache = srv0.createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, b, 1024).setIndexedTypes(new Class[]{JoinTestParentKey.class, JoinTestParent.class, JoinTestChildKey.class, JoinTestChild.class}));
            int cntr = 0;
            int expCnt = 0;
            for (int i = 0; i < 10; ++i) {
                JoinTestParentKey parentKey = new JoinTestParentKey(i);
                cache.put((Object)parentKey, (Object)new JoinTestParent(i));
                for (int c = 0; c < i; ++c) {
                    JoinTestChildKey childKey = new JoinTestChildKey(cntr++);
                    cache.put((Object)childKey, (Object)new JoinTestChild(i));
                    ++expCnt;
                }
            }
            SqlFieldsQuery qry = new SqlFieldsQuery("select c.parentId, p.id from JoinTestChild c join JoinTestParent p on (c.parentId = p.id)").setDistributedJoins(true);
            HashMap<Integer, Integer> resMap = new HashMap<Integer, Integer>();
            List res = cache.query(qry).getAll();
            CacheMvccSqlQueriesAbstractTest.assertEquals((int)expCnt, (int)res.size());
            for (List resRow : res) {
                Integer parentId = (Integer)resRow.get(0);
                Integer cnt = (Integer)resMap.get(parentId);
                if (cnt == null) {
                    resMap.put(parentId, 1);
                    continue;
                }
                resMap.put(parentId, cnt + 1);
            }
            for (int i = 1; i < 10; ++i) {
                CacheMvccSqlQueriesAbstractTest.assertEquals((Object)i, resMap.get(i));
            }
            srv0.destroyCache(cache.getName());
        }
    }

    @Test
    public void testCacheRecreate() throws Exception {
        this.cacheRecreate((IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class}));
    }

    @Test
    public void testCacheRecreateChangeIndexedType() throws Exception {
        int v;
        int vals;
        int k;
        IgniteEx srv0 = this.startGrid(0);
        int PARTS = 64;
        CacheConfiguration ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 64).setIndexedTypes(new Class[]{Integer.class, CacheMvccAbstractTest.MvccTestAccount.class});
        IgniteCache cache = srv0.createCache(ccfg);
        for (k = 0; k < 128; ++k) {
            CacheMvccSqlQueriesAbstractTest.assertNull((Object)cache.get((Object)k));
            vals = k % 3 + 1;
            for (v = 0; v < vals; ++v) {
                cache.put((Object)k, (Object)new CacheMvccAbstractTest.MvccTestAccount(v, 1));
            }
            CacheMvccSqlQueriesAbstractTest.assertEquals((int)(vals - 1), (int)((CacheMvccAbstractTest.MvccTestAccount)cache.get((Object)Integer.valueOf((int)k))).val);
        }
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)128, (int)cache.query((Query)new SqlQuery(CacheMvccAbstractTest.MvccTestAccount.class, "true")).getAll().size());
        srv0.destroyCache(cache.getName());
        ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 64).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class});
        cache = srv0.createCache(ccfg);
        for (k = 0; k < 128; ++k) {
            CacheMvccSqlQueriesAbstractTest.assertNull((Object)cache.get((Object)k));
            vals = k % 3 + 1;
            for (v = 0; v < vals; ++v) {
                cache.put((Object)k, (Object)new MvccTestSqlIndexValue(v));
            }
            CacheMvccSqlQueriesAbstractTest.assertEquals((int)(vals - 1), (int)((MvccTestSqlIndexValue)cache.get((Object)k)).idxVal1);
        }
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)128, (int)cache.query((Query)new SqlQuery(MvccTestSqlIndexValue.class, "true")).getAll().size());
        srv0.destroyCache(cache.getName());
        ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 64).setIndexedTypes(new Class[]{Long.class, Long.class});
        cache = srv0.createCache(ccfg);
        for (k = 0; k < 128; ++k) {
            CacheMvccSqlQueriesAbstractTest.assertNull((Object)cache.get((Object)k));
            vals = k % 3 + 1;
            for (v = 0; v < vals; ++v) {
                cache.put((Object)k, (Object)v);
            }
            CacheMvccSqlQueriesAbstractTest.assertEquals((Object)(vals - 1), (Object)cache.get((Object)k));
        }
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)128, (int)cache.query((Query)new SqlQuery(Long.class, "true")).getAll().size());
        srv0.destroyCache(cache.getName());
    }

    @Test
    public void testChangeValueType1() throws Exception {
        IgniteEx srv0 = this.startGrid(0);
        CacheConfiguration ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class, Integer.class, Integer.class});
        IgniteCache cache = srv0.createCache(ccfg);
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(1));
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(2));
        this.checkSingleResult(cache, new SqlFieldsQuery("select idxVal1 from MvccTestSqlIndexValue"), 2);
        cache.put((Object)1, (Object)1);
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)0, (int)cache.query(new SqlFieldsQuery("select idxVal1 from MvccTestSqlIndexValue")).getAll().size());
        this.checkSingleResult(cache, new SqlFieldsQuery("select _val from Integer"), 1);
        cache.put((Object)1, (Object)2);
        this.checkSingleResult(cache, new SqlFieldsQuery("select _val from Integer"), 2);
    }

    @Test
    public void testChangeValueType2() throws Exception {
        IgniteEx srv0 = this.startGrid(0);
        CacheConfiguration ccfg = this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class, Integer.class, Integer.class});
        IgniteCache cache = srv0.createCache(ccfg);
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(1));
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(2));
        this.checkSingleResult(cache, new SqlFieldsQuery("select idxVal1 from MvccTestSqlIndexValue"), 2);
        cache.remove((Object)1);
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)0, (int)cache.query(new SqlFieldsQuery("select idxVal1 from MvccTestSqlIndexValue")).getAll().size());
        cache.put((Object)1, (Object)1);
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)0, (int)cache.query(new SqlFieldsQuery("select idxVal1 from MvccTestSqlIndexValue")).getAll().size());
        this.checkSingleResult(cache, new SqlFieldsQuery("select _val from Integer"), 1);
        cache.put((Object)1, (Object)2);
        this.checkSingleResult(cache, new SqlFieldsQuery("select _val from Integer"), 2);
    }

    @Test
    public void testCountTransactional_SingleNode() throws Exception {
        this.countTransactional(true);
    }

    @Test
    public void testCountTransactional_ClientServer() throws Exception {
        this.countTransactional(false);
    }

    private void countTransactional(boolean singleNode) throws Exception {
        int clients;
        int srvs;
        int writers = 4;
        int readers = 4;
        int THREAD_KEY_RANGE = 100;
        int VAL_RANGE = 10;
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> writer = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int min = idx * 100;
                int max = min + 100;
                CacheMvccSqlQueriesAbstractTest.this.info("Thread range [min=" + min + ", max=" + max + ']');
                int cnt = 0;
                LinkedHashSet<Integer> keys = new LinkedHashSet<Integer>();
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        if (!(keys.isEmpty() || keys.size() != 100 && rnd.nextInt(3) != 0)) {
                            HashSet<Integer> rmvKeys = new HashSet<Integer>();
                            for (Integer key : keys) {
                                rmvKeys.add(key);
                                if (rmvKeys.size() != 10) continue;
                                break;
                            }
                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)10, (int)rmvKeys.size());
                            cache.cache.removeAll(rmvKeys);
                            keys.removeAll(rmvKeys);
                            continue;
                        }
                        TreeMap<Integer, MvccTestSqlIndexValue> map = new TreeMap<Integer, MvccTestSqlIndexValue>();
                        while (map.size() != 10) {
                            Integer key = rnd.nextInt(min, max);
                            if (!keys.add(key)) continue;
                            map.put(key, new MvccTestSqlIndexValue(rnd.nextInt(10)));
                        }
                        CacheMvccSqlQueriesAbstractTest.assertEquals((int)10, (int)map.size());
                        cache.cache.putAll(map);
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                CacheMvccSqlQueriesAbstractTest.this.info("Writer finished, updates: " + cnt);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> reader = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                ArrayList<SqlFieldsQuery> qrys = new ArrayList<SqlFieldsQuery>();
                qrys.add(new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue"));
                qrys.add(new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 >= 0 and idxVal1 <= 10"));
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        for (SqlFieldsQuery qry : qrys) {
                            List res = cache.cache.query(qry).getAll();
                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)res.size());
                            Long cnt = (Long)((List)res.get(0)).get(0);
                            CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)(cnt % 10L == 0L));
                        }
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
            }
        };
        if (singleNode) {
            srvs = 1;
            clients = 0;
        } else {
            srvs = 4;
            clients = 2;
        }
        this.readWriteTest(null, srvs, clients, 0, 1024, 4, 4, DFLT_TEST_TIME, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, MvccTestSqlIndexValue.class}), null, (GridInClosure3)writer, (GridInClosure3)reader);
    }

    @Test
    public void testMaxMinTransactional_SingleNode() throws Exception {
        this.maxMinTransactional(true);
    }

    @Test
    public void testMaxMinTransactional_ClientServer() throws Exception {
        this.maxMinTransactional(false);
    }

    private void maxMinTransactional(boolean singleNode) throws Exception {
        int clients;
        int srvs;
        boolean writers = true;
        boolean readers = true;
        int THREAD_OPS = 10;
        int OP_RANGE = 10;
        int THREAD_KEY_RANGE = 100;
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> writer = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                int min = idx * 100;
                CacheMvccSqlQueriesAbstractTest.this.info("Thread range [start=" + min + ']');
                int cnt = 0;
                boolean add = true;
                int op = 0;
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        int i;
                        int startKey = min + op * 10;
                        if (add) {
                            HashMap<Integer, MvccTestSqlIndexValue> vals = new HashMap<Integer, MvccTestSqlIndexValue>();
                            for (i = 0; i < 10; ++i) {
                                Integer key = startKey + i + 1;
                                vals.put(key, new MvccTestSqlIndexValue(key));
                            }
                            cache.cache.putAll(vals);
                        } else {
                            HashSet<Integer> rmvKeys = new HashSet<Integer>();
                            for (i = 0; i < 10; ++i) {
                                rmvKeys.add(startKey + i + 1);
                            }
                            cache.cache.removeAll(rmvKeys);
                        }
                        if (++op != 10) continue;
                        add = !add;
                        op = 0;
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
                CacheMvccSqlQueriesAbstractTest.this.info("Writer finished, updates: " + cnt);
            }
        };
        GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean> reader = new GridInClosure3<Integer, List<CacheMvccAbstractTest.TestCache>, AtomicBoolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply(Integer idx, List<CacheMvccAbstractTest.TestCache> caches, AtomicBoolean stop) {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                ArrayList<SqlFieldsQuery> maxQrys = new ArrayList<SqlFieldsQuery>();
                ArrayList<SqlFieldsQuery> minQrys = new ArrayList<SqlFieldsQuery>();
                maxQrys.add(new SqlFieldsQuery("select max(idxVal1) from MvccTestSqlIndexValue"));
                maxQrys.add(new SqlFieldsQuery("select max(idxVal1) from MvccTestSqlIndexValue where idxVal1 >= 0"));
                minQrys.add(new SqlFieldsQuery("select min(idxVal1) from MvccTestSqlIndexValue"));
                minQrys.add(new SqlFieldsQuery("select min(idxVal1) from MvccTestSqlIndexValue where idxVal1 >= 0"));
                while (!stop.get()) {
                    CacheMvccAbstractTest.TestCache cache = CacheMvccAbstractTest.randomCache(caches, (ThreadLocalRandom)rnd);
                    try {
                        Integer m;
                        List res;
                        for (SqlFieldsQuery qry : maxQrys) {
                            res = cache.cache.query(qry).getAll();
                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)res.size());
                            m = (Integer)((List)res.get(0)).get(0);
                            CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)(m == null || m % 10 == 0));
                        }
                        for (SqlFieldsQuery qry : minQrys) {
                            res = cache.cache.query(qry).getAll();
                            CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)res.size());
                            m = (Integer)((List)res.get(0)).get(0);
                            CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)(m == null || m % 10 == 1));
                        }
                    }
                    finally {
                        cache.readUnlock();
                    }
                }
            }
        };
        if (singleNode) {
            srvs = 1;
            clients = 0;
        } else {
            srvs = 4;
            clients = 2;
        }
        this.readWriteTest(null, srvs, clients, 0, 1024, 1, 1, DFLT_TEST_TIME, (IgniteInClosure)new CacheMvccAbstractTest.InitIndexing(new Class[]{Integer.class, MvccTestSqlIndexValue.class}), null, (GridInClosure3)writer, (GridInClosure3)reader);
    }

    @Test
    public void testSqlQueriesWithMvcc() throws Exception {
        IgniteEx srv0 = this.startGrid(0);
        IgniteCache cache = srv0.createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class}));
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)i, (Object)new MvccTestSqlIndexValue(i));
        }
        this.sqlQueriesWithMvcc((IgniteCache<Integer, MvccTestSqlIndexValue>)cache, true);
        this.sqlQueriesWithMvcc((IgniteCache<Integer, MvccTestSqlIndexValue>)cache, false);
    }

    private void sqlQueriesWithMvcc(IgniteCache<Integer, MvccTestSqlIndexValue> cache, boolean loc) {
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)10, (int)cache.query((Query)new SqlQuery(MvccTestSqlIndexValue.class, "true").setLocal(loc)).getAll().size());
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)10, (int)cache.query(new SqlFieldsQuery("select idxVal1 from MvccTestSqlIndexValue").setLocal(loc)).getAll().size());
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)10, (int)cache.query(new SqlFieldsQuery("select (select count (*) from MvccTestSqlIndexValue where idxVal1 = t1.idxVal1) as c1, (select 0 from dual) as c2 from MvccTestSqlIndexValue as t1 join (select * from MvccTestSqlIndexValue) as t2 on t1.idxVal1 = t2.idxVal1").setLocal(loc)).getAll().size());
        this.checkSingleResult(cache, new SqlFieldsQuery("select max(idxVal1) from MvccTestSqlIndexValue").setLocal(loc), 9);
        this.checkSingleResult(cache, new SqlFieldsQuery("select max(idxVal1) from MvccTestSqlIndexValue where idxVal1 > 0").setLocal(loc), 9);
        this.checkSingleResult(cache, new SqlFieldsQuery("select max(idxVal1) from MvccTestSqlIndexValue where idxVal1 < 5").setLocal(loc), 4);
        this.checkSingleResult(cache, new SqlFieldsQuery("select min(idxVal1) from MvccTestSqlIndexValue").setLocal(loc), 0);
        this.checkSingleResult(cache, new SqlFieldsQuery("select min(idxVal1) from MvccTestSqlIndexValue where idxVal1 < 100").setLocal(loc), 0);
        this.checkSingleResult(cache, new SqlFieldsQuery("select min(idxVal1) from MvccTestSqlIndexValue where idxVal1 < 5").setLocal(loc), 0);
        this.checkSingleResult(cache, new SqlFieldsQuery("select min(idxVal1) from MvccTestSqlIndexValue where idxVal1 > 5").setLocal(loc), 6);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue").setLocal(loc), 10L);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 >= 0").setLocal(loc), 10L);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 >= 0 and idxVal1 < 100").setLocal(loc), 10L);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 >0 and idxVal1 < 5").setLocal(loc), 4L);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 >= 1").setLocal(loc), 9L);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 > 100").setLocal(loc), 0L);
        this.checkSingleResult(cache, new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue where idxVal1 = 1").setLocal(loc), 1L);
    }

    private void checkSingleResult(IgniteCache cache, SqlFieldsQuery qry, Object exp) {
        List res = cache.query(qry).getAll();
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)res.size());
        List row = (List)res.get(0);
        CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)row.size());
        CacheMvccSqlQueriesAbstractTest.assertEquals((Object)exp, row.get(0));
    }

    @Test
    public void testSqlSimple() throws Exception {
        this.startGrid(0);
        for (int i = 0; i < 4; ++i) {
            this.sqlSimple(i * 512);
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = 0; i < 5; ++i) {
            this.sqlSimple(rnd.nextInt(2048));
        }
    }

    private void sqlSimple(int inlineSize) throws Exception {
        IgniteEx srv0 = this.ignite(0);
        IgniteCache cache = srv0.createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class}).setSqlIndexMaxInlineSize(inlineSize));
        HashMap<Integer, Integer> expVals = new HashMap<Integer, Integer>();
        this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(1));
        expVals.put(1, 1);
        this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(2));
        expVals.put(1, 2);
        this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
        cache.put((Object)2, (Object)new MvccTestSqlIndexValue(1));
        expVals.put(2, 1);
        cache.put((Object)3, (Object)new MvccTestSqlIndexValue(1));
        expVals.put(3, 1);
        cache.put((Object)4, (Object)new MvccTestSqlIndexValue(1));
        expVals.put(4, 1);
        this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
        cache.remove((Object)1);
        expVals.remove(1);
        this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
        this.checkNoValue(1, cache);
        cache.put((Object)1, (Object)new MvccTestSqlIndexValue(10));
        expVals.put(1, 10);
        this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
        this.checkActiveQueriesCleanup((Ignite)srv0);
        srv0.destroyCache(cache.getName());
    }

    @Test
    public void testSqlSimplePutRemoveRandom() throws Exception {
        this.startGrid(0);
        this.testSqlSimplePutRemoveRandom(0);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = 0; i < 3; ++i) {
            this.testSqlSimplePutRemoveRandom(rnd.nextInt(2048));
        }
    }

    private void testSqlSimplePutRemoveRandom(int inlineSize) throws Exception {
        int i;
        IgniteEx srv0 = this.grid(0);
        IgniteCache cache = srv0.createCache(this.cacheConfiguration(this.cacheMode(), CacheWriteSynchronizationMode.FULL_SYNC, 0, 1024).setIndexedTypes(new Class[]{Integer.class, MvccTestSqlIndexValue.class}).setSqlIndexMaxInlineSize(inlineSize));
        HashMap<Integer, Integer> expVals = new HashMap<Integer, Integer>();
        int KEYS = 100;
        int VALS = 10;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long stopTime = System.currentTimeMillis() + 5000L;
        for (i = 0; i < 100000; ++i) {
            Integer key = rnd.nextInt(100);
            if (rnd.nextInt(5) == 0) {
                cache.remove((Object)key);
                expVals.remove(key);
            } else {
                Integer val = rnd.nextInt(10);
                cache.put((Object)key, (Object)new MvccTestSqlIndexValue(val));
                expVals.put(key, val);
            }
            this.checkValues(expVals, (IgniteCache<Integer, MvccTestSqlIndexValue>)cache);
            if (System.currentTimeMillis() <= stopTime) continue;
            this.info("Stop test, iteration: " + i);
            break;
        }
        for (i = 0; i < 100; ++i) {
            if (expVals.containsKey(i)) continue;
            this.checkNoValue(i, cache);
        }
        this.checkActiveQueriesCleanup((Ignite)srv0);
        srv0.destroyCache(cache.getName());
    }

    private void checkNoValue(Object key, IgniteCache cache) {
        SqlQuery qry = new SqlQuery(MvccTestSqlIndexValue.class, "_key = ?");
        qry.setArgs(new Object[]{key});
        List res = cache.query((Query)qry).getAll();
        CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)res.isEmpty());
    }

    private void checkValues(Map<Integer, Integer> expVals, IgniteCache<Integer, MvccTestSqlIndexValue> cache) {
        SqlFieldsQuery cntQry = new SqlFieldsQuery("select count(*) from MvccTestSqlIndexValue");
        Long cnt = (Long)((List)cache.query(cntQry).getAll().get(0)).get(0);
        CacheMvccSqlQueriesAbstractTest.assertEquals((Object)expVals.size(), (Object)cnt);
        SqlQuery qry = new SqlQuery(MvccTestSqlIndexValue.class, "true");
        HashMap<Object, Integer> vals = new HashMap<Object, Integer>();
        for (Cache.Entry e : cache.query((Query)qry).getAll()) {
            CacheMvccSqlQueriesAbstractTest.assertNull((Object)vals.put(e.getKey(), ((MvccTestSqlIndexValue)e.getValue()).idxVal1));
        }
        CacheMvccSqlQueriesAbstractTest.assertEquals(expVals, vals);
        qry = new SqlQuery(MvccTestSqlIndexValue.class, "_key >= 0");
        vals = new HashMap();
        for (Cache.Entry e : cache.query((Query)qry).getAll()) {
            CacheMvccSqlQueriesAbstractTest.assertNull((Object)vals.put(e.getKey(), ((MvccTestSqlIndexValue)e.getValue()).idxVal1));
        }
        CacheMvccSqlQueriesAbstractTest.assertEquals(expVals, vals);
        qry = new SqlQuery(MvccTestSqlIndexValue.class, "idxVal1 >= 0");
        vals = new HashMap();
        for (Cache.Entry e : cache.query((Query)qry).getAll()) {
            CacheMvccSqlQueriesAbstractTest.assertNull((Object)vals.put(e.getKey(), ((MvccTestSqlIndexValue)e.getValue()).idxVal1));
        }
        CacheMvccSqlQueriesAbstractTest.assertEquals(expVals, vals);
        HashMap<Integer, HashSet<Integer>> expIdxVals = new HashMap<Integer, HashSet<Integer>>();
        for (Map.Entry<Integer, Integer> entry : expVals.entrySet()) {
            qry = new SqlQuery(MvccTestSqlIndexValue.class, "_key = ?");
            qry.setArgs(new Object[]{entry.getKey()});
            List res = cache.query((Query)qry).getAll();
            CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)res.size());
            CacheMvccSqlQueriesAbstractTest.assertEquals((Object)entry.getKey(), (Object)((Cache.Entry)res.get(0)).getKey());
            CacheMvccSqlQueriesAbstractTest.assertEquals((Object)entry.getValue(), (Object)((MvccTestSqlIndexValue)((Cache.Entry)res.get(0)).getValue()).idxVal1);
            SqlFieldsQuery fieldsQry = new SqlFieldsQuery("select _key, idxVal1 from MvccTestSqlIndexValue where _key=?");
            fieldsQry.setArgs(new Object[]{entry.getKey()});
            List fieldsRes = cache.query(fieldsQry).getAll();
            CacheMvccSqlQueriesAbstractTest.assertEquals((int)1, (int)fieldsRes.size());
            CacheMvccSqlQueriesAbstractTest.assertEquals((Object)entry.getKey(), ((List)fieldsRes.get(0)).get(0));
            CacheMvccSqlQueriesAbstractTest.assertEquals((Object)entry.getValue(), ((List)fieldsRes.get(0)).get(1));
            Integer val = entry.getValue();
            HashSet<Integer> keys = (HashSet<Integer>)expIdxVals.get(val);
            if (keys == null) {
                keys = new HashSet<Integer>();
                expIdxVals.put(val, keys);
            }
            CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)keys.add(entry.getKey()));
        }
        for (Map.Entry<Integer, Integer> entry : expIdxVals.entrySet()) {
            qry = new SqlQuery(MvccTestSqlIndexValue.class, "idxVal1 = ?");
            qry.setArgs(new Object[]{entry.getKey()});
            vals = new HashMap();
            for (Cache.Entry e : cache.query((Query)qry).getAll()) {
                CacheMvccSqlQueriesAbstractTest.assertNull((Object)vals.put(e.getKey(), ((MvccTestSqlIndexValue)e.getValue()).idxVal1));
                CacheMvccSqlQueriesAbstractTest.assertEquals((Object)entry.getKey(), (Object)((MvccTestSqlIndexValue)e.getValue()).idxVal1);
                CacheMvccSqlQueriesAbstractTest.assertTrue((boolean)((Set)((Object)entry.getValue())).contains(e.getKey()));
            }
            CacheMvccSqlQueriesAbstractTest.assertEquals((int)((Set)((Object)entry.getValue())).size(), (int)vals.size());
        }
    }

    static class MvccTestSqlIndexValue
    implements Serializable {
        @QuerySqlField(index=true)
        private int idxVal1;

        MvccTestSqlIndexValue(int idxVal1) {
            this.idxVal1 = idxVal1;
        }

        public String toString() {
            return S.toString(MvccTestSqlIndexValue.class, (Object)this);
        }
    }

    static class JoinTestChild {
        @QuerySqlField(index=true)
        private int parentId;

        JoinTestChild(int parentId) {
            this.parentId = parentId;
        }

        public String toString() {
            return S.toString(JoinTestChild.class, (Object)this);
        }
    }

    static class JoinTestChildKey
    implements Serializable {
        @QuerySqlField(index=true)
        private int key;

        JoinTestChildKey(int key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinTestChildKey that = (JoinTestChildKey)o;
            return this.key == that.key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    static class JoinTestParent {
        @QuerySqlField(index=true)
        private int id;

        JoinTestParent(int id) {
            this.id = id;
        }

        public String toString() {
            return S.toString(JoinTestParent.class, (Object)this);
        }
    }

    static class JoinTestParentKey
    implements Serializable {
        private int key;

        JoinTestParentKey(int key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinTestParentKey that = (JoinTestParentKey)o;
            return this.key == that.key;
        }

        public int hashCode() {
            return this.key;
        }
    }
}

