/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class LongIndexNameTest
extends AbstractIndexingCommonTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration()).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("cache").setQueryEntities(LongIndexNameTest.getIndexCfg()).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 16))});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.cleanPersistenceDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongIndexNames() throws Exception {
        try {
            IgniteEx ignite = this.startGrid(0);
            IgniteCache cache = this.insertSomeData((Ignite)ignite);
            FieldsQueryCursor cursor1 = cache.query(new SqlFieldsQuery("SELECT * FROM Person where name like '%Name 0'"));
            FieldsQueryCursor cursor1Idx = cache.query(new SqlFieldsQuery("SELECT * FROM Person where name = 'Name 0'"));
            FieldsQueryCursor cursor2 = cache.query(new SqlFieldsQuery("SELECT * FROM Person where age like '%0'"));
            FieldsQueryCursor cursor2Idx = cache.query(new SqlFieldsQuery("SELECT * FROM Person where age = 0"));
            LongIndexNameTest.assertEquals((int)cursor1.getAll().size(), (int)cursor1Idx.getAll().size());
            LongIndexNameTest.assertEquals((int)cursor2.getAll().size(), (int)cursor2Idx.getAll().size());
            ignite.close();
            Thread.sleep(2000L);
            ignite = this.startGrid(0);
            cache = this.insertSomeData((Ignite)ignite);
            cursor1 = cache.query(new SqlFieldsQuery("SELECT * FROM Person where name like '%Name 0'"));
            cursor1Idx = cache.query(new SqlFieldsQuery("SELECT * FROM Person where name = 'Name 0'"));
            cursor2 = cache.query(new SqlFieldsQuery("SELECT * FROM Person where age like '%0'"));
            cursor2Idx = cache.query(new SqlFieldsQuery("SELECT * FROM Person where age = 0"));
            LongIndexNameTest.assertEquals((int)cursor1.getAll().size(), (int)cursor1Idx.getAll().size());
            LongIndexNameTest.assertEquals((int)cursor2.getAll().size(), (int)cursor2Idx.getAll().size());
        }
        finally {
            this.stopAllGrids();
        }
    }

    @NotNull
    private IgniteCache insertSomeData(Ignite ignite) {
        if (!ignite.active()) {
            ignite.active(true);
        }
        IgniteCache cache = ignite.cache("cache");
        for (int i = 0; i < 10; ++i) {
            cache.put((Object)String.valueOf(System.currentTimeMillis()), (Object)new Person("Name " + i, i));
        }
        return cache;
    }

    public static List<QueryEntity> getIndexCfg() {
        ArrayList<QueryEntity> entities = new ArrayList<QueryEntity>();
        QueryEntity qe = new QueryEntity(String.class.getName(), Person.class.getName());
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>();
        fieldsMap.put("name", String.class.getName());
        fieldsMap.put("age", Integer.class.getName());
        qe.setFields(fieldsMap);
        ArrayList<QueryIndex> indices = new ArrayList<QueryIndex>();
        QueryIndex index = new QueryIndex("name", true, "LONG_NAME_12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
        QueryIndex index2 = new QueryIndex("age", true, "AGE_IDX");
        indices.add(index);
        indices.add(index2);
        qe.setIndexes(indices);
        entities.add(qe);
        return entities;
    }

    private static class Person {
        private String name;
        private int age;

        public Person() {
        }

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }
}

