/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.junit.Test;

public class IndexColumnTypeMismatchTest
extends AbstractIndexingCommonTest {
    private static final String LOG_MSG = "Provided value can't be used as index search bound due to column data type mismatch";
    private final ListeningTestLogger listeningLog = new ListeningTestLogger(log);
    private static final int ROW_COUNT = 100;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setGridLogger((IgniteLogger)this.listeningLog);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testIndexColTypeMismatch() throws Exception {
        LogListener lsnr = LogListener.matches((String)LOG_MSG).times(1).build();
        this.listeningLog.registerListener(lsnr);
        IgniteEx ignite = this.startGrid(0);
        this.checkIndexQuery(ignite, "VARCHAR", String::valueOf, i -> i);
        IndexColumnTypeMismatchTest.assertTrue((boolean)lsnr.check());
    }

    @Test
    public void testIndexDifferentTypesComparable() throws Exception {
        LogListener lsnr = LogListener.matches((String)LOG_MSG).times(0).build();
        this.listeningLog.registerListener(lsnr);
        IgniteEx ignite = this.startGrid(0);
        this.checkIndexQuery(ignite, "INT", i -> i, i -> (long)i);
        this.checkIndexQuery(ignite, "BIGINT", i -> (long)i, i -> i);
        this.checkIndexQuery(ignite, "DATE", i -> new Date(this.millis(i)), i -> new Timestamp(this.millis(i)));
        this.checkIndexQuery(ignite, "TIMESTAMP", i -> new Timestamp(this.millis(i)), i -> new Date(this.millis(i)));
        this.checkIndexQuery(ignite, "INT", i -> i, String::valueOf);
        IndexColumnTypeMismatchTest.assertTrue((boolean)lsnr.check());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndexQuery(IgniteEx ignite, String indexedType, IntFunction<Object> indexedValFactory, IntFunction<Object> searchRowFactory) {
        try {
            int i;
            this.sql(ignite, "CREATE TABLE test (id INTEGER, val " + indexedType + ", PRIMARY KEY (id)) WITH \"CACHE_NAME=test\"", new Object[0]);
            this.sql(ignite, "CREATE INDEX test_idx ON test (val)", new Object[0]);
            for (i = 0; i < 100; ++i) {
                this.sql(ignite, "INSERT INTO test VALUES (?, ?)", i, indexedValFactory.apply(i));
            }
            for (i = 0; i < 100; ++i) {
                List<List<?>> res = this.sql(ignite, "SELECT val FROM test WHERE val = ?", searchRowFactory.apply(i));
                IndexColumnTypeMismatchTest.assertEquals((int)1, (int)res.size());
                IndexColumnTypeMismatchTest.assertEquals((Object)indexedValFactory.apply(i), res.get(0).get(0));
            }
            List<List<?>> res = this.sql(ignite, "SELECT val FROM test WHERE val < ?", searchRowFactory.apply(50));
            IndexColumnTypeMismatchTest.assertEquals((int)50, (int)res.size());
        }
        finally {
            this.sql(ignite, "DROP TABLE test", new Object[0]);
        }
    }

    private long millis(int day) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2022, 0, 1);
        cal.add(5, day);
        return cal.getTimeInMillis();
    }

    private List<List<?>> sql(IgniteEx ign, String sql, Object ... args) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false).getAll();
    }
}

