/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class H2RowExpireTimeIndexSelfTest
extends GridCommonAbstractTest {
    private static final long EXPIRE_IN_MS_FROM_CREATE = 100L;
    private static final long WAIT_MS_TIL_EXPIRED = 200L;

    protected void beforeTestsStarted() throws Exception {
        this.cleanPersistenceDir();
        this.startGrids(1);
    }

    protected void afterTestsStopped() throws Exception {
        G.stopAll((boolean)true);
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    @Before
    public void dropTestCache() {
        this.grid(0).destroyCache("notEager");
    }

    private IgniteCache<Integer, Integer> createTestCache() {
        CacheConfiguration ccfg = H2RowExpireTimeIndexSelfTest.defaultCacheConfiguration().setEagerTtl(false).setName("notEager").setQueryEntities(Collections.singleton(new QueryEntity("java.lang.Integer", "java.lang.Integer").setKeyFieldName("id").setValueFieldName("val").addQueryField("id", Integer.class.getName(), null).addQueryField("val", Integer.class.getName(), null).setIndexes(Collections.singleton(new QueryIndex("val"))).setTableName("Integer")));
        IgniteCache cache = this.grid(0).createCache(ccfg);
        return cache;
    }

    private void putExpiredSoon(IgniteCache cache, Integer key, Integer val) {
        CreatedExpiryPolicy expireSinceCreated = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 100L));
        IgniteCache expCache = cache.withExpiryPolicy((ExpiryPolicy)expireSinceCreated);
        expCache.put((Object)key, (Object)val);
    }

    private void putExpireInYear(IgniteCache cache, Integer key, Integer val) {
        CreatedExpiryPolicy expireSinceCreated = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, TimeUnit.DAYS.toMillis(365L)));
        IgniteCache expCache = cache.withExpiryPolicy((ExpiryPolicy)expireSinceCreated);
        expCache.put((Object)key, (Object)val);
    }

    @Test
    public void testTreeIndexSingleRow() throws Exception {
        IgniteCache<Integer, Integer> cache = this.createTestCache();
        cache.put((Object)1, (Object)2);
        cache.put((Object)3, (Object)4);
        this.putExpireInYear(cache, 5, 6);
        this.putExpiredSoon(cache, 42, 43);
        U.sleep((long)200L);
        List expired = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer where _key = 42")).getAll();
        Assert.assertTrue((String)("Expired row should not be returned by sql. Result = " + expired), (boolean)expired.isEmpty());
        expired = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer where id >= 42 and id <= 42")).getAll();
        Assert.assertTrue((String)("Expired row should not be returned by sql. Result = " + expired), (boolean)expired.isEmpty());
        expired = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer where id >= 5 and id <= 5")).getAll();
        H2RowExpireTimeIndexSelfTest.assertEqualsCollections(Collections.singletonList(Arrays.asList(5, 6)), (Collection)expired);
    }

    @Test
    public void testTreeIndexManyRows() throws Exception {
        IgniteCache<Integer, Integer> cache = this.createTestCache();
        cache.put((Object)1, (Object)2);
        cache.put((Object)3, (Object)4);
        this.putExpireInYear(cache, 5, 6);
        this.putExpiredSoon(cache, 42, 43);
        this.putExpiredSoon(cache, 77, 88);
        U.sleep((long)200L);
        List mixed = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer WHERE id >= 5")).getAll();
        H2RowExpireTimeIndexSelfTest.assertEqualsCollections(Collections.singletonList(Arrays.asList(5, 6)), (Collection)mixed);
        mixed = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer WHERE id >= 3")).getAll();
        H2RowExpireTimeIndexSelfTest.assertEqualsCollections(Arrays.asList(Arrays.asList(3, 4), Arrays.asList(5, 6)), (Collection)mixed);
        List expired = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer WHERE id >= 42")).getAll();
        Assert.assertTrue((String)("Expired row should not be returned by sql. Result = " + expired), (boolean)expired.isEmpty());
    }

    @Test
    public void testHashIndex() throws Exception {
        IgniteCache<Integer, Integer> cache = this.createTestCache();
        cache.put((Object)1, (Object)2);
        cache.put((Object)3, (Object)4);
        this.putExpireInYear(cache, 5, 6);
        this.putExpiredSoon(cache, 42, 43);
        this.putExpiredSoon(cache, 77, 88);
        U.sleep((long)200L);
        List mixed = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer USE INDEX (\"_key_PK_hash\")")).getAll();
        List<List> exp = Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4), Arrays.asList(5, 6));
        H2RowExpireTimeIndexSelfTest.assertEqualsCollections(exp, (Collection)mixed);
        List expired = cache.query(new SqlFieldsQuery("SELECT * FROM \"notEager\".Integer USE INDEX (\"_key_PK_hash\") WHERE id >= 42 and id <= 42")).getAll();
        Assert.assertTrue((String)("Expired row should not be returned by sql. Result = " + expired), (boolean)expired.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataExpiredAfterInsertFromSelect() throws Exception {
        int duration = 2000;
        try (IgniteEx grid = this.startGrid(1);){
            CacheConfiguration ccfg = new CacheConfiguration();
            ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            ccfg.setCacheMode(CacheMode.REPLICATED);
            ccfg.setName("temp");
            ccfg.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)Duration.ONE_DAY));
            IgniteCache cache = grid.getOrCreateCache(ccfg);
            CacheConfiguration ccfg1 = new CacheConfiguration();
            ccfg1.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            ccfg1.setCacheMode(CacheMode.REPLICATED);
            ccfg1.setName("person");
            ccfg1.setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, (long)duration)));
            grid.getOrCreateCache(ccfg1);
            FieldsQueryCursor res = cache.query(new SqlFieldsQuery("CREATE TABLE IF NOT EXISTS temp(\n    id VARCHAR,\n    updated TIMESTAMP,\n    PRIMARY KEY (id)\n) WITH \"\n    value_type=person_type,\n    cache_name=temp\n\""));
            H2RowExpireTimeIndexSelfTest.assertNotNull((Object)res);
            res.close();
            for (int i = 0; i < 10; ++i) {
                cache.query(new SqlFieldsQuery(String.format("INSERT INTO temp(id, updated) VALUES ('%d', CURRENT_TIMESTAMP())", i)));
            }
            cache.query(new SqlFieldsQuery("CREATE TABLE IF NOT EXISTS person(\n    id VARCHAR,\n    updated TIMESTAMP,\n    PRIMARY KEY (id)\n) WITH \"\n    value_type=person_type,\n    cache_name=person\n\""));
            cache.query(new SqlFieldsQuery("INSERT INTO person(id, updated)\nSELECT id, updated\nFROM temp;"));
            cache.query(new SqlFieldsQuery("INSERT INTO person(id, updated) VALUES ('11', CURRENT_TIMESTAMP());"));
            U.sleep((long)(2 * duration));
            res = cache.query(new SqlFieldsQuery("SELECT * FROM person order by id;"));
            H2RowExpireTimeIndexSelfTest.assertTrue((String)"Unexpected resultset.", (boolean)res.getAll().isEmpty());
            res.close();
        }
    }
}

