/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class H2ConnectionLeaksSelfTest
extends AbstractIndexingCommonTest {
    private static final String CACHE_NAME = "cache";
    private static final int NODE_CNT = 2;
    private static final int ITERS = 10;
    private static final int KEY_CNT = 100;
    private static final int THREAD_CNT = 100;

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME).setIndexedTypes(new Class[]{Long.class, String.class});
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if (this.getTestIgniteInstanceIndex(igniteInstanceName) != 0) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    @Test
    public void testConnectionLeaks() throws Exception {
        this.startGridAndPopulateCache(2);
        final IgniteCache cache = this.grid(1).cache(CACHE_NAME);
        final CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            new Thread(){

                @Override
                public void run() {
                    SqlFieldsQuery qry = new SqlFieldsQuery("select * from String").setLocal(false);
                    cache.query(qry).getAll();
                    latch.countDown();
                }
            }.start();
        }
        latch.await();
        this.checkThereAreNotUsedConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionLeaksOnSqlException() throws Exception {
        this.startGridAndPopulateCache(2);
        final CountDownLatch latch = new CountDownLatch(100);
        final CountDownLatch latch2 = new CountDownLatch(1);
        for (int i = 0; i < 100; ++i) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        IgniteH2Indexing idx = (IgniteH2Indexing)H2ConnectionLeaksSelfTest.this.grid(1).context().query().getIndexing();
                        idx.connections().executeStatement(H2ConnectionLeaksSelfTest.CACHE_NAME, "select *");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    latch.countDown();
                    try {
                        latch2.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
        try {
            latch.await();
            this.checkThereAreNotUsedConnections();
        }
        finally {
            latch2.countDown();
        }
    }

    @Test
    public void testDetachedConnectionOfLocalQueryOnNodeRestart() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.startGridAndPopulateCache(1);
            IgniteCache cache = this.grid(0).cache(CACHE_NAME);
            cache.query(new SqlFieldsQuery("select * from String").setLocal(true)).iterator().next();
            cache.query(new SqlFieldsQuery("select * from String").setLocal(true)).getAll();
            cache.query(new SqlFieldsQuery("select * from String").setLocal(true)).iterator().next();
            this.stopAllGrids();
            U.sleep((long)50L);
        }
        this.stopAllGrids();
        this.checkAllConnectionAreClosed();
    }

    @Test
    public void testSingleRowInsertWithNotConstantValues() throws Exception {
        this.startGridAndPopulateCache(1);
        this.sql(this.grid(0), "CREATE TABLE TEST_F(ID INT PRIMARY KEY, TS TIMESTAMP)", new Object[0]);
        this.sql(this.grid(0), "INSERT INTO TEST_F VALUES (?, CURRENT_TIMESTAMP())", 0);
        this.checkThereAreNotUsedConnections();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql(this.grid(0), "INSERT INTO TEST_F VALUES (1/?, CURRENT_TIMESTAMP())", 0), IgniteSQLException.class, (String)"Division by zero");
        this.checkThereAreNotUsedConnections();
    }

    @Test
    public void testMultipleRowsInsertWithNotConstantValues() throws Exception {
        this.startGridAndPopulateCache(1);
        this.sql(this.grid(0), "CREATE TABLE TEST_F(ID INT PRIMARY KEY, TS TIMESTAMP)", new Object[0]);
        this.sql(this.grid(0), "INSERT INTO TEST_F VALUES (?, CURRENT_TIMESTAMP()), (?, CURRENT_TIMESTAMP()), (?, CURRENT_TIMESTAMP())", 0, 1, 2);
        this.checkThereAreNotUsedConnections();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.sql(this.grid(0), "INSERT INTO TEST_F VALUES (?, CURRENT_TIMESTAMP()), (?, CURRENT_TIMESTAMP()), (?, CURRENT_TIMESTAMP())", 3, 0, 4), IgniteSQLException.class, (String)"Failed to INSERT some keys because they are already in cache [keys=[0]]");
        this.checkThereAreNotUsedConnections();
    }

    private void startGridAndPopulateCache(int nodes) throws Exception {
        this.startGrids(2);
        IgniteCache cache = this.grid(0).cache(CACHE_NAME);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)String.valueOf(i));
        }
    }

    private List<List<?>> sql(IgniteEx ign, String sql, Object ... params) {
        return ign.context().query().querySqlFields(new SqlFieldsQuery(sql).setLazy(true).setArgs(params), false).getAll();
    }
}

