/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.client.Person;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractRebuildIndexTest;
import org.apache.ignite.internal.processors.cache.index.IgniteH2IndexingEx;
import org.apache.ignite.internal.processors.cache.index.IndexingTestUtils;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.aware.IndexRebuildFutureStorage;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.internal.h2.table.IndexColumn;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class ForceRebuildIndexTest
extends AbstractRebuildIndexTest {
    private static final Semaphore hook = new Semaphore(0);

    @Test
    public void testSequentialForceRebuildIndexes() throws Exception {
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 100);
        GridCacheContext cacheCtx = n.cachex("default").context();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, cacheCtx.name());
        ForceRebuildIndexTest.assertEqualsCollections(Collections.emptyList(), (Collection)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}));
        IgniteInternalFuture<?> idxRebFut0 = this.checkStartRebuildIndexes(n, cacheCtx);
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        ForceRebuildIndexTest.assertFalse((boolean)idxRebFut0.isDone());
        ForceRebuildIndexTest.assertEqualsCollections((Collection)F.asList((Object)cacheCtx), (Collection)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}));
        ForceRebuildIndexTest.assertTrue((idxRebFut0 == this.indexRebuildFuture(n, cacheCtx.cacheId()) ? 1 : 0) != 0);
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut0.get(this.getTestTimeout());
        this.checkFinishRebuildIndexes(n, cacheCtx, 100);
        ForceRebuildIndexTest.assertEquals((long)100L, (long)stopRebuildIdxConsumer.visitCnt.get());
        stopRebuildIdxConsumer.resetFutures();
        ForceRebuildIndexTest.assertEqualsCollections(Collections.emptyList(), (Collection)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}));
        IgniteInternalFuture<?> idxRebFut1 = this.checkStartRebuildIndexes(n, cacheCtx);
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        ForceRebuildIndexTest.assertFalse((boolean)idxRebFut1.isDone());
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut1.get(this.getTestTimeout());
        this.checkFinishRebuildIndexes(n, cacheCtx, 100);
        ForceRebuildIndexTest.assertEquals((long)200L, (long)stopRebuildIdxConsumer.visitCnt.get());
    }

    @Test
    public void testCorruptedIndexRebuild() throws Exception {
        H2TreeIndex.h2TreeFactory = CorruptedH2Tree::new;
        IgniteEx ignite = this.startGrid(0);
        this.sql("CREATE TABLE test_tbl (id INTEGER PRIMARY KEY, val VARCHAR) WITH \"cache_name=TEST_CACHE, key_type=KEY, value_type=VAL\"", new Object[0]);
        int corruptedKey = 5;
        for (int i = 0; i < 10; ++i) {
            if (i == corruptedKey) {
                CorruptedH2Tree.corrupt = true;
            }
            this.sql("INSERT INTO test_tbl VALUES (?, ?)", i, "val_" + i);
            CorruptedH2Tree.corrupt = false;
        }
        ForceRebuildIndexTest.assertEquals((Object)10L, this.sql("SELECT count(id) FROM test_tbl USE INDEX (\"_key_PK\")", new Object[0]).get(0).get(0));
        this.grid(0).cache("TEST_CACHE").remove((Object)this.grid(0).binary().builder("KEY").setField("id", (Object)corruptedKey).build());
        ForceRebuildIndexTest.assertEquals((int)9, (int)this.grid(0).cache("TEST_CACHE").size(new CachePeekMode[0]));
        ForceRebuildIndexTest.assertEquals((Object)10L, this.sql("SELECT count(id) FROM test_tbl USE INDEX (\"_key_PK\")", new Object[0]).get(0).get(0));
        GridTestUtils.assertThrowsWithCause(() -> this.sql("SELECT * FROM test_tbl", new Object[0]), Exception.class);
        GridCacheContext cacheCtx = ignite.cachex("TEST_CACHE").context();
        this.forceRebuildIndexes(ignite, new GridCacheContext[]{cacheCtx});
        IgniteInternalFuture fut = this.indexRebuildFuture(ignite, cacheCtx.cacheId());
        if (fut != null) {
            fut.get(this.getTestTimeout());
        }
        ForceRebuildIndexTest.assertEquals((int)9, (int)this.sql("SELECT * FROM test_tbl", new Object[0]).size());
    }

    @Test
    public void testLazyQueryShouldBeProperlyCancelled() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        this.sql("CREATE TABLE test_tbl (id INTEGER, aff_key INTEGER, val VARCHAR, CONSTRAINT pk PRIMARY KEY (id, aff_key)) WITH \"cache_name=TEST_CACHE, affinity_key=aff_key\"", new Object[0]);
        this.sql("CREATE INDEX test_tbl_val_idx ON test_tbl(val)", new Object[0]);
        for (int i = 0; i < 100000; ++i) {
            this.sql("INSERT INTO test_tbl VALUES (?, ?, ?)", i, i, "val_" + i);
        }
        Iterator curByPk = this.openCursor("SELECT id FROM test_tbl USE INDEX (\"_key_PK\") WHERE id > -1", new Object[0]).iterator();
        Iterator curByAff = this.openCursor("SELECT aff_key FROM test_tbl USE INDEX (AFFINITY_KEY) WHERE aff_key > -1", new Object[0]).iterator();
        Iterator curBySecIdx = this.openCursor("SELECT val FROM test_tbl USE INDEX (test_tbl_val_idx) WHERE VAL > 'val'", new Object[0]).iterator();
        curByPk.next();
        curByAff.next();
        curBySecIdx.next();
        GridCacheContext cacheCtx = ignite.cachex("TEST_CACHE").context();
        this.forceRebuildIndexes(ignite, new GridCacheContext[]{cacheCtx});
        IgniteInternalFuture fut = this.indexRebuildFuture(ignite, cacheCtx.cacheId());
        if (fut != null) {
            fut.get(this.getTestTimeout());
        }
        GridTestUtils.assertThrowsWithCause(() -> ForceRebuildIndexTest.drainIterator(curByPk), QueryRetryException.class);
        GridTestUtils.assertThrowsWithCause(() -> ForceRebuildIndexTest.drainIterator(curByAff), QueryRetryException.class);
        GridTestUtils.assertThrowsWithCause(() -> ForceRebuildIndexTest.drainIterator(curBySecIdx), QueryRetryException.class);
    }

    @Test
    public void testNonLazyQueryShouldCompleteNormally() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.getOrCreateCache(new CacheConfiguration("DUMMY").setSqlSchema("PUBLIC").setSqlFunctionClasses(new Class[]{((Object)((Object)this)).getClass()}));
        this.sql("CREATE TABLE test_tbl (id INTEGER PRIMARY KEY, val VARCHAR) WITH \"cache_name=TEST_CACHE\"", new Object[0]);
        for (int i = 0; i < 10000; ++i) {
            this.sql("INSERT INTO test_tbl VALUES (?, ?)", i, "val_" + i);
        }
        hook.drainPermits();
        IgniteInternalFuture qryFut = GridTestUtils.runAsync(() -> this.sql("SELECT id FROM test_tbl WHERE hook() ORDER BY val", new Object[0]));
        ForceRebuildIndexTest.assertTrue((boolean)GridTestUtils.waitForCondition(hook::hasQueuedThreads, (long)2000L));
        GridCacheContext cacheCtx = ignite.cachex("TEST_CACHE").context();
        IgniteInternalFuture startRebuildFut = GridTestUtils.runAsync(() -> this.forceRebuildIndexes(ignite, new GridCacheContext[]{cacheCtx}));
        ForceRebuildIndexTest.assertFalse((boolean)startRebuildFut.isDone());
        hook.release(Integer.MAX_VALUE);
        startRebuildFut.get(this.getTestTimeout());
        IgniteInternalFuture fut = this.indexRebuildFuture(ignite, cacheCtx.cacheId());
        ForceRebuildIndexTest.assertNotNull((Object)qryFut);
        qryFut.get(this.getTestTimeout());
        fut.get(this.getTestTimeout());
    }

    @Test
    public void testForceRebuildIndexesAfterExchange() throws Exception {
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 100);
        this.stopAllGridsWithDeleteIndexBin();
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, "default");
        n = this.startGrid(0);
        GridCacheContext cacheCtx = n.cachex("default").context();
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        IgniteInternalFuture<?> idxRebFut0 = this.checkStartRebuildIndexes(n, cacheCtx);
        this.checkRebuildAfterExchange(n, cacheCtx.cacheId(), true);
        ForceRebuildIndexTest.assertEqualsCollections((Collection)F.asList((Object)cacheCtx), (Collection)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}));
        ForceRebuildIndexTest.assertTrue((idxRebFut0 == this.indexRebuildFuture(n, cacheCtx.cacheId()) ? 1 : 0) != 0);
        this.checkRebuildAfterExchange(n, cacheCtx.cacheId(), true);
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut0.get(this.getTestTimeout());
        this.checkFinishRebuildIndexes(n, cacheCtx, 100);
        ForceRebuildIndexTest.assertEquals((long)100L, (long)stopRebuildIdxConsumer.visitCnt.get());
        this.checkRebuildAfterExchange(n, cacheCtx.cacheId(), false);
        stopRebuildIdxConsumer.resetFutures();
        ForceRebuildIndexTest.assertEqualsCollections(Collections.emptyList(), (Collection)this.forceRebuildIndexes(n, new GridCacheContext[]{cacheCtx}));
        IgniteInternalFuture<?> idxRebFut1 = this.checkStartRebuildIndexes(n, cacheCtx);
        this.checkRebuildAfterExchange(n, cacheCtx.cacheId(), false);
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        ForceRebuildIndexTest.assertFalse((boolean)idxRebFut1.isDone());
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut1.get(this.getTestTimeout());
        this.checkFinishRebuildIndexes(n, cacheCtx, 100);
        this.checkRebuildAfterExchange(n, cacheCtx.cacheId(), false);
        ForceRebuildIndexTest.assertEquals((long)200L, (long)stopRebuildIdxConsumer.visitCnt.get());
    }

    @Test
    public void testSequentialRebuildIndexesOnExchange() throws Exception {
        IgniteEx n = this.startGrid(0);
        this.populate((IgniteCache<Integer, Person>)n.cache("default"), 100);
        this.stopAllGridsWithDeleteIndexBin();
        IgniteH2IndexingEx.prepareBeforeNodeStart();
        IndexingTestUtils.StopBuildIndexConsumer stopRebuildIdxConsumer = this.addStopRebuildIndexConsumer(n, "default");
        n = this.startGrid(0);
        GridCacheContext cacheCtx = n.cachex("default").context();
        stopRebuildIdxConsumer.startBuildIdxFut.get(this.getTestTimeout());
        IgniteInternalFuture<?> idxRebFut = this.checkStartRebuildIndexes(n, cacheCtx);
        n.getOrCreateCache("default_1");
        ForceRebuildIndexTest.assertTrue((idxRebFut == this.indexRebuildFuture(n, cacheCtx.cacheId()) ? 1 : 0) != 0);
        stopRebuildIdxConsumer.finishBuildIdxFut.onDone();
        idxRebFut.get(this.getTestTimeout());
        this.checkFinishRebuildIndexes(n, cacheCtx, 100);
        ForceRebuildIndexTest.assertEquals((long)100L, (long)stopRebuildIdxConsumer.visitCnt.get());
    }

    private void checkRebuildAfterExchange(IgniteEx n, int cacheId, boolean expContains) {
        IndexRebuildFutureStorage idxRebuildAware = (IndexRebuildFutureStorage)GridTestUtils.getFieldValue((Object)n.context().query(), (String[])new String[]{"idxRebuildFutStorage"});
        GridDhtPartitionsExchangeFuture exhFut = n.context().cache().context().exchange().lastTopologyFuture();
        ForceRebuildIndexTest.assertEquals((boolean)expContains, (boolean)idxRebuildAware.rebuildIndexesOnExchange(cacheId, exhFut.initialVersion()));
    }

    private List<List<?>> sql(String qry, Object ... args) {
        return this.openCursor(qry, args).getAll();
    }

    private FieldsQueryCursor<List<?>> openCursor(String qry, Object ... args) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(qry).setArgs(args).setLazy(true), true);
    }

    private static void drainIterator(Iterator<?> it) {
        while (it.hasNext()) {
            it.next();
        }
    }

    @QuerySqlFunction
    public static boolean hook() {
        try {
            hook.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            hook.release();
        }
        return true;
    }

    static class CorruptedH2Tree
    extends H2Tree {
        static volatile boolean corrupt = false;

        public CorruptedH2Tree(@Nullable GridCacheContext<?, ?> cctx, GridH2Table table, String name, String idxName, String cacheName, String tblName, ReuseList reuseList, int grpId, String grpName, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, long metaPageId, boolean initNew, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, AtomicInteger maxCalculatedInlineSize, boolean pk, boolean affinityKey, boolean mvccEnabled, @Nullable H2RowCache rowCache, @Nullable FailureProcessor failureProcessor, PageLockTrackerManager pageLockTrackerManager, IgniteLogger log, @Nullable IoStatisticsHolder stats, InlineIndexColumnFactory factory, int configuredInlineSize, PageIoResolver pageIoRslvr) throws IgniteCheckedException {
            super(cctx, table, name, idxName, cacheName, tblName, reuseList, grpId, grpName, pageMem, wal, globalRmvId, metaPageId, initNew, unwrappedCols, wrappedCols, maxCalculatedInlineSize, pk, affinityKey, mvccEnabled, rowCache, failureProcessor, pageLockTrackerManager, log, stats, factory, configuredInlineSize, pageIoRslvr);
        }

        protected int compare(BPlusIO<H2Row> io, long pageAddr, int idx, H2Row row) throws IgniteCheckedException {
            int cmp = super.compare(io, pageAddr, idx, row);
            return corrupt ? -cmp : cmp;
        }
    }
}

