/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.After;
import org.junit.Test;

public class DecimalIndexTest
extends AbstractIndexingCommonTest {
    private ListeningTestLogger testLog = new ListeningTestLogger(false, log);

    @After
    public void tearDown() {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration igniteCfg = super.getConfiguration(igniteInstanceName);
        igniteCfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        igniteCfg.setGridLogger((IgniteLogger)this.testLog);
        return igniteCfg;
    }

    @Test
    @WithSystemProperty(key="IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", value="1")
    public void smallInlineSIze() throws Exception {
        String TBL_NAME = "DECIMAL_TABLE";
        String ERROR_MSG = "Indexed columns of a row cannot be fully inlined into index";
        LogListener lsnr = LogListener.matches((String)"Indexed columns of a row cannot be fully inlined into index").build();
        this.testLog.registerListener(lsnr);
        IgniteEx node = this.startGrid(0);
        this.sql((Ignite)node, "create table DECIMAL_TABLE (key_pk int, key1 decimal, key2 decimal, key3 decimal, primary key(key_pk), val int)", new Object[0]);
        this.sql((Ignite)node, "create index pk_id on DECIMAL_TABLE (key1, key2, key3) inline_size 19", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, key3, val) values (1, 1.0, 2.0, 3.0, 1)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, key3, val) values (2, 1.0, 2.0, 3.0, 1)", new Object[0]);
        DecimalIndexTest.assertTrue((String)"Unexpected full inline of the index", (boolean)lsnr.check());
    }

    @Test
    @WithSystemProperty(key="IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", value="1")
    public void correctInlineSIze() throws Exception {
        String TBL_NAME = "DECIMAL_TABLE";
        String ERROR_MSG = "Indexed columns of a row cannot be fully inlined into index";
        LogListener lsnr = LogListener.matches((String)"Indexed columns of a row cannot be fully inlined into index").build();
        this.testLog.registerListener(lsnr);
        IgniteEx node = this.startGrid(0);
        this.sql((Ignite)node, "create table DECIMAL_TABLE (key_pk int, key1 decimal, key2 decimal, key3 decimal, primary key(key_pk), val int)", new Object[0]);
        this.sql((Ignite)node, "create index pk_id on DECIMAL_TABLE (key1, key2, key3) inline_size 20", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, key3, val) values (1, 1.0, 2.0, 3.0, 1)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, key3, val) values (2, 1.0, 2.0, 3.0, 1)", new Object[0]);
        DecimalIndexTest.assertFalse((String)"Full inline of the index didn't happen", (boolean)lsnr.check());
    }

    @Test
    @WithSystemProperty(key="IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", value="1")
    public void nullAndOutOfRangeValues() throws Exception {
        String TBL_NAME = "DECIMAL_TABLE";
        String ERROR_MSG = "Indexed columns of a row cannot be fully inlined into index";
        LogListener lsnr = LogListener.matches((String)"Indexed columns of a row cannot be fully inlined into index").build();
        this.testLog.registerListener(lsnr);
        IgniteEx node = this.startGrid(0);
        this.sql((Ignite)node, "create table DECIMAL_TABLE (key_pk int, key1 decimal, key2 decimal, primary key(key_pk), val int)", new Object[0]);
        this.sql((Ignite)node, "create index pk_id on DECIMAL_TABLE (key1, key2)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, val) values (1, 1.0, 2.0, 10)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, val) values (2, null, 2.0, 20)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, val) values (3, 1.0, null, 30)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, val) values (4, 3.40282347E+99, 2.0, 40)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, val) values (5, 1.0, 3.40282347E+99, 50)", new Object[0]);
        this.sql((Ignite)node, "insert into DECIMAL_TABLE(key_pk, key1, key2, val) values (6, 1.0, 2.0, 60)", new Object[0]);
        List<List<?>> res = this.sql((Ignite)node, "select val from DECIMAL_TABLE where key1 = 1.0 and key2 > 2.0", new Object[0]);
        DecimalIndexTest.assertEquals((int)1, (int)res.size());
        DecimalIndexTest.assertEquals((int)1, (int)res.get(0).size());
        DecimalIndexTest.assertEquals((Object)50, res.get(0).get(0));
    }

    private List<List<?>> sql(Ignite ig, String sql, Object ... args) {
        return ((IgniteEx)ig).context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), true).getAll();
    }
}

