/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.util.typedef.F;
import org.junit.Test;

public class ComplexPrimaryKeyUnwrapSelfTest
extends AbstractIndexingCommonTest {
    private static int tblCnt = 0;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrid(0);
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    @Test
    public void testComplexPk() {
        String tblName = this.createTableName();
        this.executeSql("CREATE TABLE " + tblName + " (id int, name varchar, age int, company varchar, city varchar, primary key (id, name, city))", new Object[0]);
        this.checkUsingIndexes(tblName, "1", 2);
    }

    @Test
    public void testSimplePk() {
        HashMap types = new HashMap(){
            {
                this.put("boolean", "1");
                this.put("char", "'1'");
                this.put("varchar", "'1'");
                this.put("real", "1");
                this.put("number", "1");
                this.put("int", "1");
                this.put("long", "1");
                this.put("float", "1");
                this.put("double", "1");
                this.put("tinyint", "1");
                this.put("smallint", "1");
                this.put("bigint", "1");
                this.put("varchar_ignorecase", "'1'");
                this.put("time", "'11:11:11'");
                this.put("timestamp", "'20018-11-02 11:11:11'");
                this.put("uuid", "'1'");
            }
        };
        for (Map.Entry entry : types.entrySet()) {
            String tblName = this.createTableName();
            String type = (String)entry.getKey();
            String val = (String)entry.getValue();
            this.executeSql("CREATE TABLE " + tblName + " (id " + type + " , name varchar, age int, company varchar, city varchar, primary key (id))", new Object[0]);
            this.checkUsingIndexes(tblName, val, 1);
        }
    }

    @Test
    public void testSimplePkWithAffinityKey() {
        HashMap types = new HashMap(){
            {
                this.put("boolean", "1");
                this.put("char", "'1'");
                this.put("varchar", "'1'");
                this.put("real", "1");
                this.put("number", "1");
                this.put("int", "1");
                this.put("long", "1");
                this.put("float", "1");
                this.put("double", "1");
                this.put("tinyint", "1");
                this.put("smallint", "1");
                this.put("bigint", "1");
                this.put("varchar_ignorecase", "'1'");
                this.put("time", "'11:11:11'");
                this.put("timestamp", "'20018-11-02 11:11:11'");
                this.put("uuid", "'1'");
            }
        };
        for (Map.Entry entry : types.entrySet()) {
            String tblName = this.createTableName();
            String type = (String)entry.getKey();
            String val = (String)entry.getValue();
            this.executeSql("CREATE TABLE " + tblName + " (id " + type + " , name varchar, age int, company varchar, city varchar, primary key (id)) WITH \"affinity_key=id\"", new Object[0]);
            this.checkUsingIndexes(tblName, val, 1);
        }
    }

    @Test
    public void testWrappedPk() {
        String tblName = this.createTableName();
        this.executeSql("CREATE TABLE " + tblName + " (id int, name varchar, age int, company varchar, city varchar, primary key (id)) WITH \"wrap_key=true\"", new Object[0]);
        this.checkUsingIndexes(tblName, "1", 1);
    }

    @Test
    public void testInlineSizeNoWrap() {
        this.executeSql("DROP TABLE IF EXISTS TABLE1", new Object[0]);
        this.executeSql("CREATE TABLE IF NOT EXISTS TABLE1 (   id varchar(15),   col varchar(100),   PRIMARY KEY(id) ) ", new Object[0]);
        ComplexPrimaryKeyUnwrapSelfTest.assertEquals((Object)18, this.executeSql("select INLINE_SIZE from SYS.INDEXES where TABLE_NAME = 'TABLE1' and IS_PK = true", new Object[0]).get(0).get(0));
    }

    @Test
    public void testInlineSizeWrap() {
        this.executeSql("DROP TABLE IF EXISTS TABLE1", new Object[0]);
        this.executeSql("CREATE TABLE IF NOT EXISTS TABLE1 (   id varchar(15),   col varchar(100),   PRIMARY KEY(id) )  WITH \"wrap_key=true\"", new Object[0]);
        ComplexPrimaryKeyUnwrapSelfTest.assertEquals((Object)18, this.executeSql("select INLINE_SIZE from SYS.INDEXES where TABLE_NAME = 'TABLE1' and IS_PK = true", new Object[0]).get(0).get(0));
    }

    @Test
    public void testInlineSizeWrap2() {
        this.executeSql("DROP TABLE IF EXISTS TABLE1", new Object[0]);
        this.executeSql("CREATE TABLE IF NOT EXISTS TABLE1 (   id varchar(15),   id2 uuid,   col varchar(100),   PRIMARY KEY(id, id2) )  WITH \"wrap_key=true\"", new Object[0]);
        ComplexPrimaryKeyUnwrapSelfTest.assertEquals((Object)35, this.executeSql("select INLINE_SIZE from SYS.INDEXES where TABLE_NAME = 'TABLE1' and IS_PK = true", new Object[0]).get(0).get(0));
    }

    private void checkUsingIndexes(String tblName, String idVal, int expResCnt) {
        String explainSQL = "explain SELECT * FROM " + tblName + " WHERE ";
        List<List<?>> results = this.executeSql(explainSQL + "id=" + idVal, new Object[0]);
        this.assertUsingPkIndex(results, expResCnt);
        results = this.executeSql(explainSQL + "id=" + idVal + " and name=''", new Object[0]);
        this.assertUsingPkIndex(results, expResCnt);
        results = this.executeSql(explainSQL + "id=" + idVal + " and name='' and city='' and age=0", new Object[0]);
        this.assertUsingPkIndex(results, expResCnt);
    }

    @Test
    public void testIndexesForCachesCreatedThroughCashApi() {
        String tblName = TestValue.class.getSimpleName();
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setSqlSchema("PUBLIC");
        ccfg.setName(tblName);
        QueryEntity qryEntity = new QueryEntity(TestKey.class, TestValue.class);
        ccfg.setQueryEntities((Collection)F.asList((Object)qryEntity));
        this.node().createCache(ccfg);
        List<List<?>> results = this.executeSql("explain SELECT * FROM " + tblName + " WHERE id=1", new Object[0]);
        this.assertDontUsingPkIndex(results);
    }

    private void assertUsingPkIndex(List<List<?>> results, int expResCnt) {
        ComplexPrimaryKeyUnwrapSelfTest.assertEquals((int)expResCnt, (int)results.size());
        String explainPlan = (String)results.get(0).get(0);
        ComplexPrimaryKeyUnwrapSelfTest.assertTrue((boolean)explainPlan.contains("_key_PK"));
        ComplexPrimaryKeyUnwrapSelfTest.assertFalse((boolean)explainPlan.contains("_SCAN_"));
    }

    private void assertDontUsingPkIndex(List<List<?>> results) {
        ComplexPrimaryKeyUnwrapSelfTest.assertEquals((int)2, (int)results.size());
        String explainPlan = (String)results.get(0).get(0);
        System.out.println(explainPlan);
        ComplexPrimaryKeyUnwrapSelfTest.assertFalse((boolean)explainPlan.contains("_key_PK"));
        ComplexPrimaryKeyUnwrapSelfTest.assertTrue((boolean)explainPlan.contains("_SCAN_"));
    }

    private String createTableName() {
        return "TST_TABLE_" + tblCnt++;
    }

    private List<List<?>> executeSql(String stmt, Object ... args) {
        return this.executeSql(this.node(), stmt, args);
    }

    private List<List<?>> executeSql(IgniteEx node, String stmt, Object ... args) {
        return node.context().query().querySqlFields(new SqlFieldsQuery(stmt).setArgs(args), true).getAll();
    }

    private IgniteEx node() {
        return this.grid(0);
    }

    static class TestValue {
        @QuerySqlField
        private String name;
        @QuerySqlField
        private String company;
        @QuerySqlField
        private String city;
        @QuerySqlField
        private int age;

        public TestValue(int age, String name, String company, String city) {
            this.age = age;
            this.name = name;
            this.company = company;
            this.city = city;
        }
    }

    static class TestKey {
        @QuerySqlField
        private int id;

        public TestKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey testKey = (TestKey)o;
            return this.id == testKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

