/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class ClientReconnectWithSqlTableConfiguredTest
extends AbstractIndexingCommonTest {
    private boolean sameGrp;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)igniteInstanceName)).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    private CacheConfiguration createCacheConfiguration(String cacheName) {
        return new CacheConfiguration(cacheName).setCacheMode(CacheMode.REPLICATED).setGroupName(this.sameGrp ? "grp" : "grp-" + cacheName).setQueryEntities(Arrays.asList(new QueryEntity().setTableName("TEST-" + cacheName).setKeyType(String.class.getName()).setValueType(Timestamp.class.getName())));
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testCahceInOneGroup() throws Exception {
        this.sameGrp = true;
        this.checkClientRecconect();
    }

    @Test
    public void testCahceInDifferentGroups() throws Exception {
        this.sameGrp = false;
        this.checkClientRecconect();
    }

    private void checkClientRecconect() throws Exception {
        IgniteEx ignite0 = this.startGrids(2);
        IgniteEx client1 = this.startClientGrid(2);
        IgniteEx client2 = this.startClientGrid(3);
        ignite0.cluster().active(true);
        client1.getOrCreateCache(this.createCacheConfiguration("test-cl1"));
        client2.getOrCreateCache(this.createCacheConfiguration("test-cl2"));
        client2.close();
        this.stopAllServers(true);
        final CountDownLatch reconnectLatch = new CountDownLatch(1);
        client1.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                if (evt.type() == 17) {
                    log.info(">>>>> reconnect evt=" + evt);
                    reconnectLatch.countDown();
                }
                return true;
            }
        }, new int[]{17});
        ignite0 = this.startGrid(0);
        reconnectLatch.await();
        this.startGrid(1);
        AffinityTopologyVersion topVer = new AffinityTopologyVersion(3L, 1);
        AtomicReference lastFinishedFuture = new AtomicReference();
        ClientReconnectWithSqlTableConfiguredTest.assertTrue((String)"Could not wait for autoactivation.", (boolean)GridTestUtils.waitForCondition(() -> {
            for (GridDhtPartitionsExchangeFuture fut : client1.context().cache().context().exchange().exchangeFutures()) {
                if (!fut.isDone() || !fut.topologyVersion().equals((Object)topVer)) continue;
                lastFinishedFuture.set(fut);
                return true;
            }
            return false;
        }, (long)15000L));
        log.info(">>>>> lastFinishedFuture ver=" + ((GridDhtPartitionsExchangeFuture)lastFinishedFuture.get()).topologyVersion());
        Throwable t = (Throwable)U.field(lastFinishedFuture.get(), (String)"exchangeLocE");
        ClientReconnectWithSqlTableConfiguredTest.assertNull((String)("Unexpected exception on client node [exc=" + t + ']'), (Object)t);
    }
}

