/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.encryption;

import java.util.List;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.encryption.EncryptedCacheRestartTest;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncryptedSqlTableTest
extends EncryptedCacheRestartTest {
    protected void createEncryptedCache(IgniteEx grid0, @Nullable IgniteEx grid1, String cacheName, String cacheGroup, boolean putData) {
        this.executeSql(grid0, "CREATE TABLE encrypted(ID BIGINT, NAME VARCHAR(10), PRIMARY KEY (ID)) WITH \"ENCRYPTED=true\"", new Object[0]);
        this.executeSql(grid0, "CREATE INDEX enc0 ON encrypted(NAME)", new Object[0]);
        if (putData) {
            for (int i = 0; i < 100; ++i) {
                this.executeSql(grid0, "INSERT INTO encrypted(ID, NAME) VALUES(?, ?)", i, "" + i);
            }
        }
    }

    protected void checkData(IgniteEx grid0) {
        for (int i = 0; i < 100; ++i) {
            List<List<?>> res = this.executeSql(grid0, "SELECT NAME FROM encrypted WHERE ID = ?", i);
            EncryptedSqlTableTest.assertEquals((int)1, (int)res.size());
            EncryptedSqlTableTest.assertEquals((Object)("" + i), res.get(0).get(0));
        }
    }

    private List<List<?>> executeSql(IgniteEx grid, String qry, Object ... args) {
        return grid.context().query().querySqlFields(new SqlFieldsQuery(qry).setSchema("PUBLIC").setArgs(args), true).getAll();
    }

    @NotNull
    protected String cacheName() {
        return "SQL_PUBLIC_ENCRYPTED";
    }

    protected String keystorePath() {
        return IgniteUtils.resolveIgnitePath((String)"modules/indexing/src/test/resources/tde.jks").getAbsolutePath();
    }
}

