/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteSqlQueryWithBaselineTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0xC800000L).setPersistenceEnabled(true)));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testQueryWithNodeNotInBLT() throws Exception {
        this.startGrids(2);
        this.grid(0).cluster().active(true);
        this.startGrid(2);
        this.doQuery();
    }

    @Test
    public void testQueryWithoutBLTNode() throws Exception {
        this.startGrids(2);
        this.grid(0).cluster().active(true);
        this.startGrid(2);
        this.stopGrid(1);
        this.doQuery();
    }

    @Test
    public void testQueryFromNotBLTNode() throws Exception {
        this.startGrid(1);
        this.grid(1).cluster().active(true);
        this.startGrid(0);
        this.doQuery();
    }

    private void doQuery() {
        CacheConfiguration c1Conf = new CacheConfiguration("C1");
        c1Conf.setIndexedTypes(new Class[]{Integer.class, C1.class}).setBackups(2);
        CacheConfiguration c2Conf = new CacheConfiguration("C2");
        c2Conf.setIndexedTypes(new Class[]{Integer.class, C2.class}).setBackups(2);
        IgniteCache cache = this.grid(0).getOrCreateCache(c1Conf);
        IgniteCache cache1 = this.grid(0).getOrCreateCache(c2Conf);
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)new C1(i));
            cache1.put((Object)i, (Object)new C2(i));
        }
        String sql = "SELECT C1.* from C1 inner join \"C2\".C2 as D on C1.id = D.id order by C1.id asc";
        SqlQuery qry = new SqlQuery(C1.class, sql);
        qry.setDistributedJoins(true);
        log.info("before query run...");
        List res = cache.query((Query)qry).getAll();
        log.info("result size: " + res.size());
    }

    public static class C2
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @QuerySqlField(index=true)
        protected Integer id;

        C2(int id) {
            this.id = id;
        }
    }

    public static class C1
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @QuerySqlField(index=true)
        protected Integer id;

        public C1(int id) {
            this.id = id;
        }
    }
}

