/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheQueryReservationOnUnstableTopologyTest
extends GridCommonAbstractTest {
    private static final int PARTS = 32;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConsistentId((Serializable)((Object)igniteInstanceName));
        cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setIndexedTypes(new Class[]{Integer.class, Integer.class}).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(1)});
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testQueryReservationReleaseNormal() throws Exception {
        this.doTestQueryReservationRelease(false, false);
    }

    @Test
    public void testQueryReservationReleaseLazy() throws Exception {
        this.doTestQueryReservationRelease(true, false);
    }

    @Test
    public void testQueryReservationReleaseNormal_SmallPage() throws Exception {
        this.doTestQueryReservationRelease(false, true);
    }

    @Test
    public void testQueryReservationReleaseLazy_SmallPage() throws Exception {
        this.doTestQueryReservationRelease(true, true);
    }

    private void doTestQueryReservationRelease(final boolean lazy, final boolean smallPage) throws Exception {
        IgniteEx crd = this.startGrids(2);
        this.awaitPartitionMapExchange();
        int keys = 160;
        for (int i = 0; i < 160; ++i) {
            crd.cache("default").put((Object)i, (Object)i);
        }
        final AtomicBoolean stop = new AtomicBoolean();
        IgniteInternalFuture qryFut = this.multithreadedAsync(new Runnable(){

            @Override
            public void run() {
                while (!stop.get()) {
                    SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM Integer");
                    qry.setLazy(lazy);
                    if (smallPage) {
                        qry.setPageSize(1);
                    }
                    IgniteCacheQueryReservationOnUnstableTopologyTest.assertEquals((int)160, (int)IgniteCacheQueryReservationOnUnstableTopologyTest.this.grid(0).cache("default").query(qry).getAll().size());
                }
            }
        }, 3, "qry-thread");
        IgniteCacheQueryReservationOnUnstableTopologyTest.doSleep((long)100L);
        this.startGrid(2);
        this.startGrid(3);
        stop.set(true);
        this.awaitPartitionMapExchange();
        qryFut.get();
    }
}

