/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class IgniteCacheDistributedQueryDefaultTimeoutSelfTest
extends GridCommonAbstractTest {
    private static final int GRIDS_CNT = 3;
    public static final int CACHE_SIZE = 10000;
    private static final long DEFAULT_QUERY_TIMEOUT = 1000L;
    public static final int VAL_SIZE = 16;
    private static final String QRY_1 = "select a._val, b._val, delay(1) from String a, String b";
    private static final String QRY_2 = "select a._key, count(*), delay(1) from String a group by a._key";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        ccfg.setSqlFunctionClasses(new Class[]{GridTestUtils.SqlTestFunctions.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if ("client".equals(igniteInstanceName)) {
            cfg.setClientMode(true);
        }
        cfg.setSqlConfiguration(new SqlConfiguration().setDefaultQueryTimeout(1000L));
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid(0).cache("default").removeAll();
    }

    @Test
    public void testRemoteQueryExecutionTimeout() throws Exception {
        this.testQueryCancel(QRY_1, 500, TimeUnit.MILLISECONDS, true);
    }

    @Test
    public void testRemoteQueryWithMergeTableTimeout() throws Exception {
        this.testQueryCancel(QRY_2, 500, TimeUnit.MILLISECONDS, true);
    }

    @Test
    public void testRemoteQueryExecutionCancel0() throws Exception {
        this.testQueryCancel(QRY_1, 1, TimeUnit.MILLISECONDS, false);
    }

    private void testQueryCancel(String sql, int timeout, TimeUnit timeUnit, boolean useTimeout) throws Exception {
        try (IgniteEx client = this.startGrid("client");){
            FieldsQueryCursor cursor;
            IgniteCache cache = client.cache("default");
            IgniteCacheDistributedQueryDefaultTimeoutSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            for (int i = 1; i <= 10000; ++i) {
                cache.put((Object)i, (Object)GridTestUtils.randomString((Random)ThreadLocalRandom.current(), (int)16));
            }
            IgniteCacheDistributedQueryDefaultTimeoutSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            SqlFieldsQuery qry = new SqlFieldsQuery(sql);
            if (useTimeout) {
                qry.setTimeout(timeout, timeUnit);
                cursor = cache.query(qry);
            } else {
                cursor = cache.query(qry);
                client.scheduler().runLocal(() -> ((QueryCursor)cursor).close(), (long)timeout, timeUnit);
            }
            try (FieldsQueryCursor ignored = cursor;){
                cursor.getAll();
                IgniteCacheDistributedQueryDefaultTimeoutSelfTest.fail((String)"Query not canceled");
            }
            catch (CacheException ex) {
                this.error("Got expected exception", ex);
                IgniteCacheDistributedQueryDefaultTimeoutSelfTest.assertNotNull((String)"Must throw correct exception", (Object)X.cause((Throwable)ex, QueryCancelledException.class));
            }
            Thread.sleep(TimeUnit.MILLISECONDS.convert(timeout, timeUnit) + 3000L);
            this.checkCleanState();
        }
    }

    private void checkCleanState() {
        for (int i = 0; i < 3; ++i) {
            IgniteEx grid = this.grid(i);
            ConcurrentMap map = (ConcurrentMap)U.field((Object)((IgniteH2Indexing)grid.context().query().getIndexing()).mapQueryExecutor(), (String)"qryRess");
            String msg = "Map executor state is not cleared";
            for (Object result : map.values()) {
                Map m = (Map)U.field(result, (String)"res");
                IgniteCacheDistributedQueryDefaultTimeoutSelfTest.assertEquals((String)msg, (int)0, (int)m.size());
            }
        }
    }
}

