/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.config.GridTestProperties;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Ignore;
import org.junit.Test;

public class P2PCustomClassesAvailabilityTest
extends GridCommonAbstractTest {
    private static final ClassLoader CONFIGURATION_CLASS_LOADER;
    public static final String CACHE_NAME = "PUBLIC_CACHE";
    private static final String UNAVAILABLE_TO_SERVER_SQL_FUNCTIONS_CLASS_NAME = "org.apache.ignite.tests.p2p.cache.UnavailableToServerCustomSqlFunctionsClass";
    private ClassLoader clsLoader;
    private CacheConfiguration<?, ?> staticCacheCfg;

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setPeerClassLoadingEnabled(false);
        if (this.clsLoader != null) {
            cfg.setClassLoader(this.clsLoader);
        }
        if (this.staticCacheCfg != null) {
            cfg.setCacheConfiguration(new CacheConfiguration[]{this.staticCacheCfg});
        }
        return cfg;
    }

    @Test
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-36586")
    public void testSqlFunctionsClassAvailableOnCoordinatorOnly() throws Exception {
        this.clsLoader = CONFIGURATION_CLASS_LOADER;
        this.startGrid(0);
        this.clsLoader = null;
        this.startGrid(1);
        this.clsLoader = CONFIGURATION_CLASS_LOADER;
        this.staticCacheCfg = new CacheConfiguration(CACHE_NAME).setSqlSchema("PUBLIC").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class, Long.class).setTableName(CACHE_NAME))).setSqlFunctionClasses(new Class[]{CONFIGURATION_CLASS_LOADER.loadClass(UNAVAILABLE_TO_SERVER_SQL_FUNCTIONS_CLASS_NAME)});
        try {
            this.startClientGrid(2);
        }
        catch (Throwable t) {
            P2PCustomClassesAvailabilityTest.fail((String)("Unexpected exception was thrown: " + t));
        }
    }

    static {
        try {
            CONFIGURATION_CLASS_LOADER = new URLClassLoader(new URL[]{new URL(GridTestProperties.getProperty((String)"p2p.uri.cls"))}, P2PCustomClassesAvailabilityTest.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Define property p2p.uri.cls", e);
        }
    }
}

