/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.h2.sql.AbstractH2CompareQueryTest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.junit.Test;

public class IgniteCrossCachesJoinsQueryTest
extends AbstractH2CompareQueryTest {
    private static final String PERSON_CACHE_NAME = "person";
    private static final String ORG_CACHE_NAME = "org";
    private static final String ACC_CACHE_NAME = "acc";
    private static final int NODES = 5;
    private boolean client;
    private Data data;
    private String qry;
    private IgniteCache cache;
    private boolean distributedJoins;
    private static Random rnd;

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setClientMode(this.client);
        return cfg;
    }

    @Override
    protected void createCaches() {
    }

    @Override
    protected void beforeTestsStarted() throws Exception {
        long seed = System.currentTimeMillis();
        rnd = new Random(seed);
        log.info("Random seed: " + seed);
        this.startGridsMultiThreaded(4);
        this.client = true;
        this.startGrid(4);
        this.awaitPartitionMapExchange();
        conn = this.openH2Connection(false);
        this.initializeH2Schema();
    }

    @Override
    protected void initCacheAndDbData() throws SQLException {
        Statement st = conn.createStatement();
        String keyType = this.useCollocatedData() ? "other" : "int";
        st.execute("create table \"acc\".Account  (  _key " + keyType + " not null,  _val other not null,  id int unique,  personId int,  personDateId TIMESTAMP,  personStrId varchar(255)  )");
        st.execute("create table \"person\".Person  (  _key " + keyType + " not null,  _val other not null,  id int unique,  strId varchar(255) ,  dateId TIMESTAMP ,  orgId int,  orgDateId TIMESTAMP,  orgStrId varchar(255),   name varchar(255),   salary int  )");
        st.execute("create table \"org\".Organization  (  _key int not null,  _val other not null,  id int unique,  strId varchar(255) ,  dateId TIMESTAMP ,  name varchar(255)   )");
        conn.commit();
        st.close();
        for (Account account : this.data.accounts) {
            this.insertInDb(account);
        }
        for (Person person : this.data.persons) {
            this.insertInDb(person);
        }
        for (Organization org : this.data.orgs) {
            this.insertInDb(org);
        }
    }

    private void initCachesData() {
        IgniteCache accCache = this.ignite(0).cache(ACC_CACHE_NAME);
        for (Account account : this.data.accounts) {
            accCache.put(account.key(this.useCollocatedData()), (Object)account);
        }
        IgniteCache personCache = this.ignite(0).cache(PERSON_CACHE_NAME);
        for (Person person : this.data.persons) {
            personCache.put(person.key(this.useCollocatedData()), (Object)person);
        }
        IgniteCache igniteCache = this.ignite(0).cache(ORG_CACHE_NAME);
        for (Organization org : this.data.orgs) {
            igniteCache.put((Object)org.id, (Object)org);
        }
    }

    private void insertInDb(Account acc) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"acc\".Account (_key, _val, id, personId, personDateId, personStrId) values(?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, acc.key(this.useCollocatedData()));
            st.setObject(++i, acc);
            st.setObject(++i, acc.id);
            st.setObject(++i, acc.personId);
            st.setObject(++i, acc.personDateId);
            st.setObject(++i, acc.personStrId);
            st.executeUpdate();
        }
    }

    private void insertInDb(Person p) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"person\".Person (_key, _val, id, strId, dateId, name, orgId, orgDateId, orgStrId, salary) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, p.key(this.useCollocatedData()));
            st.setObject(++i, p);
            st.setObject(++i, p.id);
            st.setObject(++i, p.strId);
            st.setObject(++i, p.dateId);
            st.setObject(++i, p.name);
            st.setObject(++i, p.orgId);
            st.setObject(++i, p.orgDateId);
            st.setObject(++i, p.orgStrId);
            st.setObject(++i, p.salary);
            st.executeUpdate();
        }
    }

    private void insertInDb(Organization o) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"org\".Organization (_key, _val, id, strId, dateId, name) values(?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, o.id);
            st.setObject(++i, o);
            st.setObject(++i, o.id);
            st.setObject(++i, o.strId);
            st.setObject(++i, o.dateId);
            st.setObject(++i, o.name);
            st.executeUpdate();
        }
    }

    @Override
    protected void checkAllDataEquals() throws Exception {
        this.compareQueryRes0(this.ignite(0).cache(ACC_CACHE_NAME), "select _key, _val, id, personId, personDateId, personStrId from \"acc\".Account", new Object[0]);
        this.compareQueryRes0(this.ignite(0).cache(PERSON_CACHE_NAME), "select _key, _val, id, strId, dateId, name, orgId, orgDateId, orgStrId, salary from \"person\".Person", new Object[0]);
        this.compareQueryRes0(this.ignite(0).cache(ORG_CACHE_NAME), "select _key, _val, id, strId, dateId, name from \"org\".Organization", new Object[0]);
    }

    @Override
    protected Statement initializeH2Schema() throws SQLException {
        Statement st = conn.createStatement();
        for (String cacheName : new String[]{PERSON_CACHE_NAME, ACC_CACHE_NAME, ORG_CACHE_NAME}) {
            st.execute("CREATE SCHEMA \"" + cacheName + "\"");
        }
        return st;
    }

    protected long getTestTimeout() {
        return 1800000L;
    }

    protected boolean distributedJoins() {
        return this.distributedJoins;
    }

    private boolean useCollocatedData() {
        return !this.distributedJoins();
    }

    @Test
    public void testDistributedJoins1() throws Exception {
        this.distributedJoins = true;
        this.checkAllCacheCombinationsSet1(true);
    }

    @Test
    public void testDistributedJoins2() throws Exception {
        this.distributedJoins = true;
        this.checkAllCacheCombinationsSet2(true);
    }

    @Test
    public void testDistributedJoins3() throws Exception {
        this.distributedJoins = true;
        this.checkAllCacheCombinationsSet3(true);
    }

    @Test
    public void testCollocatedJoins1() throws Exception {
        this.distributedJoins = false;
        this.checkAllCacheCombinationsSet1(true);
    }

    @Test
    public void testCollocatedJoins2() throws Exception {
        this.distributedJoins = false;
        this.checkAllCacheCombinationsSet2(true);
    }

    @Test
    public void testCollocatedJoins3() throws Exception {
        this.distributedJoins = false;
        this.checkAllCacheCombinationsSet3(true);
    }

    private void checkAllCacheCombinationsSet1(boolean idx) throws Exception {
        List<List<TestCache>> types = this.cacheCombinations(TestCacheType.REPLICATED);
        this.checkAllCacheCombinations(idx, types);
    }

    private void checkAllCacheCombinationsSet2(boolean idx) throws Exception {
        List<List<TestCache>> types = this.cacheCombinations(TestCacheType.PARTITIONED_b0);
        this.checkAllCacheCombinations(idx, types);
    }

    private void checkAllCacheCombinationsSet3(boolean idx) throws Exception {
        List<List<TestCache>> types = this.cacheCombinations(TestCacheType.PARTITIONED_b1);
        this.checkAllCacheCombinations(idx, types);
    }

    private List<List<TestCache>> cacheCombinations(TestCacheType personType) {
        ArrayList<List<TestCache>> res = new ArrayList<List<TestCache>>();
        for (TestCacheType accCacheType : TestCacheType.values()) {
            for (TestCacheType orgCacheType : TestCacheType.values()) {
                ArrayList<TestCache> cacheTypes = new ArrayList<TestCache>(3);
                cacheTypes.add(new TestCache(PERSON_CACHE_NAME, personType));
                cacheTypes.add(new TestCache(ACC_CACHE_NAME, accCacheType));
                cacheTypes.add(new TestCache(ORG_CACHE_NAME, orgCacheType));
                res.add(cacheTypes);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllCacheCombinations(boolean idx, List<List<TestCache>> cacheList) throws Exception {
        block10: {
            this.data = this.prepareData();
            this.initCacheAndDbData();
            try {
                String[] errors = new LinkedHashMap();
                ArrayList<TestConfig> success = new ArrayList<TestConfig>();
                int cfgIdx = 0;
                for (List<TestCache> caches : cacheList) {
                    assert (caches.size() == 3) : caches;
                    TestCache personCache = caches.get(0);
                    TestCache accCache = caches.get(1);
                    TestCache orgCache = caches.get(2);
                    try {
                        this.check(idx, personCache, accCache, orgCache);
                        success.add(new TestConfig(cfgIdx, this.cache, personCache, accCache, orgCache, ""));
                    }
                    catch (Throwable e) {
                        this.error("", e);
                        errors.put(new TestConfig(cfgIdx, this.cache, personCache, accCache, orgCache, this.qry), e);
                    }
                    ++cfgIdx;
                }
                if (errors.isEmpty()) break block10;
                int total = cacheList.size();
                SB sb = new SB("Test failed for the following " + errors.size() + " combination(s) (" + total + " total):\n");
                for (Map.Entry e : errors.entrySet()) {
                    sb.a(e.getKey()).a(", error=").a(e.getValue()).a("\n");
                }
                sb.a("Successfully finished combinations:\n");
                for (TestConfig t : success) {
                    sb.a((Object)t).a("\n");
                }
                sb.a("The following data has beed used for test:\n " + this.data);
                IgniteCrossCachesJoinsQueryTest.fail((String)sb.toString());
            }
            catch (Throwable throwable) {
                for (String cacheName : new String[]{PERSON_CACHE_NAME, ACC_CACHE_NAME, ORG_CACHE_NAME}) {
                    this.ignite(0).destroyCache(cacheName);
                }
                Statement st = conn.createStatement();
                st.execute("drop table \"acc\".Account");
                st.execute("drop table \"person\".Person");
                st.execute("drop table \"org\".Organization");
                conn.commit();
                st.close();
                throw throwable;
            }
        }
        for (String cacheName : new String[]{PERSON_CACHE_NAME, ACC_CACHE_NAME, ORG_CACHE_NAME}) {
            this.ignite(0).destroyCache(cacheName);
        }
        Statement st = conn.createStatement();
        st.execute("drop table \"acc\".Account");
        st.execute("drop table \"person\".Person");
        st.execute("drop table \"org\".Organization");
        conn.commit();
        st.close();
    }

    private void check(boolean idx, TestCache personCacheType, TestCache accCacheType, TestCache orgCacheType) throws Exception {
        this.info("Checking cross cache joins [accCache=" + accCacheType + ", personCache=" + personCacheType + ", orgCache=" + orgCacheType + "]");
        List cacheTypes = F.asList((Object[])new TestCache[]{personCacheType, accCacheType, orgCacheType});
        for (TestCache cache : cacheTypes) {
            CacheConfiguration cc = this.cacheConfiguration(cache.cacheName, cache.type.cacheMode, cache.type.backups, idx, cache == accCacheType, cache == personCacheType, cache == orgCacheType);
            this.ignite(0).getOrCreateCache(cc);
            this.info("Created cache [name=" + cache.cacheName + ", mode=" + (Object)((Object)cache.type) + "]");
        }
        this.initCachesData();
        ArrayList<String> cacheNames = new ArrayList<String>();
        cacheNames.add(personCacheType.cacheName);
        cacheNames.add(orgCacheType.cacheName);
        cacheNames.add(accCacheType.cacheName);
        for (int i = 0; i < 5; ++i) {
            IgniteEx testNode = this.ignite(i);
            log.info("Test node [idx=" + i + ", isClient=" + testNode.configuration().isClientMode() + "]");
            for (String cacheName : cacheNames) {
                this.cache = testNode.cache(cacheName);
                log.info("Use cache: " + this.cache.getName());
                boolean distributeJoins0 = this.distributedJoins;
                if (this.replicated(this.cache)) {
                    boolean all3CachesAreReplicated;
                    boolean bl = all3CachesAreReplicated = this.replicated(this.ignite(0).cache(ACC_CACHE_NAME)) && this.replicated(this.ignite(0).cache(PERSON_CACHE_NAME)) && this.replicated(this.ignite(0).cache(ORG_CACHE_NAME));
                    if (distributeJoins0 && !all3CachesAreReplicated) continue;
                    this.distributedJoins = false;
                }
                if (!this.cache.getName().equals(orgCacheType.cacheName)) {
                    this.checkPersonAccountsJoin(this.cache, this.data.accountsPerPerson);
                }
                if (!this.cache.getName().equals(accCacheType.cacheName)) {
                    this.checkOrganizationPersonsJoin(this.cache);
                }
                this.checkOrganizationPersonAccountJoin(this.cache);
                this.checkUnion();
                this.checkUnionAll();
                if (!this.cache.getName().equals(orgCacheType.cacheName)) {
                    this.checkPersonAccountCrossJoin(this.cache);
                }
                if (!this.cache.getName().equals(accCacheType.cacheName)) {
                    this.checkPersonOrganizationGroupBy(this.cache);
                }
                if (!this.cache.getName().equals(orgCacheType.cacheName)) {
                    this.checkPersonAccountGroupBy(this.cache);
                }
                this.checkGroupBy();
                this.distributedJoins = distributeJoins0;
            }
        }
    }

    private boolean replicated(IgniteCache<?, ?> cache) {
        return ((CacheConfiguration)cache.getConfiguration(CacheConfiguration.class)).getCacheMode() == CacheMode.REPLICATED;
    }

    private Data prepareData() {
        HashMap<Integer, Integer> personsPerOrg = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> accountsPerPerson = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> accountsPerOrg = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> maxSalaryPerOrg = new HashMap<Integer, Integer>();
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        ArrayList<Person> persons = new ArrayList<Person>();
        ArrayList<Account> accounts = new ArrayList<Account>();
        int ORG_CNT = 10;
        int MAX_PERSONS_PER_ORG = 20;
        int MAX_ACCOUNTS_PER_PERSON = 10;
        for (int id = 0; id < 10; ++id) {
            orgs.add(new Organization(id, "org-" + id));
        }
        HashSet<Integer> personIds = new HashSet<Integer>();
        HashSet<Integer> accountIds = new HashSet<Integer>();
        for (int orgId = 0; orgId < 10; ++orgId) {
            int personsCnt = rnd.nextInt(20);
            int accsPerOrg = 0;
            int maxSalary = -1;
            for (int p = 0; p < personsCnt; ++p) {
                int personId = rnd.nextInt(10000) + 10;
                while (!personIds.add(personId)) {
                    personId = rnd.nextInt(10000) + 10;
                }
                String name = "person-" + personId;
                int salary = (rnd.nextInt(10) + 1) * 1000;
                if (salary > maxSalary) {
                    maxSalary = salary;
                }
                persons.add(new Person(personId, orgId, name, salary));
                int accountsCnt = rnd.nextInt(10);
                for (int a = 0; a < accountsCnt; ++a) {
                    int accountId = rnd.nextInt(100000) + 10000;
                    while (!accountIds.add(accountId)) {
                        accountId = rnd.nextInt(100000) + 10000;
                    }
                    accounts.add(new Account(accountId, personId, orgId));
                }
                accountsPerPerson.put(personId, accountsCnt);
                accsPerOrg += accountsCnt;
            }
            personsPerOrg.put(orgId, personsCnt);
            accountsPerOrg.put(orgId, accsPerOrg);
            maxSalaryPerOrg.put(orgId, maxSalary);
        }
        return new Data(orgs, persons, accounts, personsPerOrg, accountsPerPerson, accountsPerOrg, maxSalaryPerOrg);
    }

    private CacheConfiguration cacheConfiguration(String cacheName, CacheMode cacheMode, int backups, boolean idx, boolean accountCache, boolean personCache, boolean orgCache) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(cacheName);
        ccfg.setCacheMode(cacheMode);
        if (cacheMode == CacheMode.PARTITIONED) {
            ccfg.setBackups(backups);
        }
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ArrayList<QueryEntity> entities = new ArrayList<QueryEntity>();
        if (accountCache) {
            QueryEntity account = new QueryEntity();
            account.setKeyType(this.useCollocatedData() ? AffinityKey.class.getName() : Integer.class.getName());
            account.setValueType(Account.class.getName());
            account.addQueryField("id", Integer.class.getName(), null);
            account.addQueryField("personId", Integer.class.getName(), null);
            account.addQueryField("personDateId", Date.class.getName(), null);
            account.addQueryField("personStrId", String.class.getName(), null);
            if (idx) {
                account.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("id"), new QueryIndex("personId"), new QueryIndex("personDateId"), new QueryIndex("personStrId")}));
            }
            entities.add(account);
        }
        if (personCache) {
            QueryEntity person = new QueryEntity();
            person.setKeyType(this.useCollocatedData() ? AffinityKey.class.getName() : Integer.class.getName());
            person.setValueType(Person.class.getName());
            person.addQueryField("id", Integer.class.getName(), null);
            person.addQueryField("dateId", Date.class.getName(), null);
            person.addQueryField("strId", String.class.getName(), null);
            person.addQueryField("orgId", Integer.class.getName(), null);
            person.addQueryField("orgDateId", Date.class.getName(), null);
            person.addQueryField("orgStrId", String.class.getName(), null);
            person.addQueryField("name", String.class.getName(), null);
            person.addQueryField("salary", Integer.class.getName(), null);
            if (idx) {
                person.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("id"), new QueryIndex("dateId"), new QueryIndex("strId"), new QueryIndex("orgId"), new QueryIndex("orgDateId"), new QueryIndex("orgStrId"), new QueryIndex("name"), new QueryIndex("salary")}));
            }
            entities.add(person);
        }
        if (orgCache) {
            QueryEntity org = new QueryEntity();
            org.setKeyType(Integer.class.getName());
            org.setValueType(Organization.class.getName());
            org.addQueryField("id", Integer.class.getName(), null);
            org.addQueryField("dateId", Date.class.getName(), null);
            org.addQueryField("strId", String.class.getName(), null);
            org.addQueryField("name", String.class.getName(), null);
            if (idx) {
                org.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("id"), new QueryIndex("dateId"), new QueryIndex("strId"), new QueryIndex("name")}));
            }
            entities.add(org);
        }
        ccfg.setQueryEntities(entities);
        return ccfg;
    }

    private void checkOrganizationPersonsJoin(IgniteCache cache) {
        List res;
        if (this.skipQuery(cache, PERSON_CACHE_NAME, ORG_CACHE_NAME)) {
            return;
        }
        this.qry = "checkOrganizationPersonsJoin";
        SqlFieldsQuery qry = new SqlFieldsQuery("select o.name, p.name from \"org\".Organization o, \"person\".Person p where p.orgId = o._key and o._key=?");
        qry.setDistributedJoins(this.distributedJoins());
        SqlQuery qry2 = null;
        if (PERSON_CACHE_NAME.equals(cache.getName())) {
            qry2 = new SqlQuery(Person.class, "from \"org\".Organization, \"person\".Person where Person.orgId = Organization._key and Organization._key=?");
            qry2.setDistributedJoins(this.distributedJoins());
        }
        long total = 0L;
        for (int i = 0; i < this.data.personsPerOrg.size(); ++i) {
            qry.setArgs(new Object[]{i});
            if (qry2 != null) {
                qry2.setArgs(new Object[]{i});
            }
            res = cache.query(qry).getAll();
            IgniteCrossCachesJoinsQueryTest.assertEquals((int)this.data.personsPerOrg.get(i), (int)res.size());
            if (qry2 != null) {
                List res2 = cache.query((Query)qry2).getAll();
                IgniteCrossCachesJoinsQueryTest.assertEquals((int)this.data.personsPerOrg.get(i), (int)res2.size());
            }
            total += (long)res.size();
        }
        SqlFieldsQuery qry3 = new SqlFieldsQuery("select count(*) from \"org\".Organization o, \"person\".Person p where p.orgId = o._key");
        qry3.setDistributedJoins(this.distributedJoins());
        res = cache.query(qry3).getAll();
        IgniteCrossCachesJoinsQueryTest.assertEquals((int)1, (int)res.size());
        IgniteCrossCachesJoinsQueryTest.assertEquals((Object)total, ((List)res.get(0)).get(0));
    }

    private void checkPersonAccountsJoin(IgniteCache cache, Map<Integer, Integer> cnts) {
        if (this.skipQuery(cache, PERSON_CACHE_NAME, ACC_CACHE_NAME)) {
            return;
        }
        this.qry = "checkPersonAccountsJoin";
        ArrayList<Object> qrys = new ArrayList<Object>();
        qrys.add(new SqlFieldsQuery("select p.name from \"person\".Person p, \"acc\".Account a where p.id = a.personId and p.id=?"));
        qrys.add(new SqlFieldsQuery("select p.name from \"person\".Person p, \"acc\".Account a where p.dateId = a.personDateId and p.id=?"));
        qrys.add(new SqlFieldsQuery("select p.name from \"person\".Person p, \"acc\".Account a where p.strId = a.personStrId and p.id=?"));
        qrys.add(new SqlFieldsQuery("select p.name from \"person\".Person p, \"acc\".Account a where p.id = a.personId and p.id=?"));
        qrys.add(new SqlFieldsQuery("select p.name from \"person\".Person p, \"acc\".Account a where p.dateId = a.personDateId and p.id=?"));
        qrys.add(new SqlFieldsQuery("select p.name from \"person\".Person p, \"acc\".Account a where p.strId = a.personStrId and p.id=?"));
        if (PERSON_CACHE_NAME.equals(cache.getName())) {
            qrys.add(new SqlQuery(Person.class, "from \"person\".Person , \"acc\".Account  where Person.id = Account.personId and Person.id=?"));
            qrys.add(new SqlQuery(Person.class, "from \"person\".Person , \"acc\".Account  where Person.id = Account.personId and Person.id=?"));
        }
        ArrayList<Integer> keys = new ArrayList<Integer>(cnts.keySet());
        for (int i = 0; i < 10; ++i) {
            Integer key = (Integer)keys.get(rnd.nextInt(keys.size()));
            for (Query query : qrys) {
                if (query instanceof SqlFieldsQuery) {
                    ((SqlFieldsQuery)query).setDistributedJoins(this.distributedJoins());
                    ((SqlFieldsQuery)query).setArgs(new Object[]{key});
                } else {
                    ((SqlQuery)query).setDistributedJoins(this.distributedJoins());
                    ((SqlQuery)query).setArgs(new Object[]{key});
                }
                List res = cache.query(query).getAll();
                IgniteCrossCachesJoinsQueryTest.assertEquals((int)cnts.get(key), (int)res.size());
            }
        }
        qrys.clear();
        qrys.add(new SqlFieldsQuery("select count(*) from \"person\".Person p, \"acc\".Account a where p.id = a.personId"));
        qrys.add(new SqlFieldsQuery("select count(*) from \"person\".Person p, \"acc\".Account a where p.Dateid = a.personDateId"));
        qrys.add(new SqlFieldsQuery("select count(*) from \"person\".Person p, \"acc\".Account a where p.strId = a.personStrId"));
        qrys.add(new SqlFieldsQuery("select count(*) from \"person\".Person p, \"acc\".Account a where p.id = a.personId"));
        long total = 0L;
        for (Integer n : this.data.accountsPerPerson.values()) {
            total += (long)n.intValue();
        }
        for (Query query : qrys) {
            ((SqlFieldsQuery)query).setDistributedJoins(this.distributedJoins());
            List list = cache.query(query).getAll();
            IgniteCrossCachesJoinsQueryTest.assertEquals((int)1, (int)list.size());
            IgniteCrossCachesJoinsQueryTest.assertEquals((Object)total, ((List)list.get(0)).get(0));
        }
    }

    private void checkOrganizationPersonAccountJoin(IgniteCache cache) throws Exception {
        if (this.skipQuery(cache, PERSON_CACHE_NAME, ORG_CACHE_NAME, ACC_CACHE_NAME)) {
            return;
        }
        this.qry = "checkOrganizationPersonAccountJoin";
        ArrayList<String> sqlFields = new ArrayList<String>();
        sqlFields.add("select o.name, p.name, a._key from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o.id and p.id = a.personId and o.id = ?");
        sqlFields.add("select o.name, p.name, a._key from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgDateId = o.dateId and p.strId = a.personStrId and o.id = ?");
        sqlFields.add("select o.name, p.name, a._key from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgStrId = o.strId and p.id = a.personId and o.id = ?");
        for (Organization org : this.data.orgs) {
            for (String sql : sqlFields) {
                IgniteCrossCachesJoinsQueryTest.compareQueryRes0(cache, sql, this.distributedJoins(), new Object[]{org.id}, AbstractH2CompareQueryTest.Ordering.RANDOM);
            }
        }
        if (ACC_CACHE_NAME.equals(cache.getName())) {
            for (int orgId = 0; orgId < this.data.accountsPerOrg.size(); ++orgId) {
                SqlQuery q = new SqlQuery(Account.class, "from \"org\".Organization , \"person\".Person , \"acc\".Account  where Person.orgId = Organization.id and Person.id = Account.personId and Organization.id = ?");
                q.setDistributedJoins(this.distributedJoins());
                q.setArgs(new Object[]{orgId});
                List res = cache.query((Query)q).getAll();
                IgniteCrossCachesJoinsQueryTest.assertEquals((int)this.data.accountsPerOrg.get(orgId), (int)res.size());
            }
        }
        String sql = "select count(*) from \"org\".Organization o, \"person\".Person p, \"acc\".Account a where p.orgId = o.id and p.id = a.personId";
        IgniteCrossCachesJoinsQueryTest.compareQueryRes0(cache, sql, this.distributedJoins(), new Object[0], AbstractH2CompareQueryTest.Ordering.RANDOM);
    }

    private void checkUnionAll() throws Exception {
        if (this.skipQuery(this.cache, PERSON_CACHE_NAME, ACC_CACHE_NAME, ORG_CACHE_NAME)) {
            return;
        }
        this.qry = "checkUnionAll";
        String sql = "select a.id, p.name from \"person\".Person p, \"acc\".Account a where p.id = a.personId and p.id = ? union all select p.id, o.name from \"org\".Organization o, \"person\".Person p where p.orgStrId = o.strId and o.id = ?";
        for (int i = 0; i < 10; ++i) {
            Person person = this.data.persons.get(rnd.nextInt(this.data.persons.size()));
            for (Organization org : this.data.orgs) {
                IgniteCrossCachesJoinsQueryTest.compareQueryRes0(this.cache, sql, this.distributedJoins(), new Object[]{person.id, org.id}, AbstractH2CompareQueryTest.Ordering.RANDOM);
            }
        }
    }

    private void checkUnion() throws Exception {
        if (this.skipQuery(this.cache, PERSON_CACHE_NAME, ACC_CACHE_NAME, ORG_CACHE_NAME)) {
            return;
        }
        this.qry = "checkUnion";
        String sql = "select a.id, p.name from \"person\".Person p, \"acc\".Account a where p.id = a.personId and p.id = ? union select p.id, o.name from \"org\".Organization o, \"person\".Person p where p.orgStrId = o.strId and o.id = ?";
        for (int i = 0; i < 10; ++i) {
            Person person = this.data.persons.get(rnd.nextInt(this.data.persons.size()));
            for (Organization org : this.data.orgs) {
                IgniteCrossCachesJoinsQueryTest.compareQueryRes0(this.cache, sql, this.distributedJoins(), new Object[]{person.id, org.id}, AbstractH2CompareQueryTest.Ordering.RANDOM);
            }
        }
    }

    private void checkPersonAccountCrossJoin(IgniteCache cache) throws Exception {
        if (this.skipQuery(cache, PERSON_CACHE_NAME, ACC_CACHE_NAME)) {
            return;
        }
        this.qry = "checkPersonAccountCrossJoin";
        String sql = "select p.name from \"person\".Person p cross join \"acc\".Account a";
        IgniteCrossCachesJoinsQueryTest.compareQueryRes0(cache, sql, this.distributedJoins(), new Object[0], AbstractH2CompareQueryTest.Ordering.RANDOM);
    }

    private void checkPersonOrganizationGroupBy(IgniteCache cache) {
        if (this.skipQuery(cache, PERSON_CACHE_NAME, ORG_CACHE_NAME)) {
            return;
        }
        this.qry = "checkPersonOrganizationGroupBy";
        SqlFieldsQuery q = new SqlFieldsQuery("select max(p.salary) from \"person\".Person p join \"org\".Organization o on p.orgId = o.id where o.id = ?group by o.name ");
        q.setDistributedJoins(this.distributedJoins());
        for (Map.Entry<Integer, Integer> e : this.data.maxSalaryPerOrg.entrySet()) {
            Integer orgId = e.getKey();
            Integer maxSalary = e.getValue();
            q.setArgs(new Object[]{orgId});
            List res = cache.query(q).getAll();
            String errMsg = "Expected data [orgId=" + orgId + ", maxSalary=" + maxSalary + ", data=" + this.data + "]";
            if (maxSalary > 0) {
                IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (int)1, (int)res.size());
                IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (int)1, (int)((List)res.get(0)).size());
                IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (Object)maxSalary, ((List)res.get(0)).get(0));
                continue;
            }
            IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (int)0, (int)res.size());
        }
    }

    private void checkPersonAccountGroupBy(IgniteCache cache) {
        if (this.skipQuery(cache, PERSON_CACHE_NAME, ACC_CACHE_NAME)) {
            return;
        }
        this.qry = "checkPersonAccountGroupBy";
        SqlFieldsQuery q = new SqlFieldsQuery("select count(a.id) from \"person\".Person p join \"acc\".Account a on p.strId = a.personStrId where p.id = ?group by p.name");
        q.setDistributedJoins(this.distributedJoins());
        ArrayList<Integer> keys = new ArrayList<Integer>(this.data.accountsPerPerson.keySet());
        for (int i = 0; i < 10; ++i) {
            Integer personId = (Integer)keys.get(rnd.nextInt(keys.size()));
            Integer cnt = this.data.accountsPerPerson.get(personId);
            q.setArgs(new Object[]{personId});
            List res = cache.query(q).getAll();
            String errMsg = "Expected data [personId=" + personId + ", cnt=" + cnt + ", data=" + this.data + "]";
            if (cnt > 0) {
                IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (int)1, (int)res.size());
                IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (int)1, (int)((List)res.get(0)).size());
                IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (Object)cnt, ((List)res.get(0)).get(0));
                continue;
            }
            IgniteCrossCachesJoinsQueryTest.assertEquals((String)errMsg, (int)0, (int)res.size());
        }
    }

    private void checkGroupBy() throws Exception {
        if (this.skipQuery(this.cache, PERSON_CACHE_NAME, ACC_CACHE_NAME, ORG_CACHE_NAME)) {
            return;
        }
        this.qry = "checkGroupBy";
        String sql = "select p.id, count(a.id) from \"person\".Person p, \"org\".Organization o, \"acc\".Account a where p.id = a.personId and p.orgStrId = o.strId and o.id = ? group by p.id";
        for (Organization org : this.data.orgs) {
            IgniteCrossCachesJoinsQueryTest.compareQueryRes0(this.cache, sql, this.distributedJoins(), new Object[]{org.id}, AbstractH2CompareQueryTest.Ordering.RANDOM);
        }
    }

    private boolean skipQuery(IgniteCache cache, String ... caches) {
        Ignite node = (Ignite)cache.unwrap(Ignite.class);
        if (!this.distributedJoins() && this.replicated(cache)) {
            for (String cacheName : caches) {
                if (this.replicated(node.cache(cacheName))) continue;
                return true;
            }
        }
        return false;
    }

    private static class TestConfig {
        private final int idx;
        private final IgniteCache testedCache;
        private final TestCache personCache;
        private final TestCache accCache;
        private final TestCache orgCache;
        private final String qry;

        TestConfig(int cfgIdx, IgniteCache testedCache, TestCache personCacheType, TestCache accCacheType, TestCache orgCacheType, String testedQry) {
            this.idx = cfgIdx;
            this.testedCache = testedCache;
            this.personCache = personCacheType;
            this.accCache = accCacheType;
            this.orgCache = orgCacheType;
            this.qry = testedQry;
        }

        public String toString() {
            return "TestConfig [idx=" + this.idx + ", testedCache=" + this.testedCache.getName() + ", personCache=" + this.personCache + ", accCache=" + this.accCache + ", orgCache=" + this.orgCache + ", qry=" + this.qry + ']';
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        int id;
        @QuerySqlField
        Date dateId;
        @QuerySqlField
        String strId;
        @QuerySqlField
        String name;

        Organization(int id, String name) {
            this.id = id;
            this.dateId = new Date(id);
            this.strId = "orgId" + id;
            this.name = name;
        }

        public String toString() {
            return "Organization [name='" + this.name + '\'' + ", id=" + this.id + ']';
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        int id;
        @QuerySqlField
        Date dateId;
        @QuerySqlField
        String strId;
        @QuerySqlField
        int orgId;
        @QuerySqlField
        Date orgDateId;
        @QuerySqlField
        String orgStrId;
        @QuerySqlField
        String name;
        @QuerySqlField
        int salary;

        Person(int id, int orgId, String name, int salary) {
            this.id = id;
            this.dateId = new Date(id);
            this.strId = "personId" + id;
            this.orgId = orgId;
            this.orgDateId = new Date(orgId);
            this.orgStrId = "orgId" + orgId;
            this.name = name;
            this.salary = salary;
        }

        public Object key(boolean useCollocatedData) {
            return useCollocatedData ? new AffinityKey((Object)this.id, (Object)this.orgId) : Integer.valueOf(this.id);
        }

        public String toString() {
            return "Person [id=" + this.id + ", orgId=" + this.orgId + ", name='" + this.name + '\'' + ", salary=" + this.salary + ']';
        }
    }

    private static class Account
    implements Serializable {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private int personId;
        @QuerySqlField
        private Date personDateId;
        @QuerySqlField
        private String personStrId;
        @QuerySqlField
        private int orgId;

        Account(int id, int personId, int orgId) {
            this.id = id;
            this.personId = personId;
            this.orgId = orgId;
            this.personDateId = new Date(personId);
            this.personStrId = "personId" + personId;
        }

        public Object key(boolean useCollocatedData) {
            return useCollocatedData ? new AffinityKey((Object)this.id, (Object)this.orgId) : Integer.valueOf(this.id);
        }

        public String toString() {
            return "Account [id=" + this.id + ", personId=" + this.personId + ']';
        }
    }

    private static class Data {
        final List<Organization> orgs;
        final List<Person> persons;
        final List<Account> accounts;
        final Map<Integer, Integer> personsPerOrg;
        final Map<Integer, Integer> accountsPerPerson;
        final Map<Integer, Integer> accountsPerOrg;
        final Map<Integer, Integer> maxSalaryPerOrg;

        Data(List<Organization> orgs, List<Person> persons, List<Account> accounts, Map<Integer, Integer> personsPerOrg, Map<Integer, Integer> accountsPerPerson, Map<Integer, Integer> accountsPerOrg, Map<Integer, Integer> maxSalaryPerOrg) {
            this.orgs = orgs;
            this.persons = persons;
            this.accounts = accounts;
            this.personsPerOrg = personsPerOrg;
            this.accountsPerPerson = accountsPerPerson;
            this.accountsPerOrg = accountsPerOrg;
            this.maxSalaryPerOrg = maxSalaryPerOrg;
        }

        public String toString() {
            return "Data [orgs=" + this.orgs + ", persons=" + this.persons + ", accounts=" + this.accounts + ", personsPerOrg=" + this.personsPerOrg + ", accountsPerPerson=" + this.accountsPerPerson + ", accountsPerOrg=" + this.accountsPerOrg + ", maxSalaryPerOrg=" + this.maxSalaryPerOrg + ']';
        }
    }

    private static class TestCache {
        @GridToStringInclude
        final String cacheName;
        @GridToStringInclude
        final TestCacheType type;

        public TestCache(String cacheName, TestCacheType type) {
            this.cacheName = cacheName;
            this.type = type;
        }

        public String toString() {
            return S.toString(TestCache.class, (Object)this);
        }
    }

    private static enum TestCacheType {
        REPLICATED(CacheMode.REPLICATED, 0),
        PARTITIONED_b0(CacheMode.PARTITIONED, 0),
        PARTITIONED_b1(CacheMode.PARTITIONED, 1);

        final CacheMode cacheMode;
        final int backups;

        private TestCacheType(CacheMode mode, int backups) {
            this.cacheMode = mode;
            this.backups = backups;
        }
    }
}

