/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractSqlDmlQuerySelfTest;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteCacheUpdateSqlQuerySelfTest
extends IgniteCacheAbstractSqlDmlQuerySelfTest {
    @Override
    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.ignite(0).createCache(IgniteCacheUpdateSqlQuerySelfTest.createAllTypesCacheConfig());
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.ignite(0).cache("L2AT").clear();
    }

    private static CacheConfiguration createAllTypesCacheConfig() {
        CacheConfiguration ccfg = IgniteCacheUpdateSqlQuerySelfTest.cacheConfig("L2AT", true, true);
        ccfg.setIndexedTypes(new Class[]{Long.class, AllTypes.class});
        return ccfg;
    }

    @Test
    public void testUpdateSimple() {
        IgniteCache p = this.cache();
        FieldsQueryCursor c = p.query(new SqlFieldsQuery("update Person p set p.id = p.id * 2, p.firstName = substring(p.firstName, 0, 2) where length(p._key) = ? or p.secondName like ?").setArgs(new Object[]{2, "%ite"}));
        c.iterator();
        c = p.query(new SqlFieldsQuery("select _key, _val, * from Person order by _key, id"));
        List leftovers = c.getAll();
        IgniteCacheUpdateSqlQuerySelfTest.assertEquals((int)4, (int)leftovers.size());
        IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("FirstKey", this.createPerson(2, "Jo", "White"), 2, "Jo", "White"), (Collection)((Collection)leftovers.get(0)));
        IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("SecondKey", this.createPerson(2, "Joe", "Black"), 2, "Joe", "Black"), (Collection)((Collection)leftovers.get(1)));
        IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("f0u4thk3y", this.createPerson(4, "Jane", "Silver"), 4, "Jane", "Silver"), (Collection)((Collection)leftovers.get(2)));
        IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("k3", this.createPerson(6, "Sy", "Green"), 6, "Sy", "Green"), (Collection)((Collection)leftovers.get(3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateSingle() {
        boolean oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        try {
            IgniteCache p = this.cache();
            FieldsQueryCursor c = p.query(new SqlFieldsQuery("update Person p set _val = ? where _key = ?").setArgs(new Object[]{this.createPerson(2, "Jo", "White"), "FirstKey"}));
            c.iterator();
            c = p.query(new SqlFieldsQuery("select _key, _val, * from Person order by id, _key"));
            List leftovers = c.getAll();
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((int)4, (int)leftovers.size());
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("FirstKey", this.createPerson(2, "Jo", "White"), 2, "Jo", "White"), (Collection)((Collection)leftovers.get(0)));
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("SecondKey", this.createPerson(2, "Joe", "Black"), 2, "Joe", "Black"), (Collection)((Collection)leftovers.get(1)));
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("k3", this.createPerson(3, "Sylvia", "Green"), 3, "Sylvia", "Green"), (Collection)((Collection)leftovers.get(2)));
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(Arrays.asList("f0u4thk3y", this.createPerson(4, "Jane", "Silver"), 4, "Jane", "Silver"), (Collection)((Collection)leftovers.get(3)));
        }
        finally {
            GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)oldAllowColumnsVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedFieldsUpdate() {
        boolean oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        try {
            IgniteCache p = this.ignite(0).cache("L2AT");
            long ROOT_KEY = 1L;
            AllTypes rootVal = new AllTypes(1L);
            rootVal.innerTypeCol = new AllTypes.InnerType(42L);
            p.query(new SqlFieldsQuery("INSERT INTO \"AllTypes\"(_key,_val) VALUES (?, ?)").setArgs(new Object[]{1L, rootVal})).getAll();
            p.query(new SqlFieldsQuery("UPDATE \"AllTypes\" SET \"innerLongCol\" = ?, \"innerStrCol\" = ?, \"arrListCol\" = ?;").setArgs(new Object[]{50L, "sss", new ArrayList<Long>(Arrays.asList(3L, 2L, 1L))})).getAll();
            AllTypes res = (AllTypes)p.get((Object)1L);
            AllTypes.InnerType resInner = new AllTypes.InnerType(50L);
            resInner.innerStrCol = "sss";
            resInner.arrListCol = new ArrayList<Long>(Arrays.asList(3L, 2L, 1L));
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)resInner, (Object)res.innerTypeCol);
        }
        finally {
            GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)oldAllowColumnsVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypeConversions() throws ParseException {
        boolean oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        try {
            IgniteCache cache = this.ignite(0).cache("L2AT");
            cache.query(new SqlFieldsQuery("INSERT INTO \"AllTypes\" (_key, _val) VALUES(2, ?)").setArgs(new Object[]{new AllTypes(2L)})).getAll();
            cache.query(new SqlFieldsQuery("UPDATE \"AllTypes\" SET \"dateCol\" = '2016-11-30 12:00:00', \"booleanCol\" = false, \"tsCol\" = DATE '2016-12-01' WHERE _key = 2"));
            cache.query(new SqlFieldsQuery("UPDATE \"AllTypes\" SET \"innerLongCol\" = ?, \"doubleCol\" = CAST('50' as INT), \"booleanCol\" = 80, \"innerTypeCol\" = ?, \"strCol\" = PI(), \"shortCol\" = CAST(WEEK(PARSEDATETIME('2016-11-30', 'yyyy-MM-dd')) as VARCHAR), \"sqlDateCol\"=TIMESTAMP '2016-12-02 13:47:00', \"tsCol\"=TIMESTAMPADD('MI', 2, DATEADD('DAY', 2, \"tsCol\")), \"primitiveIntsCol\" = ?, \"bytesCol\" = ?").setArgs(new Object[]{5, new AllTypes.InnerType(80L), new int[]{2, 3}, new Byte[]{(byte)4, (byte)5, (byte)6}})).getAll();
            AllTypes res = (AllTypes)cache.get((Object)2L);
            IgniteCacheUpdateSqlQuerySelfTest.assertNotNull((Object)res);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((double)new BigDecimal(301.0).doubleValue(), (double)res.bigDecimalCol.doubleValue());
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((double)50.0, (double)res.doubleCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((long)2L, (long)res.longCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)res.booleanCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((String)"3.141592653589793", (String)res.strCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.equals(new byte[]{0, 1}, res.primitiveBytesCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.equals((Object[])new Byte[]{(byte)4, (byte)5, (byte)6}, (Object[])res.bytesCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.deepEquals(new Integer[]{0, 1}, res.intsCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.equals(new int[]{2, 3}, res.primitiveIntsCol));
            AllTypes.InnerType expInnerType = new AllTypes.InnerType(80L);
            expInnerType.innerLongCol = 5L;
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)expInnerType, (Object)res.innerTypeCol);
            DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            Instant expectedInstant = timestampFormat.withZone(ZoneId.systemDefault()).parse((CharSequence)"2016-11-30 12:00:00", Instant::from);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)java.util.Date.from(expectedInstant), (Object)res.dateCol);
            LocalDateTime expectedDateTime = LocalDateTime.parse("2016-12-03 00:02:00", timestampFormat);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)Timestamp.valueOf(expectedDateTime), (Object)res.tsCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((int)2, (int)res.intCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)((Object)AllTypes.EnumType.ENUMTRUE), (Object)((Object)res.enumCol));
            LocalDate expectedDate = LocalDate.parse("2016-12-02", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)Date.valueOf(expectedDate), (Object)res.sqlDateCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((int)49, (int)res.shortCol);
        }
        finally {
            GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)oldAllowColumnsVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleInnerFieldUpdate() throws ParseException {
        boolean oldAllowColumnsVal = (Boolean)GridTestUtils.getFieldValue(UpdatePlanBuilder.class, UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES");
        GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)true);
        try {
            IgniteCache cache = this.ignite(0).cache("L2AT");
            cache.query(new SqlFieldsQuery("insert into \"AllTypes\" (_key, _val) values(2, ?)").setArgs(new Object[]{new AllTypes(2L)})).getAll();
            cache.query(new SqlFieldsQuery("UPDATE \"AllTypes\" SET \"dateCol\" = '2016-11-30 12:00:00', \"booleanCol\" = false WHERE _key = 2")).getAll();
            IgniteCacheUpdateSqlQuerySelfTest.assertFalse((boolean)cache.query(new SqlFieldsQuery("select * from \"AllTypes\"")).getAll().isEmpty());
            cache.query(new SqlFieldsQuery("update \"AllTypes\" set \"innerLongCol\" = 5"));
            AllTypes res = (AllTypes)cache.get((Object)2L);
            IgniteCacheUpdateSqlQuerySelfTest.assertNotNull((Object)res);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((double)new BigDecimal(301.0).doubleValue(), (double)res.bigDecimalCol.doubleValue());
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((double)3.01, (double)res.doubleCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((long)2L, (long)res.longCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertFalse((boolean)res.booleanCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((String)"2", (String)res.strCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.equals(new byte[]{0, 1}, res.primitiveBytesCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.deepEquals(new Byte[]{(byte)0, (byte)1}, res.bytesCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.deepEquals(new Integer[]{0, 1}, res.intsCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertTrue((boolean)Arrays.equals(new int[]{0, 1}, res.primitiveIntsCol));
            AllTypes.InnerType expInnerType = new AllTypes.InnerType(2L);
            expInnerType.innerLongCol = 5L;
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)expInnerType, (Object)res.innerTypeCol);
            Instant expectedDate = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()).parse((CharSequence)"2016-11-30 12:00:00", Instant::from);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)java.util.Date.from(expectedDate), (Object)res.dateCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertNull((Object)res.tsCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((int)2, (int)res.intCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((Object)((Object)AllTypes.EnumType.ENUMTRUE), (Object)((Object)res.enumCol));
            IgniteCacheUpdateSqlQuerySelfTest.assertNull((Object)res.sqlDateCol);
            IgniteCacheUpdateSqlQuerySelfTest.assertEquals((int)-23000, (int)res.shortCol);
        }
        finally {
            GridTestUtils.setFieldValue(UpdatePlanBuilder.class, (String)"ALLOW_KEY_VAL_UPDATES", (Object)oldAllowColumnsVal);
        }
    }

    private void dropAndCreateParamsTables() {
        this.execute(new SqlFieldsQuery("DROP TABLE IF EXISTS PARAMS"));
        this.execute(new SqlFieldsQuery("DROP TABLE IF EXISTS CONST_TAB"));
        this.execute(new SqlFieldsQuery("CREATE TABLE PARAMS(ID INT PRIMARY KEY, VAL1 INT, VAL2 INT) WITH \"template=replicated\""));
        this.execute(new SqlFieldsQuery("INSERT INTO PARAMS VALUES (1, 2, 3), (2, 3, 4), (3, 2, 1), (4, 2, 1)"));
        this.execute(new SqlFieldsQuery("CREATE TABLE CONST_TAB(ID INT PRIMARY KEY, VAL INT) WITH \"template=replicated\""));
        this.execute(new SqlFieldsQuery("INSERT INTO CONST_TAB VALUES (42, 2)"));
    }

    @Test
    public void testUpdateParameters() {
        Arrays.asList(true, false).forEach(loc -> {
            this.dropAndCreateParamsTables();
            this.execute(new SqlFieldsQuery("UPDATE PARAMS SET VAL1 = ?, VAL2 = ? WHERE ID = ?").setArgs(new Object[]{1, 2, 3}).setLocal(loc.booleanValue()));
            List<List<?>> tab = this.execute(new SqlFieldsQuery("SELECT * FROM PARAMS ORDER BY ID"));
            List<List> exp = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(2, 3, 4), Arrays.asList(3, 1, 2), Arrays.asList(4, 2, 1));
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(exp, tab);
        });
    }

    @Test
    public void testUpdateParametersWithIndexes() {
        Arrays.asList(true, false).forEach(loc -> {
            this.dropAndCreateParamsTables();
            this.execute(new SqlFieldsQuery("UPDATE PARAMS SET VAL1 = ?3, VAL2 = ?2 WHERE ID = ?1").setArgs(new Object[]{1, 2, 3}).setLocal(loc.booleanValue()));
            List<List<?>> tab = this.execute(new SqlFieldsQuery("SELECT * FROM PARAMS ORDER BY ID"));
            List<List> exp = Arrays.asList(Arrays.asList(1, 3, 2), Arrays.asList(2, 3, 4), Arrays.asList(3, 2, 1), Arrays.asList(4, 2, 1));
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(exp, tab);
        });
    }

    @Test
    public void testUpdateParametersWithSubQuery() {
        Arrays.asList(true, false).forEach(loc -> {
            this.dropAndCreateParamsTables();
            this.execute(new SqlFieldsQuery("UPDATE PARAMS SET VAL1 = ?, VAL2 = ( SELECT ID FROM CONST_TAB WHERE VAL = ? ) WHERE ID = ?").setArgs(new Object[]{1, 2, 3}).setLocal(loc.booleanValue()));
            List<List<?>> tab = this.execute(new SqlFieldsQuery("SELECT * FROM PARAMS ORDER BY ID"));
            List<List> exp = Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(2, 3, 4), Arrays.asList(3, 1, 42), Arrays.asList(4, 2, 1));
            IgniteCacheUpdateSqlQuerySelfTest.assertEqualsCollections(exp, tab);
        });
    }

    private List<List<?>> execute(SqlFieldsQuery qry) {
        return this.ignite(0).cache("L2AT").query(qry.setSchema("PUBLIC")).getAll();
    }

    public static final class AllTypes
    implements Serializable {
        @QuerySqlField
        Long longCol;
        @QuerySqlField
        double doubleCol;
        @QuerySqlField
        String strCol;
        @QuerySqlField
        boolean booleanCol;
        @QuerySqlField
        java.util.Date dateCol;
        @QuerySqlField
        Date sqlDateCol;
        @QuerySqlField
        Timestamp tsCol;
        @QuerySqlField
        int intCol;
        @QuerySqlField
        BigDecimal bigDecimalCol;
        @QuerySqlField
        Byte[] bytesCol;
        @QuerySqlField
        byte[] primitiveBytesCol;
        @QuerySqlField
        Integer[] intsCol;
        @QuerySqlField
        int[] primitiveIntsCol;
        @QuerySqlField
        short shortCol;
        @QuerySqlField
        InnerType innerTypeCol;
        @QuerySqlField
        EnumType enumCol;

        private void init(Long key, String str) {
            this.longCol = key;
            this.doubleCol = Math.round(1000.0 * Math.log10(this.longCol.doubleValue()));
            this.bigDecimalCol = BigDecimal.valueOf(this.doubleCol);
            this.doubleCol /= 100.0;
            this.strCol = str;
            if (key % 2L == 0L) {
                this.booleanCol = true;
                this.enumCol = EnumType.ENUMTRUE;
                this.innerTypeCol = new InnerType(key);
            } else {
                this.booleanCol = false;
                this.enumCol = EnumType.ENUMFALSE;
                this.innerTypeCol = null;
            }
            this.intCol = key.intValue();
            this.bytesCol = new Byte[(int)(key % 10L)];
            this.intsCol = new Integer[(int)(key % 10L)];
            this.primitiveBytesCol = new byte[(int)(key % 10L)];
            this.primitiveIntsCol = new int[(int)(key % 10L)];
            int b = 0;
            for (int j = 0; j < this.bytesCol.length; ++j) {
                if (b == 256) {
                    b = 0;
                }
                this.bytesCol[j] = (byte)b;
                this.primitiveBytesCol[j] = (byte)b;
                this.intsCol[j] = b;
                this.primitiveIntsCol[j] = b++;
            }
            this.shortCol = (short)(1000L * key % 50000L - 25000L);
            this.dateCol = new java.util.Date();
        }

        public AllTypes(Long key) {
            this.init(key, Long.toString(key));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTypes allTypes = (AllTypes)o;
            if (Double.compare(allTypes.doubleCol, this.doubleCol) != 0) {
                return false;
            }
            if (this.booleanCol != allTypes.booleanCol) {
                return false;
            }
            if (this.intCol != allTypes.intCol) {
                return false;
            }
            if (this.shortCol != allTypes.shortCol) {
                return false;
            }
            if (this.longCol != null ? !this.longCol.equals(allTypes.longCol) : allTypes.longCol != null) {
                return false;
            }
            if (this.strCol != null ? !this.strCol.equals(allTypes.strCol) : allTypes.strCol != null) {
                return false;
            }
            if (this.dateCol != null ? !this.dateCol.equals(allTypes.dateCol) : allTypes.dateCol != null) {
                return false;
            }
            if (this.sqlDateCol != null ? !this.sqlDateCol.equals(allTypes.sqlDateCol) : allTypes.sqlDateCol != null) {
                return false;
            }
            if (this.tsCol != null ? !this.tsCol.equals(allTypes.tsCol) : allTypes.tsCol != null) {
                return false;
            }
            if (this.bigDecimalCol != null ? !this.bigDecimalCol.equals(allTypes.bigDecimalCol) : allTypes.bigDecimalCol != null) {
                return false;
            }
            if (!Arrays.equals((Object[])this.bytesCol, (Object[])allTypes.bytesCol)) {
                return false;
            }
            if (this.innerTypeCol != null ? !this.innerTypeCol.equals(allTypes.innerTypeCol) : allTypes.innerTypeCol != null) {
                return false;
            }
            return this.enumCol == allTypes.enumCol;
        }

        public int hashCode() {
            int res = this.longCol != null ? this.longCol.hashCode() : 0;
            long temp = Double.doubleToLongBits(this.doubleCol);
            res = 31 * res + (int)(temp ^ temp >>> 32);
            res = 31 * res + (this.strCol != null ? this.strCol.hashCode() : 0);
            res = 31 * res + (this.booleanCol ? 1 : 0);
            res = 31 * res + (this.dateCol != null ? this.dateCol.hashCode() : 0);
            res = 31 * res + (this.sqlDateCol != null ? this.sqlDateCol.hashCode() : 0);
            res = 31 * res + (this.tsCol != null ? this.tsCol.hashCode() : 0);
            res = 31 * res + this.intCol;
            res = 31 * res + (this.bigDecimalCol != null ? this.bigDecimalCol.hashCode() : 0);
            res = 31 * res + Arrays.hashCode((Object[])this.bytesCol);
            res = 31 * res + this.shortCol;
            res = 31 * res + (this.innerTypeCol != null ? this.innerTypeCol.hashCode() : 0);
            res = 31 * res + (this.enumCol != null ? this.enumCol.hashCode() : 0);
            return res;
        }

        static enum EnumType {
            ENUMTRUE,
            ENUMFALSE;

        }

        static class InnerType
        implements Serializable {
            @QuerySqlField
            Long innerLongCol;
            @QuerySqlField
            String innerStrCol;
            @QuerySqlField
            ArrayList<Long> arrListCol = new ArrayList();

            InnerType(Long key) {
                this.innerLongCol = key;
                this.innerStrCol = Long.toString(key);
                Long m = key % 8L;
                Integer i = 0;
                while ((long)i.intValue() < m) {
                    this.arrListCol.add(key + (long)i.intValue());
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }

            public String toString() {
                return "[Long=" + Long.toString(this.innerLongCol) + ", String='" + this.innerStrCol + "', ArrayList=" + this.arrListCol.toString() + "]";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                InnerType innerType = (InnerType)o;
                if (this.innerLongCol != null ? !this.innerLongCol.equals(innerType.innerLongCol) : innerType.innerLongCol != null) {
                    return false;
                }
                if (this.innerStrCol != null ? !this.innerStrCol.equals(innerType.innerStrCol) : innerType.innerStrCol != null) {
                    return false;
                }
                return this.arrListCol != null ? this.arrListCol.equals(innerType.arrListCol) : innerType.arrListCol == null;
            }

            public int hashCode() {
                int res = this.innerLongCol != null ? this.innerLongCol.hashCode() : 0;
                res = 31 * res + (this.innerStrCol != null ? this.innerStrCol.hashCode() : 0);
                res = 31 * res + (this.arrListCol != null ? this.arrListCol.hashCode() : 0);
                return res;
            }
        }
    }
}

