/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.GridCacheAbstractSelfTest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class IgniteCacheStarvationOnRebalanceTest
extends GridCacheAbstractSelfTest {
    private static final int GRID_CNT = 4;
    private static final int IGNITE_THREAD_POOL_SIZE = 5;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSystemThreadPoolSize(5);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        return cfg;
    }

    protected Class<?>[] indexedTypes() {
        return new Class[]{Integer.class, CacheValue.class};
    }

    protected CacheAtomicityMode atomicityMode() {
        return CacheAtomicityMode.ATOMIC;
    }

    protected int gridCount() {
        return 4;
    }

    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadSystemWithPutAndStartRebalancing() throws Exception {
        final IgniteCache cache = this.grid(0).cache("default");
        final long endTime = System.currentTimeMillis() + (long)GridTestUtils.SF.applyLB((int)((int)this.getTestTimeout() - 60000), (int)5000);
        int iter = 0;
        while (System.currentTimeMillis() < endTime) {
            this.info("Iteration: " + iter++);
            final AtomicBoolean stop = new AtomicBoolean();
            IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    while (!stop.get() && System.currentTimeMillis() < endTime) {
                        int key = rnd.nextInt(100000);
                        cache.put((Object)key, (Object)new CacheValue(key));
                    }
                    return null;
                }
            }, (int)20, (String)"put-thread");
            try {
                Thread.sleep(500L);
                this.info("Initial set of keys is loaded.");
                this.info("Starting new node...");
                this.startGrid(5);
                this.info("New node is started.");
                Thread.sleep(500L);
            }
            finally {
                stop.set(true);
            }
            fut.get();
            this.stopGrid(5);
        }
    }

    private static class CacheValue {
        @QuerySqlField(index=true)
        private final int val;

        CacheValue(int val) {
            this.val = val;
        }

        int value() {
            return this.val;
        }

        public String toString() {
            return S.toString(CacheValue.class, (Object)this);
        }
    }
}

