/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.time.Instant;
import java.time.Period;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IgniteCacheSqlQueryUnsupportedTypeSelfTest
extends GridCommonAbstractTest {
    @Before
    public void setupCluster() throws Exception {
        this.startGrids(1);
    }

    @After
    public void tearOff() {
        this.stopAllGrids();
    }

    private List<List<?>> execute(String sql, Object ... args) {
        return this.grid(0).cache("CACHE").query(new SqlFieldsQuery(sql).setSchema("PUBLIC").setArgs(args)).getAll();
    }

    private CacheConfiguration instantCacheConfiguration() {
        return new CacheConfiguration().setName("CACHE").setQueryEntities(Collections.singleton(new QueryEntity(Integer.class.getName(), Person.class.getName()).addQueryField("id", Integer.class.getName(), null).addQueryField("time", Instant.class.getName(), null).setTableName("PERSON").setIndexes(Arrays.asList(new QueryIndex("id", true), new QueryIndex("time", true)))));
    }

    @Test
    public void testUnsupportedSqlType() {
        try (IgniteCache person = this.grid(0).createCache(this.instantCacheConfiguration());){
            Person p1 = new Person(1, Instant.now());
            Person p2 = new Person(2, p1.time.minus(Period.ofDays(1)));
            person.put((Object)1, (Object)p1);
            person.put((Object)2, (Object)p2);
            List<List<?>> res = this.execute("SELECT * FROM CACHE.PERSON WHERE time = (select time from cache.person where id = 1)", new Object[0]);
            IgniteCacheSqlQueryUnsupportedTypeSelfTest.assertEquals((Object)1, res.get(0).get(0));
            res = this.execute("SELECT * FROM CACHE.PERSON WHERE time = ?", p2.time);
            IgniteCacheSqlQueryUnsupportedTypeSelfTest.assertEquals((Object)2, res.get(0).get(0));
        }
    }

    public static class Person {
        int id;
        Instant time;

        Person(int id, Instant time) {
            this.id = id;
            this.time = time;
        }
    }
}

