/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class IgniteCacheFullTextQueryRebuildSelfTest
extends GridCommonAbstractTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"db", (boolean)true);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
        CacheConfiguration cache = new CacheConfiguration("default");
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setQueryEntities(Arrays.asList(new QueryEntity().setKeyType(AffinityKey.class.getName()).setValueType(IndexedEntity.class.getName()).setKeyFields(new HashSet<String>(Arrays.asList("key", "affKey"))).addQueryField("key", Integer.class.getName(), null).addQueryField("affKey", Integer.class.getName(), null).addQueryField("val", String.class.getName(), null).setIndexes(Collections.singleton(new QueryIndex("val", QueryIndexType.FULLTEXT))), new QueryEntity().setKeyType(Long.class.getName()).setValueType(Integer.class.getName())));
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    @Test
    public void testFullTextQueryNodeRestart() throws Exception {
        IgniteEx crd = this.startGrids(1);
        crd.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = crd.cache("default");
        IgniteCacheFullTextQueryRebuildSelfTest.assertEquals((int)0, (int)cache.size(new CachePeekMode[0]));
        QueryCursor qry = cache.query((Query)new TextQuery(IndexedEntity.class, "full"));
        MatcherAssert.assertThat((Object)qry.getAll(), (Matcher)Matchers.hasSize((int)0));
        for (int i = 0; i < 1000; ++i) {
            IndexedEntity entity = new IndexedEntity("test full text " + i);
            this.grid(0).cache("default").put((Object)new AffinityKey((Object)i, (Object)i), (Object)entity);
        }
        qry = cache.query((Query)new TextQuery(IndexedEntity.class, "full"));
        MatcherAssert.assertThat((Object)qry.getAll(), (Matcher)Matchers.hasSize((int)1000));
        this.forceCheckpoint();
        this.stopAllGrids();
        crd = this.startGrids(1);
        cache = this.jcache(0, "default");
        qry = cache.query((Query)new TextQuery(IndexedEntity.class, "full"));
        MatcherAssert.assertThat((Object)qry.getAll(), (Matcher)Matchers.hasSize((int)1000));
    }

    private static class IndexedEntity {
        private String val;

        private IndexedEntity(String val) {
            this.val = val;
        }
    }
}

