/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridCacheOffheapIndexEntryEvictTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setNetworkTimeout(2000L);
        CacheConfiguration cacheCfg = GridCacheOffheapIndexEntryEvictTest.defaultCacheConfiguration();
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setBackups(1);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setEvictionPolicy(null);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, TestValue.class});
        cacheCfg.setNearConfiguration(null);
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWhenLocked() throws Exception {
        IgniteCache cache = this.grid(0).cache("default");
        ArrayList<Lock> locks = new ArrayList<Lock>();
        int ENTRIES = 1000;
        try {
            for (int i = 0; i < 1000; ++i) {
                cache.put((Object)i, (Object)new TestValue(i));
                Lock lock = cache.lock((Object)i);
                lock.lock();
                locks.add(lock);
                for (int j = 0; j < 3; ++j) {
                    GridCacheOffheapIndexEntryEvictTest.assertNotNull((Object)cache.get((Object)i));
                }
            }
            this.checkQuery((IgniteCache<Integer, TestValue>)cache, "_key >= 100", 900);
        }
        finally {
            for (Lock lock : locks) {
                lock.unlock();
            }
        }
    }

    @Test
    public void testUpdates() throws Exception {
        int i;
        int ENTRIES = 500;
        IgniteCache cache = this.grid(0).cache("default");
        for (i = 0; i < 500; ++i) {
            for (int j = 0; j < 3; ++j) {
                cache.getAndPut((Object)i, (Object)new TestValue(i));
                GridCacheOffheapIndexEntryEvictTest.assertNotNull((Object)cache.get((Object)i));
                GridCacheOffheapIndexEntryEvictTest.assertNotNull((Object)cache.localPeek((Object)i, new CachePeekMode[0]));
            }
            this.checkQuery((IgniteCache<Integer, TestValue>)cache, "_key >= 0", i + 1);
        }
        for (i = 0; i < 500; ++i) {
            if (i % 2 == 0) {
                cache.getAndRemove((Object)i);
            } else {
                cache.remove((Object)i);
            }
            this.checkQuery((IgniteCache<Integer, TestValue>)cache, "_key >= 0", 500 - (i + 1));
        }
    }

    private void checkQuery(IgniteCache<Integer, TestValue> cache, String sql, int expCnt) {
        SqlQuery qry = new SqlQuery(TestValue.class, sql);
        List res = cache.query((Query)qry).getAll();
        GridCacheOffheapIndexEntryEvictTest.assertEquals((int)expCnt, (int)res.size());
        for (Cache.Entry e : res) {
            GridCacheOffheapIndexEntryEvictTest.assertNotNull((Object)e.getKey());
            GridCacheOffheapIndexEntryEvictTest.assertEquals((int)((Integer)e.getKey()), (int)((TestValue)e.getValue()).val);
        }
    }

    static class TestValue
    implements Externalizable {
        private int val;

        public TestValue() {
        }

        public TestValue(int val) {
            this.val = val;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.val);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.val = in.readInt();
        }
    }
}

