/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridCacheOffHeapSelfTest
extends GridCommonAbstractTest {
    private final Map<Integer, Object> versions = new HashMap<Integer, Object>();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setNetworkTimeout(2000L);
        CacheConfiguration cacheCfg = GridCacheOffHeapSelfTest.defaultCacheConfiguration();
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setCacheMode(CacheMode.REPLICATED);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, CacheValue.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        cfg.setDeploymentMode(DeploymentMode.SHARED);
        return cfg;
    }

    protected void afterTestsStopped() throws Exception {
        this.versions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOffHeapIterator() throws Exception {
        try {
            int i;
            this.startGrids(1);
            this.grid(0);
            IgniteCache cache = this.grid(0).cache("default");
            for (i = 0; i < 100; ++i) {
                this.info("Putting: " + i);
                cache.put((Object)i, (Object)i);
            }
            i = 0;
            for (Cache.Entry e : cache.localEntries(new CachePeekMode[]{CachePeekMode.OFFHEAP})) {
                Integer key = (Integer)e.getKey();
                this.info("Key: " + key);
                ++i;
                cache.remove(e.getKey());
                GridCacheOffHeapSelfTest.assertNull((Object)cache.get((Object)key));
            }
            GridCacheOffHeapSelfTest.assertEquals((int)100, (int)i);
            assert (cache.localSize(new CachePeekMode[0]) == 0);
        }
        finally {
            this.stopAllGrids();
        }
    }

    private static class CacheValue {
        @QuerySqlField
        private final int val;

        private CacheValue(int val) {
            this.val = val;
        }

        public int value() {
            return this.val;
        }

        public String toString() {
            return S.toString(CacheValue.class, (Object)this);
        }
    }
}

