/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QueryTextField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridCacheFullTextQuerySelfTest
extends GridCommonAbstractTest {
    private static final int MAX_ITEM_COUNT = 100;
    private static final String PERSON_CACHE = "Person";

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setIncludeEventTypes(new int[0]);
        cfg.setConnectorConfiguration(null);
        CacheConfiguration cacheCfg = GridCacheFullTextQuerySelfTest.defaultCacheConfiguration();
        cacheCfg.setName(PERSON_CACHE).setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setBackups(0).setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGrids(2);
    }

    @Test
    public void testContinuousQueryWithInvalidInitialQuery() throws Exception {
        IgniteCache cache = this.grid(0).cache(PERSON_CACHE);
        Set<Integer> exp = GridCacheFullTextQuerySelfTest.populateCache(this.grid(0), true, 100, (IgnitePredicate<Integer>)(IgnitePredicate & Serializable)x -> String.valueOf(x).startsWith("1"));
        ContinuousQuery qry = new ContinuousQuery();
        qry.setInitialQuery((Query)new TextQuery(Person.class, "*"));
        qry.setLocalListener(evts -> {});
        QueryCursor cur = cache.query((Query)qry);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            cur.iterator().next();
            return null;
        }, IgniteCheckedException.class, (String)"Cannot parse '*': '*' or '?' not allowed as first character in WildcardQuery");
        cur.close();
    }

    @Test
    public void testTextQueryWithField() throws Exception {
        this.checkTextQuery("name:1*", false, false);
    }

    @Test
    public void testLocalTextQueryWithKeepBinary() throws Exception {
        this.checkTextQuery(true, true);
    }

    @Test
    public void testLocalTextQuery() throws Exception {
        this.checkTextQuery(true, false);
    }

    @Test
    public void testTextQueryWithKeepBinary() throws Exception {
        this.checkTextQuery(false, true);
    }

    @Test
    public void testTextQuery() throws Exception {
        this.checkTextQuery(false, true);
    }

    private void checkTextQuery(boolean loc, boolean keepBinary) throws Exception {
        this.checkTextQuery(null, loc, keepBinary);
    }

    private void checkTextQuery(String clause, boolean loc, boolean keepBinary) throws Exception {
        IgniteEx ignite = this.grid(0);
        if (F.isEmpty((String)clause)) {
            clause = "1*";
        }
        Set<Integer> exp = GridCacheFullTextQuerySelfTest.populateCache(ignite, loc, 100, new IgnitePredicate<Integer>(){

            public boolean apply(Integer x) {
                return String.valueOf(x).startsWith("1");
            }
        });
        TextQuery qry = new TextQuery(Person.class, clause).setLocal(loc);
        GridCacheFullTextQuerySelfTest.validateQueryResults(ignite, (Query)qry, exp, keepBinary);
        GridCacheFullTextQuerySelfTest.clearCache(ignite);
    }

    private static void clearCache(IgniteEx ignite) {
        IgniteCache cache = ignite.cache(PERSON_CACHE);
        cache.clear();
        List all = cache.query((Query)new TextQuery(Person.class, "1*")).getAll();
        GridCacheFullTextQuerySelfTest.assertTrue((boolean)all.isEmpty());
    }

    private static Set<Integer> populateCache(IgniteEx ignite, boolean loc, int cnt, IgnitePredicate<Integer> expectedEntryFilter) throws IgniteCheckedException {
        IgniteInternalCache cache = ignite.cachex(PERSON_CACHE);
        GridCacheFullTextQuerySelfTest.assertNotNull((Object)cache);
        Random rand = new Random();
        HashSet<Integer> exp = new HashSet<Integer>();
        Affinity aff = cache.affinity();
        ClusterNode localNode = cache.context().localNode();
        for (int i = 0; i < cnt; ++i) {
            int val = rand.nextInt(cnt);
            cache.put((Object)val, (Object)new Person(String.valueOf(val), val));
            if (!expectedEntryFilter.apply((Object)val) || loc && !aff.isPrimary(localNode, (Object)val)) continue;
            exp.add(val);
        }
        return exp;
    }

    private static void validateQueryResults(IgniteEx ignite, Query qry, Set<Integer> exp, boolean keepBinary) throws IgniteCheckedException {
        ArrayList<Object> all;
        HashSet<Integer> exp0;
        IgniteCache cache = ignite.cache(PERSON_CACHE);
        if (keepBinary) {
            ArrayList<Object> all2;
            HashSet<Integer> exp02;
            IgniteCache cache0 = cache.withKeepBinary();
            try (QueryCursor cursor = cache0.query(qry);){
                exp02 = new HashSet<Integer>(exp);
                all2 = new ArrayList();
                for (Cache.Entry entry : cursor.getAll()) {
                    all2.add(entry);
                    GridCacheFullTextQuerySelfTest.assertEquals((String)((Integer)entry.getKey()).toString(), (String)((String)((BinaryObject)entry.getValue()).field("name")));
                    GridCacheFullTextQuerySelfTest.assertEquals((Object)entry.getKey(), (Object)((BinaryObject)entry.getValue()).field("age"));
                    exp02.remove(entry.getKey());
                }
                GridCacheFullTextQuerySelfTest.checkForMissedKeys(ignite, exp02, all2);
            }
            cursor = cache0.query(qry);
            var7_9 = null;
            try {
                exp02 = new HashSet<Integer>(exp);
                all2 = new ArrayList();
                for (Cache.Entry entry : cursor.getAll()) {
                    all2.add(entry);
                    GridCacheFullTextQuerySelfTest.assertEquals((String)((Integer)entry.getKey()).toString(), (String)((String)((BinaryObject)entry.getValue()).field("name")));
                    GridCacheFullTextQuerySelfTest.assertEquals((Object)entry.getKey(), (Object)((BinaryObject)entry.getValue()).field("age"));
                    exp02.remove(entry.getKey());
                }
                GridCacheFullTextQuerySelfTest.checkForMissedKeys(ignite, exp02, all2);
            }
            catch (Throwable exp03) {
                var7_9 = exp03;
                throw exp03;
            }
            finally {
                if (cursor != null) {
                    if (var7_9 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable exp03) {
                            var7_9.addSuppressed(exp03);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        try (QueryCursor cursor = cache.query(qry);){
            exp0 = new HashSet<Integer>(exp);
            all = new ArrayList();
            for (Cache.Entry entry : cursor.getAll()) {
                all.add(entry);
                GridCacheFullTextQuerySelfTest.assertEquals((String)((Integer)entry.getKey()).toString(), (String)((Person)entry.getValue()).name);
                GridCacheFullTextQuerySelfTest.assertEquals((Object)entry.getKey(), (Object)((Person)entry.getValue()).age);
                exp0.remove(entry.getKey());
            }
            GridCacheFullTextQuerySelfTest.checkForMissedKeys(ignite, exp0, all);
        }
        cursor = cache.query(qry);
        var6_8 = null;
        try {
            exp0 = new HashSet<Integer>(exp);
            all = new ArrayList();
            for (Cache.Entry entry : cursor.getAll()) {
                all.add(entry);
                GridCacheFullTextQuerySelfTest.assertEquals((String)((Integer)entry.getKey()).toString(), (String)((Person)entry.getValue()).name);
                GridCacheFullTextQuerySelfTest.assertEquals((int)((Integer)entry.getKey()), (int)((Person)entry.getValue()).age);
                exp0.remove(entry.getKey());
            }
            GridCacheFullTextQuerySelfTest.checkForMissedKeys(ignite, exp0, all);
        }
        catch (Throwable throwable) {
            var6_8 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var6_8 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var6_8.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
    }

    private static void checkForMissedKeys(IgniteEx ignite, Collection<Integer> exp, List<Cache.Entry<Integer, ?>> all) throws IgniteCheckedException {
        if (exp.size() == 0) {
            return;
        }
        IgniteInternalCache cache = ignite.cachex(PERSON_CACHE);
        GridCacheFullTextQuerySelfTest.assertNotNull((Object)cache);
        StringBuilder sb = new StringBuilder();
        Affinity aff = cache.affinity();
        for (Integer n : exp) {
            Integer part = aff.partition((Object)n);
            sb.append(String.format("Query did not return expected key '%d' (exists: %s), partition '%d', partition nodes: ", n, cache.get((Object)n) != null, part));
            Collection partNodes = aff.mapPartitionToPrimaryAndBackups(part.intValue());
            for (ClusterNode node : partNodes) {
                sb.append(node).append("  ");
            }
            sb.append(";\n");
        }
        sb.append("Returned keys: ");
        for (Cache.Entry entry : all) {
            sb.append(entry.getKey()).append(" ");
        }
        sb.append(";\n");
        GridCacheFullTextQuerySelfTest.fail((String)sb.toString());
    }

    public static class Person
    implements Serializable {
        @QueryTextField
        String name;
        @QuerySqlField(index=true)
        int age;
        @QuerySqlField
        final Date birthday;

        public Person(String name, int age) {
            this.name = name;
            this.age = age % 2000;
            Calendar cal = Calendar.getInstance();
            cal.add(1, -age);
            this.birthday = cal.getTime();
        }
    }
}

