/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QueryTextField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.GridCacheAbstractSelfTest;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.junit.Test;

public class GridCacheFullTextQueryMultithreadedSelfTest
extends GridCacheAbstractSelfTest {
    private static final int GRID_CNT = 3;
    private static final int TEST_TIMEOUT = 900000;

    protected int gridCount() {
        return 3;
    }

    protected long getTestTimeout() {
        return 900000L;
    }

    protected CacheConfiguration cacheConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration cfg = super.cacheConfiguration(igniteInstanceName);
        cfg.setCacheMode(CacheMode.REPLICATED);
        cfg.setBackups(1);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setIndexedTypes(new Class[]{Integer.class, H2TextValue.class});
        return cfg;
    }

    @Test
    public void testH2Text() throws Exception {
        int duration = 20000;
        int keyCnt = 5000;
        int logFreq = 50;
        String txt = "Value";
        final GridCacheAdapter c = ((IgniteKernal)this.grid(0)).internalCache("default");
        IgniteInternalFuture fut1 = this.multithreadedAsync(new Callable(){

            public Object call() throws Exception {
                for (int i = 0; i < 5000; ++i) {
                    c.getAndPut((Object)i, (Object)new H2TextValue("Value"));
                    if (i % 50 != 0) continue;
                    X.println((String)("Stored values: " + i), (Object[])new Object[0]);
                }
                return null;
            }
        }, 1);
        final CacheQuery qry = c.context().queries().createFullTextQuery(H2TextValue.class.getSimpleName(), "Value", false);
        qry.enableDedup(false);
        qry.includeBackups(false);
        qry.timeout(900000L);
        final AtomicBoolean stop = new AtomicBoolean();
        IgniteInternalFuture fut2 = this.multithreadedAsync(new Callable(){

            public Object call() throws Exception {
                int cnt = 0;
                while (!stop.get()) {
                    CacheQueryFuture qryFut = qry.execute(new Object[0]);
                    int size = 0;
                    while (qryFut.next() != null) {
                        ++size;
                    }
                    if (++cnt % 50 != 0) continue;
                    X.println((String)("Result set: " + size), (Object[])new Object[0]);
                    X.println((String)("Executed queries: " + cnt), (Object[])new Object[0]);
                }
                return null;
            }
        }, 1);
        Thread.sleep(duration);
        fut1.get();
        stop.set(true);
        fut2.get();
    }

    private static class H2TextValue {
        @QueryTextField
        private final String val;

        H2TextValue(String val) {
            this.val = val;
        }

        String value() {
            return this.val;
        }

        public String toString() {
            return S.toString(H2TextValue.class, (Object)this);
        }
    }
}

