/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class GridCacheDynamicLoadOnClientTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "Person";
    private static final String PERSON_SCHEMA = "test";
    private static final int CACHE_ELEMENT_COUNT = 10;
    private static final String FULL_TABLE_NAME = "test.Person";
    protected boolean client;
    private static IgniteEx clientNode;
    private static IgniteEx srvNode;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setClientMode(this.client);
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.client = false;
        srvNode = (IgniteEx)this.startGridsMultiThreaded(1);
        this.client = true;
        clientNode = this.startGrid(1);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        clientNode.destroyCache(PERSON_CACHE);
        this.createAndFillServerCache();
    }

    @Test
    public void testBatchMerge() throws Exception {
        int BATCH_SIZE = 7;
        try (Connection con = GridCacheDynamicLoadOnClientTest.connect(clientNode);
             Statement stmt = con.createStatement();){
            int idx = 0;
            int i = 0;
            while (i < 7) {
                stmt.addBatch("merge into test.Person (_key, name, orgId) values (" + (100 + idx) + ",'batch-" + idx + "'," + idx + ")");
                idx += ++i;
            }
            int[] updCnts = stmt.executeBatch();
            GridCacheDynamicLoadOnClientTest.assertEquals((String)"Invalid update counts size", (int)7, (int)updCnts.length);
        }
    }

    @Test
    public void testClientJdbcDelete() throws Exception {
        try (Connection con = GridCacheDynamicLoadOnClientTest.connect(clientNode);
             Statement stmt = con.createStatement();){
            int cnt = stmt.executeUpdate("DELETE test.Person WHERE _key=1");
            Assert.assertEquals((long)1L, (long)cnt);
        }
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM test.Person");
        Assert.assertEquals((long)9L, (long)this.getDefaultCacheOnClient().query(qry).getAll().size());
    }

    @Test
    public void testClientJdbcInsert() throws Exception {
        try (Connection con = GridCacheDynamicLoadOnClientTest.connect(clientNode);
             Statement stmt = con.createStatement();){
            int cnt = stmt.executeUpdate("INSERT INTO test.Person(_key, name, orgId) VALUES(1000,'new_name', 10000)");
            Assert.assertEquals((long)1L, (long)cnt);
        }
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM test.Person");
        Assert.assertEquals((long)11L, (long)this.getDefaultCacheOnClient().query(qry).getAll().size());
    }

    @Test
    public void testClientJdbcUpdate() throws Exception {
        try (Connection con = GridCacheDynamicLoadOnClientTest.connect(clientNode);
             Statement stmt = con.createStatement();){
            int cnt = stmt.executeUpdate("UPDATE test.Person SET name = 'new_name'");
            Assert.assertEquals((long)10L, (long)cnt);
        }
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM test.Person WHERE name = 'new_name'");
        Assert.assertEquals((long)10L, (long)this.getDefaultCacheOnClient().query(qry).getAll().size());
    }

    @Test
    public void testClientJdbc() throws Exception {
        try (Connection con = GridCacheDynamicLoadOnClientTest.connect(clientNode);
             Statement st = con.createStatement();){
            ResultSet rs = st.executeQuery("SELECT count(*) FROM test.Person");
            rs.next();
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testClientPut() {
        clientNode.cache(PERSON_CACHE).put((Object)-100, (Object)new Person(-100, "name-"));
        Assert.assertEquals((long)11L, (long)clientNode.cache(PERSON_CACHE).size(new CachePeekMode[0]));
    }

    @Test
    public void testCreateIdxOnClient() {
        this.getDefaultCacheOnClient().query(new SqlFieldsQuery("CREATE INDEX IDX_11 ON test.Person (name asc)")).getAll();
    }

    @Test
    public void testDropIdxOnClient() {
        srvNode.getOrCreateCache("default").query(new SqlFieldsQuery("CREATE INDEX IDX_TST ON test.Person (name desc)")).getAll();
        GridCacheDynamicLoadOnClientTest.doSleep((long)2000L);
        this.getDefaultCacheOnClient().query(new SqlFieldsQuery("DROP INDEX test.IDX_TST")).getAll();
    }

    @Test
    public void testClientSqlFieldsQuery() {
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT * FROM test.Person");
        Assert.assertEquals((long)10L, (long)this.getDefaultCacheOnClient().query(qry).getAll().size());
    }

    @Test
    public void testClientSqlQuery() {
        SqlQuery qry = new SqlQuery(PERSON_CACHE, "FROM Person");
        Assert.assertEquals((long)10L, (long)clientNode.getOrCreateCache(PERSON_CACHE).query((Query)qry).getAll().size());
    }

    private IgniteCache getDefaultCacheOnClient() {
        return clientNode.getOrCreateCache("default");
    }

    private void createAndFillServerCache() {
        srvNode.createCache(this.cacheConfiguration());
        for (int i = 0; i < 10; ++i) {
            srvNode.cache(PERSON_CACHE).put((Object)i, (Object)new Person(i, "name-" + i));
        }
    }

    private CacheConfiguration<?, ?> cacheConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration(PERSON_CACHE);
        ccfg.setSqlSchema(PERSON_SCHEMA);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        QueryEntity person = new QueryEntity();
        person.setKeyType(Integer.class.getName());
        person.setValueType(Person.class.getName());
        person.addQueryField("orgId", Integer.class.getName(), null);
        person.addQueryField("name", String.class.getName(), null);
        person.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("orgId"), new QueryIndex("name")}));
        ccfg.setQueryEntities((Collection)F.asList((Object)person));
        return ccfg;
    }

    private static Connection connect(IgniteEx node) throws SQLException {
        Collection recs = node.context().ports().records();
        GridPortRecord cliLsnrRec = null;
        for (GridPortRecord rec : recs) {
            if (rec.clazz() != ClientListenerProcessor.class) continue;
            cliLsnrRec = rec;
            break;
        }
        String connStr = "jdbc:ignite:thin://127.0.0.1:" + cliLsnrRec.port();
        return DriverManager.getConnection(connStr);
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        int orgId;
        @QuerySqlField
        String name;

        Person(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }
}

