/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class EnumClassImplementingIndexedInterfaceTest
extends GridCommonAbstractTest {
    private static final String PERSON_CACHE = "Person";
    private static IgniteEx ignite;
    private static final int KEY = 0;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        ignite = this.startGrids(2);
    }

    protected void afterTest() throws Exception {
        ignite.destroyCache(PERSON_CACHE);
    }

    @Test
    @WithSystemProperty(key="IGNITE_SENSITIVE_DATA_LOGGING", value="hash")
    public void testInsertTableVarColumns() {
        this.checkCachePutInsert(this.startSqlPersonCache());
    }

    @Test
    @WithSystemProperty(key="IGNITE_SENSITIVE_DATA_LOGGING", value="hash")
    public void testInsertValueVarColumns() {
        this.checkCachePutInsert(this.startPersonCache());
    }

    private void checkCachePutInsert(IgniteCache<Integer, Person> cache) {
        SqlFieldsQuery sqlSelect = new SqlFieldsQuery("SELECT CONVERT(role, varchar), CONVERT(title, varchar) from Person");
        Arrays.stream(RoleEnum.values()).forEach(role -> {
            Title title = role.ordinal() % 2 == 0 ? new TitleClass1() : new TitleClass2();
            Person person = new Person((Role)role, title, role.toString());
            cache.put((Object)0, (Object)person);
            EnumClassImplementingIndexedInterfaceTest.assertEquals((Object)person, (Object)cache.get((Object)0));
            cache.clear();
            cache.query(this.sqlInsertQuery((Role)role, title, role.toString()));
            EnumClassImplementingIndexedInterfaceTest.assertEquals((Object)person, (Object)cache.get((Object)0));
            List res = cache.query(sqlSelect).getAll();
            Object checkEnum = ((List)res.get(0)).get(0);
            EnumClassImplementingIndexedInterfaceTest.assertEquals((Object)role.toString(), checkEnum);
            Object checkCustom = ((List)res.get(0)).get(1);
            EnumClassImplementingIndexedInterfaceTest.assertEquals((Object)title.toString(), checkCustom);
            cache.clear();
        });
    }

    private IgniteCache<Integer, Person> startPersonCache() {
        return ignite.createCache(new CacheConfiguration().setName(PERSON_CACHE).setQueryEntities(Collections.singletonList(this.personQueryEntity())));
    }

    private IgniteCache<Integer, Person> startSqlPersonCache() {
        ignite.context().query().querySqlFields(new SqlFieldsQuery("create table Person(   id int PRIMARY KEY,   role Object,   title Object,   desc varchar(5)) with \"CACHE_NAME=Person,VALUE_TYPE=" + Person.class.getName() + "\""), false);
        return ignite.cache(PERSON_CACHE);
    }

    private SqlFieldsQuery sqlInsertQuery(Role role, Title title, String description) {
        return new SqlFieldsQuery("insert into Person(id, role, title, desc) values (?, ?, ?, ?)").setArgs(new Object[]{0, role, title, description});
    }

    private QueryEntity personQueryEntity() {
        QueryEntity entity = new QueryEntity(Integer.class, Person.class);
        entity.setKeyFieldName("id");
        entity.addQueryField("id", Integer.class.getName(), "ID");
        return entity;
    }

    static class Person {
        @QuerySqlField(index=true)
        private final Role role;
        @QuerySqlField(index=true)
        private final Title title;
        @QuerySqlField
        private final String desc;

        Person(Role role, Title title, String desc) {
            this.role = role;
            this.title = title;
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return Objects.equals(this.role, person.role) && Objects.equals(this.title, person.title) && Objects.equals(this.desc, person.desc);
        }

        public int hashCode() {
            int result = Objects.hash(this.role);
            result = 31 * result + Objects.hash(this.title);
            result = 31 * result + Objects.hash(this.desc);
            return result;
        }
    }

    static class TitleClass2
    implements Title {
        private final String title2 = "title2";

        TitleClass2() {
        }

        @Override
        public String getTitle() {
            return "title2";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TitleClass2 titleCls = (TitleClass2)o;
            return Objects.equals("title2", titleCls.title2);
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "title2";
        }
    }

    static class TitleClass1
    implements Title {
        private final String title1 = "title1";

        TitleClass1() {
        }

        @Override
        public String getTitle() {
            return "title1";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TitleClass1 titleCls = (TitleClass1)o;
            return Objects.equals("title1", titleCls.title1);
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "title1";
        }
    }

    static interface Title {
        public String getTitle();
    }

    static enum RoleEnum implements Role
    {
        ROLE1,
        ROLE2,
        ROLE3;

    }

    static interface Role {
    }
}

