/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.binary.MetadataRequestMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataResponseMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateAcceptedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateProposedMessage;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class CacheRegisterMetadataLocallyTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String STATIC_CACHE_NAME = "staticCache";
    private static final String DYNAMIC_CACHE_NAME = "dynamicCache";
    private final ConcurrentLinkedQueue<Object> customMessages = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Object> communicationMessages = new ConcurrentLinkedQueue();

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(this.persistenceEnabled())));
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi(){

            public void sendCustomEvent(DiscoverySpiCustomMessage msg) throws IgniteException {
                DiscoveryCustomMessage realMsg;
                if (msg instanceof CustomMessageWrapper && ((realMsg = ((CustomMessageWrapper)msg).delegate()) instanceof MetadataUpdateProposedMessage || realMsg instanceof MetadataUpdateAcceptedMessage)) {
                    CacheRegisterMetadataLocallyTest.this.customMessages.add(realMsg);
                }
                super.sendCustomEvent(msg);
            }
        });
        cfg.setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi(){

            public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
                if (msg instanceof GridIoMessage) {
                    CacheRegisterMetadataLocallyTest.this.communicationMessages.add(((GridIoMessage)msg).message());
                }
                super.sendMessage(node, msg, ackC);
            }

            public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
                if (msg instanceof GridIoMessage) {
                    CacheRegisterMetadataLocallyTest.this.communicationMessages.add(((GridIoMessage)msg).message());
                }
                super.sendMessage(node, msg);
            }
        });
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(IP_FINDER);
        if (igniteInstanceName.equals("client")) {
            cfg.setClientMode(true);
        }
        cfg.setCacheConfiguration(new CacheConfiguration[]{CacheRegisterMetadataLocallyTest.cacheConfiguration(STATIC_CACHE_NAME, StaticKey.class, StaticValue.class)});
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.customMessages.clear();
        this.communicationMessages.clear();
    }

    protected boolean persistenceEnabled() {
        return false;
    }

    @Test
    public void testAffinityKeyRegisteredStaticCache() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        CacheRegisterMetadataLocallyTest.assertEquals((String)"affKey", (String)this.getAffinityKey((Ignite)ignite, StaticKey.class));
        CacheRegisterMetadataLocallyTest.assertEquals((String)"affKey", (String)this.getAffinityKey((Ignite)ignite, StaticValue.class));
    }

    @Test
    public void testAffinityKeyRegisteredDynamicCache() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().state(ClusterState.ACTIVE);
        ignite.createCache(CacheRegisterMetadataLocallyTest.cacheConfiguration(DYNAMIC_CACHE_NAME, DynamicKey.class, DynamicValue.class));
        CacheRegisterMetadataLocallyTest.assertEquals((String)"affKey", (String)this.getAffinityKey((Ignite)ignite, DynamicKey.class));
        CacheRegisterMetadataLocallyTest.assertEquals((String)"affKey", (String)this.getAffinityKey((Ignite)ignite, DynamicValue.class));
    }

    @Test
    public void testClientFindsValueByAffinityKeyStaticCacheWithoutExtraRequest() throws Exception {
        IgniteEx srv = this.startGrid(0);
        srv.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = srv.cache(STATIC_CACHE_NAME);
        this.testClientAndServerFindsValueByAffinityKey(cache, new StaticKey(1), new StaticValue(2));
        this.assertCustomMessages(2);
        this.assertCommunicationMessages();
    }

    @Test
    public void testClientFindsValueByAffinityKeyDynamicCacheWithoutExtraRequest() throws Exception {
        IgniteEx srv = this.startGrid(0);
        srv.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = srv.createCache(CacheRegisterMetadataLocallyTest.cacheConfiguration(DYNAMIC_CACHE_NAME, DynamicKey.class, DynamicValue.class));
        this.testClientAndServerFindsValueByAffinityKey(cache, new DynamicKey(3), new DynamicValue(4));
        this.assertCustomMessages(2);
        this.assertCommunicationMessages();
    }

    private <K> String getAffinityKey(Ignite ignite, Class<K> keyCls) {
        BinaryType binType = ignite.binary().type(keyCls);
        CacheRegisterMetadataLocallyTest.assertNotNull((Object)binType);
        return binType.affinityKeyFieldName();
    }

    private <K, V> void testClientAndServerFindsValueByAffinityKey(IgniteCache<K, V> cache, K key, V val) throws Exception {
        cache.put(key, val);
        CacheRegisterMetadataLocallyTest.assertTrue((boolean)cache.containsKey(key));
        IgniteEx client = this.startGrid("client");
        IgniteCache clientCache = client.cache(cache.getName());
        CacheRegisterMetadataLocallyTest.assertTrue((boolean)clientCache.containsKey(key));
        IgniteEx server = this.startGrid(1);
        IgniteCache serverCache = server.cache(cache.getName());
        CacheRegisterMetadataLocallyTest.assertTrue((boolean)serverCache.containsKey(key));
    }

    private static <K, V> CacheConfiguration<K, V> cacheConfiguration(String name, Class<K> keyCls, Class<V> valCls) {
        CacheConfiguration cfg = new CacheConfiguration(name);
        cfg.setQueryEntities(Collections.singleton(new QueryEntity(keyCls, valCls)));
        return cfg;
    }

    private void assertCustomMessages(int expMsgCnt) {
        CacheRegisterMetadataLocallyTest.assertEquals((String)this.customMessages.toString(), (int)expMsgCnt, (int)this.customMessages.size());
        this.customMessages.forEach(cm -> CacheRegisterMetadataLocallyTest.assertTrue((String)cm.toString(), (cm instanceof DynamicCacheChangeBatch || cm instanceof MetadataUpdateProposedMessage ? 1 : 0) != 0));
    }

    private void assertCommunicationMessages() {
        this.communicationMessages.forEach(cm -> CacheRegisterMetadataLocallyTest.assertFalse((String)cm.toString(), (cm instanceof MetadataRequestMessage || cm instanceof MetadataResponseMessage ? 1 : 0) != 0));
    }

    private static class DynamicValue {
        @AffinityKeyMapped
        private int affKey;

        DynamicValue(int affKey) {
            this.affKey = affKey;
        }
    }

    private static class DynamicKey {
        @AffinityKeyMapped
        private int affKey;

        DynamicKey(int affKey) {
            this.affKey = affKey;
        }
    }

    private static class StaticValue {
        @AffinityKeyMapped
        private int affKey;

        StaticValue(int affKey) {
        }
    }

    private static class StaticKey {
        @AffinityKeyMapped
        private int affKey;

        StaticKey(int affKey) {
            this.affKey = affKey;
        }
    }
}

