/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class CacheBinaryKeyConcurrentQueryTest
extends GridCommonAbstractTest {
    private static final int NODES = 3;
    private static final int KEYS = 1000;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setMarshaller(null);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    @Test
    public void testPutAndQueries() throws Exception {
        IgniteEx ignite = this.ignite(0);
        IgniteCache cache1 = ignite.createCache(this.cacheConfiguration("cache1", CacheAtomicityMode.ATOMIC));
        IgniteCache cache2 = ignite.createCache(this.cacheConfiguration("cache2", CacheAtomicityMode.TRANSACTIONAL));
        this.insertData((Ignite)ignite, cache1.getName());
        this.insertData((Ignite)ignite, cache2.getName());
        IgniteInternalFuture<?> fut1 = this.startUpdate(cache1.getName());
        IgniteInternalFuture<?> fut2 = this.startUpdate(cache2.getName());
        fut1.get();
        fut2.get();
    }

    private IgniteInternalFuture<?> startUpdate(final String cacheName) {
        final long stopTime = System.currentTimeMillis() + 30000L;
        final AtomicInteger idx = new AtomicInteger();
        return GridTestUtils.runMultiThreadedAsync((Callable)new Callable<Object>(){

            @Override
            public Void call() {
                ThreadLocalRandom rnd = ThreadLocalRandom.current();
                IgniteCache cache = CacheBinaryKeyConcurrentQueryTest.this.ignite(idx.getAndIncrement() % 3).cache(cacheName).withKeepBinary();
                block7: while (System.currentTimeMillis() < stopTime) {
                    switch (rnd.nextInt(5)) {
                        case 0: {
                            TestKey key = new TestKey(rnd.nextInt(1000));
                            CacheEntry e = cache.getEntry((Object)key);
                            CacheBinaryKeyConcurrentQueryTest.assertNotNull((Object)e);
                            CacheBinaryKeyConcurrentQueryTest.assertTrue((boolean)(e.getKey() instanceof BinaryObject));
                            cache.put(e.getKey(), (Object)new TestValue(rnd.nextInt(1000)));
                            continue block7;
                        }
                        case 1: {
                            Iterator it = cache.iterator();
                            for (int i = 0; i < 100 && it.hasNext(); ++i) {
                                Cache.Entry e = (Cache.Entry)it.next();
                                CacheBinaryKeyConcurrentQueryTest.assertTrue((boolean)(e.getKey() instanceof BinaryObject));
                                cache.put(e.getKey(), (Object)new TestValue(rnd.nextInt(1000)));
                            }
                            continue block7;
                        }
                        case 2: {
                            SqlQuery qry = new SqlFieldsQuery("select _key from \"" + cache.getName() + "\".TestValue where id=?");
                            qry.setArgs(new Object[]{rnd.nextInt(1000)});
                            List res = cache.query((SqlFieldsQuery)qry).getAll();
                            CacheBinaryKeyConcurrentQueryTest.assertEquals((int)1, (int)res.size());
                            BinaryObject key = (BinaryObject)((List)res.get(0)).get(0);
                            cache.put((Object)key, (Object)new TestValue(rnd.nextInt(1000)));
                            continue block7;
                        }
                        case 3: {
                            SqlQuery qry = new SqlQuery("TestValue", "id=?");
                            qry.setArgs(new Object[]{rnd.nextInt(1000)});
                            List res = cache.query((Query)qry).getAll();
                            CacheBinaryKeyConcurrentQueryTest.assertEquals((int)1, (int)res.size());
                            continue block7;
                        }
                        case 4: {
                            SqlQuery qry = new SqlQuery("TestValue", "order by id");
                            int cnt = 0;
                            for (Cache.Entry e : cache.query((Query)qry)) {
                                CacheBinaryKeyConcurrentQueryTest.assertNotNull((Object)cache.get(e.getKey()));
                                ++cnt;
                            }
                            CacheBinaryKeyConcurrentQueryTest.assertTrue((boolean)(cnt > 0));
                            continue block7;
                        }
                    }
                    CacheBinaryKeyConcurrentQueryTest.fail();
                }
                return null;
            }
        }, (int)6, (String)"test-thread");
    }

    private void insertData(Ignite ignite, String cacheName) {
        try (IgniteDataStreamer streamer = ignite.dataStreamer(cacheName);){
            for (int i = 0; i < 1000; ++i) {
                streamer.addData((Object)new TestKey(i), (Object)new TestValue(i));
            }
        }
    }

    private CacheConfiguration cacheConfiguration(String name, CacheAtomicityMode atomicityMode) {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setName(name);
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAtomicityMode(atomicityMode);
        ccfg.setBackups(1);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(TestKey.class.getName());
        qryEntity.setValueType(TestValue.class.getName());
        qryEntity.addQueryField("id", Integer.class.getName(), null);
        qryEntity.addQueryField("val", Integer.class.getName(), null);
        qryEntity.setKeyFields(Collections.singleton("id"));
        qryEntity.setIndexes((Collection)F.asList((Object[])new QueryIndex[]{new QueryIndex("id"), new QueryIndex("val")}));
        ccfg.setQueryEntities((Collection)F.asList((Object)qryEntity));
        return ccfg;
    }

    static class TestValue {
        @QuerySqlField(index=true)
        private int val;

        public TestValue(int val) {
            this.val = val;
        }
    }

    static class TestKey {
        @QuerySqlField(index=true)
        private int id;

        public TestKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey testKey = (TestKey)o;
            return this.id == testKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

