/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class BinaryTypeMismatchLoggingTest
extends GridCommonAbstractTest {
    public static final String MESSAGE_PAYLOAD_VALUE = "expValType=Payload, actualValType=o.a.i.i.processors.cache.BinaryTypeMismatchLoggingTest$Payload";
    private GridStringLogger capture;

    @Test
    public void testValueReadCreateTable() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteCache def = ignite.createCache("default");
        def.query(new SqlFieldsQuery("CREATE TABLE binary (id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=binary, value_type=Payload\"").setSchema("PUBLIC"));
        def.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (1, 'foo');").setSchema("PUBLIC"));
        def.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (2, 'bar');").setSchema("PUBLIC"));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)ignite){
            final /* synthetic */ Ignite val$ignite;
            {
                this.val$ignite = ignite;
            }

            @Override
            public Object call() {
                return this.val$ignite.cache("binary").get((Object)1);
            }
        }, BinaryInvalidTypeException.class, (String)"Payload");
    }

    @Test
    public void testValueReadQueryEntities() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", "java.lang.Integer");
        fields.put("str", "java.lang.String");
        IgniteCache binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Collections.singleton(new QueryEntity().setKeyFieldName("id").setValueType("Payload").setFields(fields).setTableName("binary"))));
        binary.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (1, 'foo');"));
        binary.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (2, 'bar');"));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)ignite){
            final /* synthetic */ Ignite val$ignite;
            {
                this.val$ignite = ignite;
            }

            @Override
            public Object call() {
                return this.val$ignite.cache("binary").get((Object)1);
            }
        }, BinaryInvalidTypeException.class, (String)"Payload");
    }

    @Test
    public void testEntryReadCreateTable() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        IgniteCache def = ignite.createCache("default");
        def.query(new SqlFieldsQuery("CREATE TABLE binary (id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=binary, key_type=IdKey, value_type=Payload\"").setSchema("PUBLIC"));
        def.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (1, 'foo');").setSchema("PUBLIC"));
        def.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (2, 'bar');").setSchema("PUBLIC"));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)ignite){
            final /* synthetic */ Ignite val$ignite;
            {
                this.val$ignite = ignite;
            }

            @Override
            public Object call() {
                return this.val$ignite.cache("binary").iterator().next();
            }
        }, BinaryInvalidTypeException.class, (String)"IdKey");
    }

    @Test
    public void testEntryReadQueryEntities() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", "java.lang.Integer");
        fields.put("str", "java.lang.String");
        IgniteCache binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType("IdKey").setKeyFields(Collections.singleton("id")).setValueType("Payload").setFields(fields).setTableName("binary"))));
        binary.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (1, 'foo');"));
        binary.query(new SqlFieldsQuery("INSERT INTO binary (id, str) VALUES (2, 'bar');"));
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Object>((Ignite)ignite){
            final /* synthetic */ Ignite val$ignite;
            {
                this.val$ignite = ignite;
            }

            @Override
            public Object call() {
                return this.val$ignite.cache("binary").iterator().next();
            }
        }, BinaryInvalidTypeException.class, (String)"IdKey");
    }

    @Test
    public void testValueWriteCreateTable() throws Exception {
        IgniteEx ignite = this.startGridWithLogCapture();
        IgniteCache def = ignite.createCache("default");
        def.query(new SqlFieldsQuery("CREATE TABLE binary (id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=binary, value_type=Payload\"").setSchema("PUBLIC"));
        IgniteCache binary = ignite.cache("binary");
        binary.put((Object)1, (Object)new Payload("foo"));
        binary.put((Object)2, (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        String capturedMessages = this.capture.toString();
        this.assertContainsExactlyOnce(capturedMessages, "Key-value pair is not inserted into any SQL table [cacheName=binary, expValType=Payload, actualValType=o.a.i.i.processors.cache.BinaryTypeMismatchLoggingTest$Payload]");
        this.assertContainsExactlyOnce(capturedMessages, "Value type(s) are specified via CacheConfiguration.indexedTypes or CacheConfiguration.queryEntities");
        this.assertContainsExactlyOnce(capturedMessages, "Make sure that same type(s) used when adding Object or BinaryObject to cache");
        this.assertContainsExactlyOnce(capturedMessages, "Otherwise, entries will be stored in cache, but not appear as SQL Table rows");
    }

    @Test
    public void testValueWriteQueryEntities() throws Exception {
        IgniteEx ignite = this.startGridWithLogCapture();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", "java.lang.Integer");
        fields.put("str", "java.lang.String");
        IgniteCache binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Collections.singleton(new QueryEntity().setKeyFieldName("id").setValueType("Payload").setFields(fields).setTableName("binary"))));
        binary.put((Object)1, (Object)new Payload("foo"));
        binary.put((Object)2, (Object)new IdKey(2));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        this.assertContainsExactlyOnce(this.capture.toString(), MESSAGE_PAYLOAD_VALUE);
        this.assertContainsExactlyOnce(this.capture.toString(), "expValType=Payload, actualValType=o.a.i.i.processors.cache.BinaryTypeMismatchLoggingTest$IdKey");
    }

    @Test
    public void testEntryWriteCreateTable() throws Exception {
        IgniteEx ignite = this.startGridWithLogCapture();
        IgniteCache def = ignite.createCache("default");
        def.query(new SqlFieldsQuery("CREATE TABLE binary (id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=binary, key_type=IdKey, value_type=Payload\"").setSchema("PUBLIC"));
        IgniteCache binary = ignite.cache("binary");
        binary.put((Object)1, (Object)new Payload("foo"));
        binary.put((Object)2, (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        this.assertContainsExactlyOnce(this.capture.toString(), MESSAGE_PAYLOAD_VALUE);
        this.capture.reset();
        def.query(new SqlFieldsQuery("CREATE TABLE binary2 (id INT PRIMARY KEY, str VARCHAR) WITH \"cache_name=binary2, key_type=IdKey, value_type=Payload\"").setSchema("PUBLIC"));
        IgniteCache binary2 = ignite.cache("binary2");
        binary2.put((Object)1, (Object)new Payload("foo"));
        binary2.put((Object)2, (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary2));
        this.assertContainsExactlyOnce(this.capture.toString(), MESSAGE_PAYLOAD_VALUE);
    }

    @Test
    public void testEntryWriteQueryEntities() throws Exception {
        IgniteEx ignite = this.startGridWithLogCapture();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", "java.lang.Integer");
        fields.put("str", "java.lang.String");
        IgniteCache binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType("IdKey").setKeyFields(Collections.singleton("id")).setValueType("Payload").setFields(fields).setTableName("binary"))));
        binary.put((Object)new IdKey(1), (Object)new Payload("foo"));
        binary.put((Object)new IdKey(2), (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        binary.destroy();
        binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType("IdKey").setKeyFields(Collections.singleton("id")).setValueType("Payload").setFields(fields).setTableName("binary"))));
        binary.put((Object)new IdKey(1), (Object)new Payload("foo"));
        binary.put((Object)new IdKey(2), (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        this.assertContainsExactlyOnce(this.capture.toString(), MESSAGE_PAYLOAD_VALUE);
    }

    @Test
    public void testEntryWriteCacheIsolation() throws Exception {
        IgniteEx ignite = this.startGridWithLogCapture();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", "java.lang.Integer");
        fields.put("str", "java.lang.String");
        IgniteCache regular = ignite.createCache(new CacheConfiguration().setName("regular").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType(((Object)((Object)this)).getClass().getName() + "$IdKey").setKeyFields(Collections.singleton("id")).setValueType(((Object)((Object)this)).getClass().getName() + "$Payload").setFields(fields).setTableName("binary"))));
        IgniteCache binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Collections.singleton(new QueryEntity().setKeyType("IdKey").setKeyFields(Collections.singleton("id")).setValueType("Payload").setFields(fields).setTableName("binary"))));
        regular.put((Object)new IdKey(1), (Object)new Payload("foo"));
        regular.put((Object)new IdKey(2), (Object)new Payload("bar"));
        binary.put((Object)new IdKey(1), (Object)new Payload("foo"));
        binary.put((Object)new IdKey(2), (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        BinaryTypeMismatchLoggingTest.assertEquals((int)2, (int)this.countRows(regular));
        this.assertContainsExactlyOnce(this.capture.toString(), MESSAGE_PAYLOAD_VALUE);
    }

    @Test
    public void testValueWriteMultipleQueryEntities() throws Exception {
        IgniteEx ignite = this.startGridWithLogCapture();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("id", "java.lang.Integer");
        fields.put("str", "java.lang.String");
        IgniteCache binary = ignite.createCache(new CacheConfiguration().setName("binary").setQueryEntities(Arrays.asList(new QueryEntity().setKeyType("Foo").setKeyFieldName("id").setValueType("Bar").setFields(fields).setTableName("regular"), new QueryEntity().setKeyFieldName("id").setValueType("Payload").setFields(fields).setTableName("binary"))));
        binary.put((Object)1, (Object)new Payload("foo"));
        binary.put((Object)2, (Object)new Payload("bar"));
        BinaryTypeMismatchLoggingTest.assertEquals((int)0, (int)this.countRows(binary));
        this.assertContainsExactlyOnce(this.capture.toString(), "valType=o.a.i.i.processors.cache.BinaryTypeMismatchLoggingTest$Payload");
    }

    private <K> int countRows(IgniteCache<K, ?> binary) {
        SqlFieldsQuery qry = new SqlFieldsQuery("SELECT COUNT(*) FROM binary");
        List result = binary.query(qry).getAll();
        return ((Number)Number.class.cast(((List)result.get(0)).get(0))).intValue();
    }

    private void assertContainsExactlyOnce(String capturedMessages, String message) {
        BinaryTypeMismatchLoggingTest.assertTrue((boolean)capturedMessages.contains(message));
        BinaryTypeMismatchLoggingTest.assertEquals((int)-1, (int)capturedMessages.indexOf(message, capturedMessages.indexOf(message) + 1));
    }

    private IgniteEx startGridWithLogCapture() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        this.capture = new GridStringLogger(false, log);
        GridTestUtils.setFieldValue((Object)ignite.context().query(), GridProcessorAdapter.class, (String)"log", (Object)this.capture);
        return ignite;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private static class Payload {
        @QuerySqlField
        private final String str;

        public Payload(String str) {
            this.str = str;
        }
    }

    private static class IdKey {
        @QuerySqlField
        private final int id;

        public IdKey(int id) {
            this.id = id;
        }
    }
}

