/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class BigEntryQueryTest
extends GridCommonAbstractTest {
    public static final String CACHE = "cache";

    protected long getTestTimeout() {
        return 60000L;
    }

    @Test
    public void testBigEntriesSelect() throws Exception {
        this.startGrids(2);
        Random random = new Random(1L);
        Ignition.setClientMode((boolean)true);
        IgniteEx client = this.startGrid(2);
        int ctr = 0;
        int testDuration = GridTestUtils.SF.applyLB((int)30000, (int)10000);
        long time0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - time0 < (long)testDuration) {
            String cacheName = CACHE + ctr++;
            IgniteCache cache = client.getOrCreateCache(new CacheConfiguration(cacheName).setCacheMode(CacheMode.PARTITIONED).setBackups(1).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC).setIndexedTypes(new Class[]{Long.class, Value.class}));
            cache.putAll((Map)LongStream.range(610026643276160000L, 610026643276170000L).boxed().collect(Collectors.toMap(Function.identity(), t -> Value.of(new byte[random.nextInt(16) * 1000]), (a, b) -> a, TreeMap::new)));
            for (int i = 0; i < 10; ++i) {
                ArrayList resultKeys;
                long start = 610026643276160000L;
                long end = start + (long)random.nextInt(10);
                int expectedResultCount = (int)(end - start + 1L);
                String sql = String.format("SELECT _KEY FROM %s WHERE _KEY >= %d AND _KEY <= %d", Value.class.getSimpleName().toLowerCase(), start, end);
                HashSet<Long> keySet = new HashSet<Long>();
                for (long l = start; l < end + 1L; ++l) {
                    keySet.add(l);
                }
                try (FieldsQueryCursor results = cache.query(new SqlFieldsQuery(sql));){
                    resultKeys = new ArrayList();
                    results.forEach(objects -> resultKeys.add((Long)objects.get(0)));
                    Collections.sort(resultKeys);
                }
                BigEntryQueryTest.assertEquals((int)expectedResultCount, (int)resultKeys.size());
            }
            cache.destroy();
        }
    }

    protected IgniteConfiguration getConfiguration() throws Exception {
        IgniteConfiguration cfg = super.getConfiguration();
        cfg.setIncludeEventTypes(new int[]{86});
        DataStorageConfiguration sCfg = new DataStorageConfiguration();
        sCfg.setPageSize(8192);
        cfg.setDataStorageConfiguration(sCfg);
        return cfg;
    }

    public static class Value
    implements Serializable {
        final byte[] data;

        public Value(byte[] data) {
            this.data = data;
        }

        public static Value of(byte[] bytes) {
            return new Value(bytes);
        }
    }
}

