/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import javax.management.ObjectName;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.SqlConfiguration;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class SqlQueryMXBeanImplTest
extends GridCommonAbstractTest {
    public SqlQueryMXBeanImplTest() {
        super(true);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setSqlConfiguration(new SqlConfiguration().setSqlGlobalMemoryQuota("20m").setSqlQueryMemoryQuota("10m").setLongQueryWarningTimeout(30000L).setSqlOffloadingEnabled(true));
        return cfg;
    }

    @Test
    public void testSqlQueryMXBeanImplJMXAttrs() throws Exception {
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "SqlQueryMemoryQuotaBytes", 0xA00000L);
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "SqlGlobalMemoryQuotaBytes", 0x1400000L);
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "SqlFreeMemoryBytes", 0x1400000L);
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "SqlQueryMemoryQuota", "10m");
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "SqlGlobalMemoryQuota", "20m");
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "LongQueryWarningTimeout", 30000L);
        this.checkBean("SQL Query", "SqlQueryMXBeanImpl", "SqlOffloadingEnabled", true);
    }

    private void checkBean(String grp, String name, String attributeName, Object expAttributeVal) throws Exception {
        ObjectName mBeanName = IgniteUtils.makeMBeanName((String)this.grid().name(), (String)grp, (String)name);
        Object attributeVal = this.grid().configuration().getMBeanServer().getAttribute(mBeanName, attributeName);
        SqlQueryMXBeanImplTest.assertEquals((Object)expAttributeVal, (Object)attributeVal);
    }
}

